/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#ifndef __AGSYNCCESTREAMPROTOCOL_H__
#define __AGSYNCCESTREAMPROTOCOL_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <AGReader.h>
#include <AGWriter.h>
#include <AGProtocol.h>
#include <AGUserConfig.h>

struct IRAPIStream;

AGReader * AGSyncCEStreamCreateRAPIReader(IRAPIStream * rapiStream);
AGWriter * AGSyncCEStreamCreateRAPIWriter(IRAPIStream * rapiStream);

/* Sequence tags for IRAPIStream between desktop and device. */
typedef enum {
    AGCE_STREAM_END = 0,
    AGCE_STREAM_PERFORM_COMMAND,
    AGCE_STREAM_OPEN_DATABASE,
    AGCE_STREAM_GET_NEXT_RECORD,
    AGCE_STREAM_GET_NEXT_MODIFIED_RECORD,
    AGCE_STREAM_GET_NEXT_EXPANSION_COMMAND,
    AGCE_STREAM_START_SERVER,
    AGCE_STREAM_END_SERVER,
    AGCE_STREAM_GET_DEVICE_USERCONFIG,
    AGCE_STREAM_PUT_DEVICE_USERCONFIG,
    AGCE_STREAM_GET_DEVICEINFO
} AGCEStreamCommand;

int32 AGWriteSTREAM_END(AGReader * r, AGWriter * w, int32 *errCode);
int32 AGWriteSTREAM_PERFORM_COMMAND(AGReader * r, AGWriter * w,
                                    int32 *errCode, AGReader *command);
int32 AGWriteSTREAM_OPEN_DATABASE(AGReader * r, AGWriter * w,
                                  int32 *errCode, AGDBConfig * db);
int32 AGWriteSTREAM_GET_NEXT_RECORD(AGReader * r, AGWriter * w,
                                    int32 *errCode, AGRecord ** rec);
int32 AGWriteSTREAM_GET_NEXT_MODIFIED_RECORD(AGReader * r, AGWriter * w,
                                             int32 *errCode, AGRecord ** rec);
int32 AGWriteSTREAM_GET_NEXT_EXPANSION_COMMAND(AGReader * r, AGWriter * w,
                                    int32 *newCommand, int32 *commandLength,
                                    void **commandBytes);
int32 AGWriteSTREAM_START_SERVER(AGReader * r, AGWriter * w, int32 *errCode,
                                 char * servername, int16 port);
int32 AGWriteSTREAM_END_SERVER(AGReader * r, AGWriter * w, int32 *errCode);
int32 AGWriteSTREAM_GET_DEVICE_USERCONFIG(AGReader * r, AGWriter * w,
                                          int32 *errCode,
                                          AGUserConfig ** userConfig);
int32 AGWriteSTREAM_PUT_DEVICE_USERCONFIG(AGReader * r, AGWriter * w,
                                          int32 *errCode,
                                          AGUserConfig * userConfig);
int32 AGWriteSTREAM_GET_DEVICEINFO(AGReader * r, AGWriter * w,
                                   int32 *errCode, AGDeviceInfo ** devInfo);

void AGReadSTREAM_END(AGReader * r);
void AGReadSTREAM_PERFORM_COMMAND(AGReader * r);
void AGReadSTREAM_OPEN_DATABASE(AGReader * r, AGDBConfig ** db);
void AGReadSTREAM_GET_NEXT_RECORD(AGReader * r);
void AGReadSTREAM_GET_NEXT_MODIFIED_RECORD(AGReader * r);
void AGReadSTREAM_GET_NEXT_EXPANSION_COMMAND(AGReader * r);
void AGReadSTREAM_START_SERVER(AGReader * r, char ** servername, int16 * port);
void AGReadSTREAM_END_SERVER(AGReader * r);
void AGReadSTREAM_GET_DEVICE_USERCONFIG(AGReader * r);
void AGReadSTREAM_PUT_DEVICE_USERCONFIG(AGReader * r, AGUserConfig ** userConfig);
void AGReadSTREAM_GET_DEVICEINFO(AGReader * r);

void AGWriteResponseSTREAM_END(AGWriter * w, int32 result, int32 errCode);
void AGWriteResponseSTREAM_PERFORM_COMMAND(AGWriter * w, int32 result,
                                           int32 errCode);
void AGWriteResponseSTREAM_OPEN_DATABASE(AGWriter * w, int32 result,
                                         int32 errCode);
void AGWriteResponseSTREAM_GET_NEXT_RECORD(AGWriter * w, int32 result,
                                           int32 errCode, AGRecord * rec);
void AGWriteResponseSTREAM_GET_NEXT_MODIFIED_RECORD(AGWriter * w,
                                                    int32 result,
                                                    int32 errCode,
                                                    AGRecord * rec);
void AGWriteResponseSTREAM_GET_NEXT_EXPANSION_COMMAND(AGWriter * w,
                                                      int32 newCommand,
                                                      int32 commandLength,
                                                      void *commandBytes);
void AGWriteResponseSTREAM_START_SERVER(AGWriter * w, int32 result,
                                        int32 errCode);
void AGWriteResponseSTREAM_END_SERVER(AGWriter * w, int32 result,
                                      int32 errCode);
void AGWriteResponseSTREAM_GET_DEVICE_USERCONFIG(AGWriter * w, int32 result,
                                                 int32 errCode,
                                                 AGUserConfig * userConfig);
void AGWriteResponseSTREAM_PUT_DEVICE_USERCONFIG(AGWriter * w, int32 result,
                                                 int32 errCode);
void AGWriteResponseSTREAM_GET_DEVICEINFO(AGWriter * w, int32 result,
                                          int32 errCode,
                                          AGDeviceInfo * devInfo);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* #ifndef __AGSYNCCESTREAMPROTOCOL_H__ */