/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGUtil.h>
#include <AGClientProcessor.h>
#include <windows.h>
#include <AGSyncCEStreamProtocol.h>

#ifdef _WIN32_WCE
typedef enum tagRAPISTREAMFLAG
{
    STREAM_TIMEOUT_READ
} RAPISTREAMFLAG;

DECLARE_INTERFACE_ (IRAPIStream, IStream)
{
    STDMETHOD(SetRapiStat)(THIS_ RAPISTREAMFLAG Flag, DWORD dwValue) PURE;
    STDMETHOD(GetRapiStat)(THIS_ RAPISTREAMFLAG Flag, DWORD *pdwValue) PURE;
};

typedef HRESULT (STDAPICALLTYPE RAPIEXT) (DWORD cbInput,
                                          BYTE *pInput,
                                          DWORD *pcbOutput,
                                          BYTE **ppOutput,
                                          IRAPIStream *pIRAPIStream);
#else
#include <rapi.h>
#endif

/* ----------------------------------------------------------------------------
    static int32 readResult(AGReader * r, int32 *errCode)

    Read result code from stream.

*/
static int32 readResult(AGReader * r, int32 *errCode)
{
    int32 result;

    /* Read back result code (and error code if there is one). */
    result = (int32)AGReadCompactInt(r);
    if (AGCLIENT_ERR == result)
        *errCode = AGReadCompactInt(r);

    return result;
}

/* ----------------------------------------------------------------------------
    static void writeResult(AGWriter * w, int32 result, int32 error)

    Writes result code to stream.

*/
static void writeResult(AGWriter * w, int32 result, int32 error)
{
    AGWriteCompactInt(w, result);
    if (AGCLIENT_ERR == result)
        AGWriteCompactInt(w, error);
}

int32 AGWriteSTREAM_PERFORM_COMMAND(AGReader * r, AGWriter * w,
                                    int32 *errCode, AGReader *cr)
{
    AGCommand command = (AGCommand)AGReadCompactInt(cr);
    int32 length = AGReadCompactInt(cr);
    void *bytes = NULL;

    if(length > 0) {
        bytes = malloc(length);
        AGReadBytes(cr, bytes, length);
    }

    AGWriteCompactInt(w, AGCE_STREAM_PERFORM_COMMAND);
    AGWriteCompactInt(w, command);
    AGWriteCompactInt(w, length);
    AGWriteBytes(w, bytes, length);

    if (NULL != bytes)
        free(bytes);

    return readResult(r, errCode);
}

void AGReadSTREAM_PERFORM_COMMAND(AGReader * r)
{
    // We don't want to pull anything else off the stream here...
}

void AGWriteResponseSTREAM_PERFORM_COMMAND(AGWriter * w, int32 result,
                                            int32 errCode)
{
    writeResult(w, result, errCode);
}

int32 AGWriteSTREAM_OPEN_DATABASE(AGReader * r, AGWriter * w,
                                  int32 *errCode, AGDBConfig * db)
{
    AGWriteCompactInt(w, AGCE_STREAM_OPEN_DATABASE);
    AGDBConfigWriteData(db, w);
    return readResult(r, errCode);
}

void AGReadSTREAM_OPEN_DATABASE(AGReader * r, AGDBConfig ** db)
{
    *db = AGDBConfigNewAndReadData(r);
}

void AGWriteResponseSTREAM_OPEN_DATABASE(AGWriter * w, int32 result,
                                          int32 errCode)
{
    writeResult(w, result, errCode);
}

int32 AGWriteSTREAM_GET_NEXT_RECORD(AGReader * r, AGWriter * w,
                                    int32 *errCode, AGRecord ** rec)
{
    int32 result;
    AGWriteCompactInt(w, AGCE_STREAM_GET_NEXT_RECORD);
    result = readResult(r, errCode);
    if (AGCLIENT_CONTINUE == result)
        *rec = AGRecordNewAndReadData(r);
    return result;
}

void AGReadSTREAM_GET_NEXT_RECORD(AGReader * r)
{
}

void AGWriteResponseSTREAM_GET_NEXT_RECORD(AGWriter * w, int32 result,
                                           int32 errCode, AGRecord * rec)
{
    writeResult(w, result, errCode);
    if (AGCLIENT_CONTINUE == result)
        AGRecordWriteData(rec, w);
}

int32 AGWriteSTREAM_GET_NEXT_MODIFIED_RECORD(AGReader * r, AGWriter * w,
                                             int32 *errCode, AGRecord ** rec)
{
    int32 result;
    AGWriteCompactInt(w, AGCE_STREAM_GET_NEXT_MODIFIED_RECORD);
    result = readResult(r, errCode);
    if (AGCLIENT_CONTINUE == result)
        *rec = AGRecordNewAndReadData(r);
    return result;
}

void AGReadSTREAM_GET_NEXT_MODIFIED_RECORD(AGReader * r)
{
}

void AGWriteResponseSTREAM_GET_NEXT_MODIFIED_RECORD(AGWriter * w,
                                                    int32 result,
                                                    int32 errCode,
                                                    AGRecord * rec)
{
    writeResult(w, result, errCode);
    if (AGCLIENT_CONTINUE == result)
        AGRecordWriteData(rec, w);
}

int32 AGWriteSTREAM_GET_NEXT_EXPANSION_COMMAND(AGReader * r, AGWriter * w,
                                    int32 *newCommand, int32 *commandLength,
                                    void **commandBytes)
{
    // PENDING (jason) this should actually do something...
    return AGCLIENT_IDLE;
}

void AGReadSTREAM_GET_NEXT_EXPANSION_COMMAND(AGReader * r);

void AGWriteResponseSTREAM_GET_NEXT_EXPANSION_COMMAND(AGWriter * w,
                                                      int32 newCommand,
                                                      int32 commandLength,
                                                      void *commandBytes)
{
}

int32 AGWriteSTREAM_START_SERVER(AGReader * r, AGWriter * w,
                                 int32 *errCode, char * servername,
                                 int16 port)
{
    AGWriteCompactInt(w, AGCE_STREAM_START_SERVER);
    AGWriteCString(w, servername);
    AGWriteInt16(w, port);
    return readResult(r, errCode);
}

void AGReadSTREAM_START_SERVER(AGReader * r, char ** servername, int16 * port)
{
    *servername = AGReadCString(r);
    *port = AGReadInt16(r);
}

void AGWriteResponseSTREAM_START_SERVER(AGWriter * w, int32 result,
                                         int32 errCode)
{
    writeResult(w, result, errCode);
}

int32 AGWriteSTREAM_END_SERVER(AGReader * r, AGWriter * w,
                               int32 *errCode)
{
    AGWriteCompactInt(w, AGCE_STREAM_END_SERVER);
    return readResult(r, errCode);
}

void AGReadSTREAM_END_SERVER(AGReader * r)
{
}

void AGWriteResponseSTREAM_END_SERVER(AGWriter * w, int32 result,
                                       int32 errCode)
{
    writeResult(w, result, errCode);
}

int32 AGWriteSTREAM_GET_DEVICE_USERCONFIG(AGReader * r, AGWriter * w,
                                          int32 *errCode,
                                          AGUserConfig ** userConfig)
{
    int32 result;
    AGWriteCompactInt(w, AGCE_STREAM_GET_DEVICE_USERCONFIG);
    result = readResult(r, errCode);
    if (AGCLIENT_IDLE == result)
        *userConfig = AGUserConfigNewAndReadData(r);
    return result;
}

void AGReadSTREAM_GET_DEVICE_USERCONFIG(AGReader * r)
{
}

void AGWriteResponseSTREAM_GET_DEVICE_USERCONFIG(AGWriter * w, int32 result,
                                                 int32 errCode,
                                                 AGUserConfig * userConfig)
{
    writeResult(w, result, errCode);
    if (AGCLIENT_IDLE == result)
        AGUserConfigWriteData(userConfig, w);
}

int32 AGWriteSTREAM_PUT_DEVICE_USERCONFIG(AGReader * r, AGWriter * w,
                                          int32 *errCode,
                                          AGUserConfig * userConfig)
{
    AGWriteCompactInt(w, AGCE_STREAM_PUT_DEVICE_USERCONFIG);
    AGUserConfigWriteData(userConfig, w);
    return readResult(r, errCode);
}

void AGReadSTREAM_PUT_DEVICE_USERCONFIG(AGReader * r, AGUserConfig ** userConfig)

{
    *userConfig = AGUserConfigNewAndReadData(r);
}

void AGWriteResponseSTREAM_PUT_DEVICE_USERCONFIG(AGWriter * w, int32 result,
                                                 int32 errCode)
{
    writeResult(w, result, errCode);
}

int32 AGWriteSTREAM_END(AGReader * r, AGWriter * w,
                        int32 *errCode)
{
    AGWriteCompactInt(w, AGCE_STREAM_END);
    return readResult(r, errCode);
}

void AGReadSTREAM_END(AGReader * r)
{
}

void AGWriteResponseSTREAM_END(AGWriter * w, int32 result, int32 errCode)
{
    writeResult(w, result, errCode);
}

int32 AGWriteSTREAM_GET_DEVICEINFO(AGReader * r, AGWriter * w,
                                   int32 *errCode,
                                   AGDeviceInfo ** devInfo)
{
    int32 result;
    AGWriteCompactInt(w, AGCE_STREAM_GET_DEVICEINFO);
    result = readResult(r, errCode);
    if (AGCLIENT_IDLE == result)
        *devInfo = AGDeviceInfoNewAndReadData(r);
    return result;
}

void AGReadSTREAM_GET_DEVICEINFO(AGReader * r)

{
}

void AGWriteResponseSTREAM_GET_DEVICEINFO(AGWriter * w, int32 result,
                                          int32 errCode,
                                          AGDeviceInfo * devInfo)
{
    writeResult(w, result, errCode);
    if (AGCLIENT_IDLE == result)
        AGDeviceInfoWriteData(devInfo, w);
}

/* ----------------------------------------------------------------------------
    static int32 AGSyncCECommonWriteRAPIFunc(void * info,
    void * data, int32 len)

    Wrapper for AGWriter write function. Writes to RAPI stream.

*/
static int32 writeRAPIFunc(void * info,
                           void * data,
                           int32 len)
{
    unsigned long bytes = 0;
    ((IRAPIStream *)info)->Write(data, len, &bytes);
    return bytes;
}

/* ----------------------------------------------------------------------------
    static int32 readRAPIFunc(void * info,
    void * data, int32 len)

    Wrapper for AGReader read function. Reads from RAPI stream.

*/
static int32 readRAPIFunc(void * info,
                          void * data,
                          int32 len)
{
    unsigned long bytes = 0;
    ((IRAPIStream *)info)->Read(data, len, &bytes);
    return bytes;
}

/* ----------------------------------------------------------------------------
    static AGReader * AGSyncCEStreamCreateRAPIReader(IRAPIStream * rapiStream)
*/
AGReader * AGSyncCEStreamCreateRAPIReader(IRAPIStream * rapiStream)
{
    return AGReaderNew(rapiStream, readRAPIFunc);
}

/* ----------------------------------------------------------------------------
    static AGWriter * AGSyncCEStreamCreateRAPIWriter(IRAPIStream * rapiStream)
*/
AGWriter * AGSyncCEStreamCreateRAPIWriter(IRAPIStream * rapiStream)
{
    return AGWriterNew(rapiStream, writeRAPIFunc);
}

