/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGSyncCommon.h>
#include <AGSyncCECommon.h>
#include <AGDesktopInfoWinCE.h>
#ifndef _WIN32_WCE
#include <AGShlapi.h>

void AGCEGetCurrentDeviceInfo(char * deviceName,
                              char * userConfig,
                              char * syncUserConfig)
{
    char * filename;
    char prefsPath[MAX_PATH];

    prefsPath[0] = (char)0;

    HKEY partnerKey = NULL;
    HKEY partnerRootKey = NULL;
    DWORD deviceID = 0;
    AGDesktopInfoWinCE * desktopInfo;
    char keyName[MAX_PATH];
    char * temp;

    desktopInfo = AGDesktopInfoWinCENew();
    if (NULL == desktopInfo)
        return;

    deviceID = AGDesktopInfoWinCEGetDeviceID(desktopInfo);

    /* We now know the current CE device, identified by a DWORD.
    Unfortunately, that DWORD is used as the name of a subkey,
    so we can't reliably turn the ID into a string and look for
    that key name -- is 0x00112233 "112233" or "00112233"? */
    if (deviceID != 0 && deviceID != -1) {

        DWORD dwIndex;
        FILETIME fileTime;
        AGBool done = FALSE;

        RegOpenKeyEx(HKEY_CURRENT_USER,
            "Software\\Microsoft\\Windows CE Services\\Partners\\",
            0,
            KEY_READ,
            &partnerRootKey);

        if (NULL == partnerRootKey)
            done = TRUE;

        dwIndex = 0;
        while (!done) {

            DWORD testID;
            DWORD cbSize = sizeof(keyName);

            if (ERROR_SUCCESS != RegEnumKeyEx(partnerRootKey,
                dwIndex,
                keyName,
                &cbSize,
                0,
                NULL,
                0,
                &fileTime)) {

                done = TRUE;
                
            }
            else {

                ++dwIndex;

                sscanf(keyName, "%x", &testID);

                if (testID == deviceID) {

                    RegOpenKeyEx(partnerRootKey,
                        keyName,
                        0,
                        KEY_READ,
                        &partnerKey);

                    done = TRUE;

                } // if

            } // else

        } // while

        if (NULL != partnerRootKey)
            RegCloseKey(partnerRootKey);

    } // if

    if (NULL != partnerKey) {

        DWORD dwType;
        DWORD size = MAX_PATH;

        if (NULL != deviceName) {

            RegQueryValueEx(partnerKey,
                "DisplayName",
                0,
                &dwType,
                (LPBYTE)deviceName,
                &size);

        }

        size = MAX_PATH;
        RegQueryValueEx(partnerKey,
            "DataFolder",
            0,
            &dwType,
            (LPBYTE)prefsPath,
            &size);

        RegCloseKey(partnerKey);

    }

    /* Build the path of the config file. */
    temp = (char*)AGSyncCommonGetStringConstant(agMALSubdirectoryName,
        FALSE);
    PathAppend(prefsPath, temp);
    free(temp);

    if (prefsPath[0] != '\0') {

        if (NULL != userConfig) {

            filename = (char*)AGSyncCommonGetStringConstant(
                agPreferencesFilename, FALSE);
            PathCombine(userConfig, prefsPath, filename);
            free(filename);

        }

        if (NULL != syncUserConfig) {

            filename = (char*)AGSyncCommonGetStringConstant(
                agSynchronizedPreferencesFilename, FALSE);
            PathCombine(syncUserConfig, prefsPath, filename);
            free(filename);

        }

    }

}
#endif