/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#ifndef __AGSYNCCEDEVICEDLLMANAGER_H__
#define __AGSYNCCEDEVICEDLLMANAGER_H__

#include <AGTypes.h>
#include <AGSyncCEDeviceCommon.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

struct AGReader;
struct AGDBConfig;
struct AGRecord;

/* Function prototype typedefs for the functions exposed by the client
 DLLs. */
typedef void * (CALLBACK * INITFUNC)(AGServerConfig * serverConfig);
typedef void (CALLBACK * TERMFUNC)(void *out);

typedef struct {
    HMODULE hAGDatabaseLib;
    INITFUNC InitFunc;
    TERMFUNC TermFunc;
    AGOpenDatabaseFunc OpenDatabaseFunc;
    AGPerformCommandFunc PerformCommandFunc;
    AGGetNextRecordFunc GetNextRecordFunc;
    AGGetNextModifiedRecordFunc GetNextModifiedRecordFunc;
    AGGetNextExpansionCommandFunc GetNextExpansionCommandFunc;
    void * out;
} AGSyncCEDeviceDLLManagerDatabase;

typedef struct AGSyncCEDeviceDLLManagerServer {
    HKEY registryKey;
    AGServerConfig * serverConfig;
    AGSyncCEDeviceDLLManagerDatabase * currentDatabaseInfo;
} AGSyncCEDeviceDLLManagerServer;

typedef struct AGSyncCEDeviceDLLManager {
    AGSyncCEDeviceDLLManagerServer * currentServerInfo;
} AGSyncCEDeviceDLLManager;

AGSyncCEDeviceDLLManager * AGSyncCEDeviceDLLManagerNew(void);
void AGSyncCEDeviceDLLManagerFree(AGSyncCEDeviceDLLManager * dm);
int32 AGSyncCEDeviceDLLManagerPerformCommand(AGSyncCEDeviceDLLManager * dll,
                                             int32 *errCode, AGReader *command);
int32 AGSyncCEDeviceDLLManagerOpenDatabase(AGSyncCEDeviceDLLManager * dll,
                                           AGDBConfig * db,
                                           int32 *errCode);
int32 AGSyncCEDeviceDLLManagerGetNextModifiedRecord(
                                             AGSyncCEDeviceDLLManager * dll,
                                             AGRecord ** record,
                                             int32 *errCode);
int32 AGSyncCEDeviceDLLManagerGetNextRecord(AGSyncCEDeviceDLLManager * dll,
                                            AGRecord ** record,
                                            int32 *errCode);
int32 AGSyncCEDeviceDLLManagerStartServer(AGSyncCEDeviceDLLManager * dll,
                                          AGServerConfig * serverConfig);
int32 AGSyncCEDeviceDLLManagerEndServer(AGSyncCEDeviceDLLManager * dll);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* #ifndef __AGSYNCCEDEVICEDLLMANAGER_H__ */