/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGUserChooser.h>
#include <AGDeviceUserDropDown.h>
#include <AGConfigDialogBase.h>
#include <AGConfigResource.h>
#include <AGTypes.h>
#include <AGArray.h>
#include <windowsx.h>

typedef struct {
    AGArray * array;
    AGBool configureAll;
    AGBool somethingSelected;
    AGBool allowConfigureAll;
} xmlStruct;

/* ----------------------------------------------------------------------------
*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    xmlStruct * info = (xmlStruct *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (id) {
        case IDOK:
            EndDialog(hwnd, IDOK);
            break;
        case IDCANCEL:
            EndDialog(hwnd, IDCANCEL);
            break;
        case IDC_CONFIGURE_ALL:
            info->configureAll = IsDlgButtonChecked(hwnd, IDC_CONFIGURE_ALL);
            EnableWindow(GetDlgItem(hwnd, IDOK),
                info->somethingSelected | info->configureAll);
            break;
        case IDC_DEVICE_COMBO:
            switch (codeNotify) {
                case LBN_SELCHANGE:

                    info->somethingSelected =
                        AGDeviceUserDropDownHandleSelection(hwndCtl,
                        info->array);

                    EnableWindow(GetDlgItem(hwnd, IDOK),
                        info->somethingSelected | info->configureAll);

                    break;
                case CBN_DROPDOWN:
                    AGDeviceUserDropDownDoSelectionDropDown(info->array,
                        hwndCtl);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    FORWARD_WM_COMMAND(hwnd, id, hwndCtl,
        codeNotify, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------

    static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)

    Initialize user chooser dialog.  If there are no users, put up error and
    quit with cancel message.  If there is only one user, just pretend the
    user selected that one and dismiss immediately.

*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    xmlStruct * info;
    int count;

    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    
    info = (xmlStruct *)GetWindowLong(hwnd, GWL_USERDATA);

    info->array =
        AGDeviceUserDropDownBuild(GetDlgItem(hwnd, IDC_DEVICE_COMBO),
        &info->somethingSelected);

    if (!info->allowConfigureAll)
        ShowWindow(GetDlgItem(hwnd, IDC_CONFIGURE_ALL), SW_HIDE);

    EnableWindow(GetDlgItem(hwnd, IDOK),
        info->somethingSelected | info->configureAll);

    count = AGArrayCount(info->array);

    if (count < 2) {

        if (0 == count) {

            AGDeviceUserDropDownNoDeviceErrorMessage(hwnd);
            EndDialog(hwnd, IDCANCEL);

        }
        else {

            AGMobileLinkSetCurrentDevice(
                (AGDeviceEntry*)AGArrayElementAt(info->array, 0));

            EndDialog(hwnd, IDOK);

        }

    }

    CheckDlgButton(hwnd, IDC_CONFIGURE_ALL, info->configureAll);

    /* pending(miket): decide what to do with this button/function, but
    for now it's gone. */
    ShowWindow(GetDlgItem(hwnd, IDC_CONFIGURE_ALL), SW_HIDE);
    info->configureAll = FALSE;

    return FORWARD_WM_INITDIALOG(hwnd, hwndFocus,
        lParam, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static void onDestroy(HWND hwnd)
{
    xmlStruct * info = (xmlStruct *)GetWindowLong(hwnd, GWL_USERDATA);
}

/* ----------------------------------------------------------------------------
*/
static BOOL CALLBACK chooseProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
        HANDLE_MSG(hwnd, WM_DESTROY, onDestroy);
    }

    return 0;   /* except for WM_INITDIALOG, returning zero means
                we didn't process the message. */
}

/* ----------------------------------------------------------------------------
*/
AGBool AGUserChooserDo(HWND hParent,
                       AGBool * configureAll)
{
    int chooseResult;
    xmlStruct xmlStuff;

    xmlStuff.array = NULL;
    xmlStuff.configureAll = (NULL != configureAll) ? *configureAll : FALSE;
    xmlStuff.allowConfigureAll = (NULL != configureAll);

    chooseResult = DialogBoxParam(g_hInstance,
        MAKEINTRESOURCE(IDD_CHOOSE_USER),
        hParent,
        chooseProc,
        (LPARAM)&xmlStuff);

    if (IDOK != chooseResult) {
        if (NULL != xmlStuff.array)
            AGDeviceUserDropDownReleaseDeviceList(xmlStuff.array);
        return FALSE;
    }

    if (NULL != configureAll)
        *configureAll = xmlStuff.configureAll;

    if (NULL != xmlStuff.array)
        AGDeviceUserDropDownReleaseDeviceList(xmlStuff.array);

    return TRUE;
}