/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGServerPing.h>
#include <AGMobileLinkNet.h>
#include <AGProgressDialog.h>
#include <AGCommandProcessor.h>

/* ----------------------------------------------------------------------------
*/
static AGBool pingServer(AGServerConfig * serverConfig,
                         AGLocationConfig * locationConfig)
{
    AGCommandProcessor * commandProcessor;
    AGClientProcessor * clientProcessor;
    AGPlatformCalls * platformCalls;
    int32 result = AGCLIENT_ERR;
    AGNetCtx ctx;

    AGNetInit(&ctx);

    commandProcessor = AGCommandProcessorNew(serverConfig);

    platformCalls = (AGPlatformCalls *)malloc(sizeof(AGPlatformCalls));
    if (NULL != platformCalls) {

        bzero(platformCalls, sizeof(AGPlatformCalls));

        platformCalls->performCommandOut = commandProcessor;
        platformCalls->performCommandFunc =
            AGCommandProcessorGetPerformFunc(commandProcessor);

    }

    AGCommandProcessorStart(commandProcessor);

    clientProcessor = AGClientProcessorNew(serverConfig,
        NULL,
        locationConfig,
        platformCalls,
        TRUE,
        &ctx);

    AGClientProcessorSetBufferServerCommands(clientProcessor,
        TRUE);

    AGClientProcessorPing(clientProcessor);

    result = AGMobileLinkNetDoProcess(clientProcessor);

    AGClientProcessorFree(clientProcessor);

    AGCommandProcessorFree(commandProcessor);

    free(platformCalls);

    AGNetClose(&ctx);

    return (result != AGCLIENT_ERR && result != (-1));

}

AGServerConfig * AGServerPingDoPing(char * serverName,
                                    int16 serverPort,
                                    AGLocationConfig * locationConfig)
{
    AGServerConfig * result;

    if (NULL == serverName)
        return NULL;

    if (0 == strlen(serverName))
        return NULL;

    if (serverPort <= 0)
        return NULL;

    result = AGServerConfigNew();
    if (NULL == result)
        return NULL;

    bzero(result, sizeof(AGServerConfig));
    result->serverName = strdup(serverName);
    result->serverPort = serverPort;

    if (!pingServer(result, locationConfig)) {
        AGServerConfigFree(result);
        result = NULL;
    }

    return result;
}
