/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGConfigUtil.h>
#include <AGDigest.h>
#include <AGMD5.h>
#include <AGConfigDialogBase.h>
#include <AGConfigServerSettingsDialog.h>
#include <windowsx.h>

typedef struct ssdWindowInfo {
    
    HWND hwnd;
    AGServerConfig * serverConfig;
    HWND toolTipControl;

} ssdWindowInfo;

const AGToolTip tips [] = {
    IDC_SERVER_NAME, IDS_TIP_SERVER_NAME,
    IDC_SERVER_URL, IDS_TIP_SERVER_URL,
    IDC_SERVER_PORT, IDS_TIP_SERVER_PORT,
    IDC_SERVER_USERNAME, IDS_TIP_SERVER_USERNAME,
    IDC_SERVER_PASSWORD, IDS_TIP_SERVER_PASSWORD,
    IDC_CONNECT_SECURELY, IDS_TIP_CONNECT_SECURELY
};


/* ----------------------------------------------------------------------------
*/
static void checkButtons(HWND hwnd)
{
    HWND hwnds[4];

    hwnds[0] = GetDlgItem(hwnd, IDC_SERVER_NAME);
    hwnds[1] = GetDlgItem(hwnd, IDC_SERVER_URL);
    hwnds[2] = GetDlgItem(hwnd, IDC_SERVER_PORT);
    hwnds[3] = GetDlgItem(hwnd, IDC_SERVER_USERNAME);

    AGConfigUtilCheckDialogButtons(4, hwnds);
}

/* ----------------------------------------------------------------------------
*/
static BOOL onInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    char buf[32];
    SetWindowLong(hwnd, GWL_USERDATA, lParam);
    ssdWindowInfo * pInfo = (ssdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);
    pInfo->hwnd = hwnd;

    pInfo->toolTipControl = AGConfigUtilAddToolTips(hwnd,
        &tips[0],
        tipdim(tips));

    SetWindowText(GetDlgItem(hwnd, IDC_SERVER_NAME),
        pInfo->serverConfig->friendlyName);

    SetWindowText(GetDlgItem(hwnd, IDC_SERVER_URL),
        pInfo->serverConfig->serverName);

    itoa(pInfo->serverConfig->serverPort, buf, 10);
    SetWindowText(GetDlgItem(hwnd, IDC_SERVER_PORT), buf);

    SetWindowText(GetDlgItem(hwnd, IDC_SERVER_USERNAME),
        pInfo->serverConfig->userName);

    if (pInfo->serverConfig->hashPassword) {

        if (AGDigestNull(pInfo->serverConfig->password))
            SetWindowText(GetDlgItem(hwnd, IDC_SERVER_PASSWORD), "");
        else
            SetWindowText(GetDlgItem(hwnd, IDC_SERVER_PASSWORD),
                KEEPPASSWORD);

    } else {

        if (NULL == pInfo->serverConfig->cleartextPassword)
            SetWindowText(GetDlgItem(hwnd, IDC_SERVER_PASSWORD), "");
        else
            SetWindowText(GetDlgItem(hwnd, IDC_SERVER_PASSWORD),
                pInfo->serverConfig->cleartextPassword);

    }

    CheckDlgButton(hwnd, IDC_SERVER_ENABLED, !(pInfo->serverConfig->disabled));

    CheckDlgButton(hwnd,
        IDC_CONNECT_SECURELY,
        pInfo->serverConfig->connectSecurely);

    EnableWindow(GetDlgItem(hwnd, IDC_CONNECT_SECURELY),
        pInfo->serverConfig->allowSecureConnection);

    checkButtons(hwnd);

    return FORWARD_WM_INITDIALOG(hwnd, hwndFocus,
        lParam, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static void doOK(HWND hwnd, ssdWindowInfo * pInfo)
{
    char buf[32];
    char plaintext[MAX_PATH];

    if (NULL != pInfo->serverConfig->friendlyName)
        free(pInfo->serverConfig->friendlyName);
    pInfo->serverConfig->friendlyName =
        AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_SERVER_NAME));

    if (NULL != pInfo->serverConfig->serverName)
        free(pInfo->serverConfig->serverName);
    pInfo->serverConfig->serverName =
        AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_SERVER_URL));

    GetWindowText(GetDlgItem(hwnd, IDC_SERVER_PORT), buf, 32);
    pInfo->serverConfig->serverPort = atoi(buf);

    if (NULL != pInfo->serverConfig->userName)
        free(pInfo->serverConfig->userName);
    pInfo->serverConfig->userName =
        AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_SERVER_USERNAME));

    GetWindowText(GetDlgItem(hwnd, IDC_SERVER_PASSWORD),
        plaintext, MAX_PATH);

    if (pInfo->serverConfig->hashPassword) {

        if (strcmp(KEEPPASSWORD, plaintext)) {

            if (strlen(plaintext) > 0)
                AGMd5((uint8*)plaintext, strlen(plaintext),
                    pInfo->serverConfig->password);
            else
                AGDigestSetToNull(
                    pInfo->serverConfig->password);

        }

    } else {

        if (NULL != pInfo->serverConfig->cleartextPassword)
            free(pInfo->serverConfig->cleartextPassword);

        if (strlen(plaintext) > 0) {

            pInfo->serverConfig->cleartextPassword =
                strdup(plaintext);

        } else {

            pInfo->serverConfig->cleartextPassword = NULL;

        }

    }

    pInfo->serverConfig->disabled =
        !IsDlgButtonChecked(hwnd, IDC_SERVER_ENABLED);

    pInfo->serverConfig->connectSecurely =
        IsDlgButtonChecked(hwnd, IDC_CONNECT_SECURELY);

}

/* ----------------------------------------------------------------------------
*/
static void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    ssdWindowInfo * pInfo = (ssdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case EN_CHANGE:
            checkButtons(hwnd);
            return;
        case BN_CLICKED:
            switch (id) {
                case IDOK: {
                    doOK(hwnd, pInfo);
                    EndDialog(hwnd, IDOK);
                    return;
                }
                case IDCANCEL: {
                    EndDialog(hwnd, IDCANCEL);
                    return;
                }
                default:
                    break;
            }
            break;
        default:
            break;

    }
    FORWARD_WM_COMMAND(hwnd, id, hwndCtl,
        codeNotify, AGConfigDialogBaseProc);
}

/* ----------------------------------------------------------------------------
*/
static BOOL CALLBACK dialogProc(HWND hwnd, UINT message,
                            WPARAM wParam, LPARAM lParam)
{
    ssdWindowInfo * pInfo = (ssdWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (message) {
        HANDLE_MSG(hwnd, WM_INITDIALOG, onInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
    }

    return 0;   // except for WM_INITDIALOG, returning zero means
                // we didn't process the message.
}

/* ----------------------------------------------------------------------------
*/
int AGConfigServerSettingsDialogDo(const HWND parentHwnd,
                                   AGServerConfig * sc)
{
    ssdWindowInfo info;
    info.serverConfig = sc;
    info.toolTipControl = NULL;
    int result = 0;    

    result = DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_SERVER_SETTINGS),
        parentHwnd, dialogProc, (LPARAM)&info);

    if (NULL != info.toolTipControl)
        DestroyWindow(info.toolTipControl);

    return result;
}
