/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <windows.h>
#include <windowsx.h>
#include <prsht.h>
#include <stdio.h>
#include <AGConfigProxyWizard.h>
#include <AGConfigProxyDialog.h>
#include <AGConfigDomainExclusionDialog.h>
#include <AGConfigProxySearch.h>
#include <AGConfigUtil.h>
#include <crtdbg.h>

const int NUM_PAGES = 6;

typedef struct pwWindowInfo {

    AGLocationConfig * locationConfig;
    AGBool automatic;
    HWND toolTipControl;
    AGBool userPressedFinish;
    AGBool userPressedExpert;

} pwWindowInfo;

/* ----------------------------------------------------------------------------
*/
static BOOL introOnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    PROPSHEETPAGE * psp = (PROPSHEETPAGE *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, psp->lParam);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT introOnNotify(HWND hwnd, NMHDR * nmh)
{

    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {

        case PSN_KILLACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_RESET:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_SETACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);

            PropSheet_SetWizButtons(nmh->hwndFrom, PSWIZB_NEXT);

            /* Update the right state for the auto/manual button group. */
            SendMessage(GetDlgItem(hwnd, IDC_PROXY_WIZ_RADIO_AUTO), BM_SETCHECK,
                (WPARAM)info->automatic, 0);
            SendMessage(GetDlgItem(hwnd, IDC_PROXY_WIZ_RADIO_MANUAL), BM_SETCHECK,
                (WPARAM)!info->automatic, 0);
            break;

        case PSN_WIZNEXT: {
            // the Next button was pressed

            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);

            info->automatic = IsDlgButtonChecked(hwnd, IDC_PROXY_WIZ_RADIO_AUTO);

            /* Try the auto search.  If it fails, pretend the user
            clicked on manual. */
            if (info->automatic)
                if (AG_PROXY_NONE_FOUND ==
                    AGConfigSearchBrowserSettings(info->locationConfig))
                    info->automatic = FALSE;
            break;
        }

        case PSN_WIZFINISH: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZBACK: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            _ASSERT(0);
            break;
        }

        default:
            return FALSE;

    }

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static void introOnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case BN_CLICKED:

            /* If the user is fiddling with the radio buttons, adjust the
            wiz buttons accordingly. */
            switch (id) {
                case IDC_PROXY_WIZ_RADIO_AUTO:
                case IDC_PROXY_WIZ_RADIO_MANUAL:
                    PropSheet_SetWizButtons(GetParent(hwnd), PSWIZB_NEXT);
                    break;
                case IDC_EXPERT:
                    info->userPressedExpert = TRUE;
                    PropSheet_PressButton(GetParent(hwnd), PSBTN_CANCEL);               
                break;
            }
            break;
        default:
            break;
    }
}

/* ----------------------------------------------------------------------------
*/
static BOOL APIENTRY intro(HWND hDlg, UINT message, UINT wParam, LONG lParam)
{

    switch (message)
    {
        HANDLE_MSG(hDlg, WM_INITDIALOG, introOnInitDialog);
        HANDLE_MSG(hDlg, WM_COMMAND, introOnCommand);
        case WM_NOTIFY:
            return introOnNotify(hDlg, (NMHDR*)lParam);
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL autoSettingsOnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    PROPSHEETPAGE * psp = (PROPSHEETPAGE *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, psp->lParam);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static void reportBrowserSearchResults(HWND hwnd, pwWindowInfo * info)
{
    /* Fill in what we found from the search. */
/*    int i, n;
    char * excludebuf; */
    const int AG_STRMAX = 512;
    char buf[3][AG_STRMAX];
/*    AGBool appendSeparator = FALSE; */
    strcpy(buf[0], "");

    int id = -1;

    switch (info->locationConfig->source) {

        case AG_PROXY_MSIE:
            id = IDS_FOUND_SETTINGS_MSIE;
            break;
        case AG_PROXY_Netscape:
            id = IDS_FOUND_SETTINGS_NETSCAPE;
            break;
        case AG_PROXY_FAILED:
            id = IDS_FOUND_SETTINGS_NONE;
            break;
    }
    if (id >=0)
        LoadString(g_hInstance, id, buf[0], AG_STRMAX);

    if (info->locationConfig->HTTPUseProxy) {
        LoadString(g_hInstance, IDS_USE_HTTP, buf[1],
            AG_STRMAX);
        sprintf(buf[2],
            buf[1],
            info->locationConfig->HTTPName,
            info->locationConfig->HTTPPort);
    }
    else
        LoadString(g_hInstance, IDS_NO_HTTP, buf[2], AG_STRMAX);
    strcat(buf[0], buf[2]);

    if (info->locationConfig->SOCKSUseProxy) {
        LoadString(g_hInstance, IDS_USE_SOCKS, buf[1],
            AG_STRMAX);
        sprintf(buf[2],
            buf[1],
            info->locationConfig->SOCKSName,
            info->locationConfig->SOCKSPort);
    }
    else
        LoadString(g_hInstance, IDS_NO_SOCKS, buf[2], AG_STRMAX);
    strcat(buf[0], buf[2]);

/*    n = AGArrayCount(info->locationConfig->exclusionServers);
    if (n > 0) {

        excludebuf = (char*)malloc(MAX_PATH * n + 1);

        if (NULL != excludebuf) {

            LoadString(g_hInstance,
                IDS_EXCLUDE_DOMAINS, excludebuf, MAX_PATH * n + 1);

            for (i = 0; i < n; ++i) {

                char * name;

                name = (char*)AGArrayElementAt(
                    info->locationConfig->exclusionServers,
                    i);

                if (NULL == name)
                    continue;

                if (appendSeparator)
                    strcat(excludebuf, "; ");
                else
                    appendSeparator = TRUE;

                strcat(excludebuf, name);

            }

            strcat(excludebuf, "\r\n\r\n");

            strcat(buf[0], excludebuf);

            free(excludebuf);

        }

    }
*/
    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_AUTO_SETTINGS_EDIT),
        buf[0]);

}

/* ----------------------------------------------------------------------------
*/
static LRESULT autoSettingsOnNotify(HWND hwnd, NMHDR * nmh)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {

        case PSN_KILLACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_RESET:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_SETACTIVE: {

            if (info->automatic) {

                SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);

                /* pending(miket): Handle auto config */
                if (info->locationConfig->autoConfigProxyURL == NULL) {

                    PropSheet_SetWizButtons(nmh->hwndFrom, PSWIZB_BACK |
                        PSWIZB_FINISH);

                    reportBrowserSearchResults(hwnd, info);

                } else {

                    char buffer[MAX_PATH];

                    LoadString(g_hInstance,
                        IDS_AUTO_PROXY_CONFIG_ERROR,
                        buffer,
                        MAX_PATH);

                    SetWindowText(GetDlgItem(hwnd,
                        IDC_PROXY_WIZ_STATIC),
                        buffer);

                    ShowWindow(GetDlgItem(hwnd,
                        IDC_PROXY_WIZ_AUTO_SETTINGS_EDIT),
                        SW_HIDE);

                    PropSheet_SetWizButtons(nmh->hwndFrom, PSWIZB_BACK |
                        PSWIZB_NEXT);

                }
                
            } else {
                SetWindowLong(hwnd, DWL_MSGRESULT, -1);
            }

            break;

        }

        case PSN_WIZNEXT: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZBACK: {
            /* This probably means the user wasn't satisfied with
            the results of the automatic search, so try manual. */
            info->automatic = FALSE;

            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZFINISH: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            info->userPressedFinish = TRUE;
            break;
        }
        default:
            return FALSE;

    }

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL APIENTRY autoSettings(HWND hDlg, UINT message, 
                                  UINT wParam, LONG lParam)
{
    switch (message)
    {
        HANDLE_MSG(hDlg, WM_INITDIALOG, autoSettingsOnInitDialog);
        case WM_NOTIFY:
            return autoSettingsOnNotify(hDlg, (NMHDR*)lParam);
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
static void proxyTypeSow(HWND hwnd, AGLocationConfig * loc)
{
    SendMessage(GetDlgItem(hwnd, IDC_PROXY_WIZ_RADIO_HTTP), BM_SETCHECK,
        (WPARAM)(loc->HTTPUseProxy), 0);
    SendMessage(GetDlgItem(hwnd, IDC_PROXY_WIZ_RADIO_SOCKS), BM_SETCHECK,
        (WPARAM)(loc->SOCKSUseProxy), 0);
}

/* ----------------------------------------------------------------------------
*/
static void proxyTypeReap(HWND hwnd, AGLocationConfig * loc)
{
    loc->HTTPUseProxy = IsDlgButtonChecked(hwnd, IDC_PROXY_WIZ_RADIO_HTTP);
    loc->SOCKSUseProxy = IsDlgButtonChecked(hwnd, IDC_PROXY_WIZ_RADIO_SOCKS);
}

/* ----------------------------------------------------------------------------
*/
static BOOL proxyTypeOnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    PROPSHEETPAGE * psp = (PROPSHEETPAGE *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, psp->lParam);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT proxyTypeOnNotify(HWND hwnd, NMHDR * nmh)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {

        case PSN_KILLACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_RESET:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_SETACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            PropSheet_SetWizButtons(nmh->hwndFrom, PSWIZB_NEXT | PSWIZB_BACK);
            proxyTypeSow(hwnd, info->locationConfig);
            break;

        case PSN_WIZNEXT:
        case PSN_WIZBACK: {
            proxyTypeReap(hwnd, info->locationConfig);
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZFINISH: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }
        default:
            return FALSE;

    }

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL APIENTRY proxyType(HWND hDlg, UINT message,
                               UINT wParam, LONG lParam)
{

    switch (message)
    {
        HANDLE_MSG(hDlg, WM_INITDIALOG, proxyTypeOnInitDialog);
        case WM_NOTIFY:
            return proxyTypeOnNotify(hDlg, (NMHDR*)lParam);
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
static void httpUpdateEnabledStates(HWND hwnd)
{
    BOOL state;
    
    state = IsDlgButtonChecked(hwnd, IDC_PROXY_WIZ_USE_AUTHENTICATION);
    EnableWindow(GetDlgItem(hwnd, IDC_PROXY_WIZ_USERNAME_EDIT), state);
    EnableWindow(GetDlgItem(hwnd, IDC_PROXY_WIZ_PASSWORD_EDIT), state);

}

/* ----------------------------------------------------------------------------
*/
static void httpCheckButtons(HWND hwnd)
{
    HWND hwnds[3];

    hwnds[0] = GetDlgItem(hwnd, IDC_PROXY_WIZ_HTTP_NAME_EDIT);
    hwnds[1] = GetDlgItem(hwnd, IDC_PROXY_WIZ_HTTP_PORT_EDIT);

    if (!IsDlgButtonChecked(hwnd, IDC_PROXY_WIZ_USE_AUTHENTICATION)) {

        AGConfigUtilCheckWizButtons(2, hwnds, 0);

    }
    else {

        hwnds[2] = GetDlgItem(hwnd, IDC_PROXY_WIZ_USERNAME_EDIT);
        AGConfigUtilCheckWizButtons(3, hwnds, 0);
    }
}

/* ----------------------------------------------------------------------------
*/
static void httpOnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case BN_CLICKED:
            switch (id) {
                case IDC_PROXY_WIZ_USE_AUTHENTICATION:
                    httpUpdateEnabledStates(hwnd);
                    httpCheckButtons(hwnd);
                    return;
                break;
            }
            break;
        case EN_CHANGE:
            httpCheckButtons(hwnd);
            return;
        default:
            break;
    }
}

/* ----------------------------------------------------------------------------
*/
static void httpSow(HWND hwnd, AGLocationConfig * loc)
{
    char buf[10];

    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_HTTP_NAME_EDIT),
        loc->HTTPName);
    if (loc->HTTPPort > 0) {
        _itoa(loc->HTTPPort, buf, 10);
        SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_HTTP_PORT_EDIT), buf);
    }
    else
        SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_HTTP_PORT_EDIT), "");

    CheckDlgButton(hwnd, IDC_PROXY_WIZ_USE_AUTHENTICATION,
        loc->HTTPUseAuthentication ? BST_CHECKED : BST_UNCHECKED);
    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_USERNAME_EDIT),
        loc->HTTPUsername);
    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_PASSWORD_EDIT),
        loc->HTTPPassword);
}

/* ----------------------------------------------------------------------------
*/
static void httpReap(HWND hwnd, AGLocationConfig * loc)
{
    char buf[10];

    if (NULL != loc->HTTPName)
        free(loc->HTTPName);
    loc->HTTPName = AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_PROXY_WIZ_HTTP_NAME_EDIT));
    GetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_HTTP_PORT_EDIT), buf, 10);
    loc->HTTPPort = atoi(buf);
    loc->HTTPUseAuthentication = IsDlgButtonChecked(hwnd,
        IDC_PROXY_WIZ_USE_AUTHENTICATION);
    if (NULL != loc->HTTPUsername)
        free(loc->HTTPUsername);
    loc->HTTPUsername = AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_PROXY_WIZ_USERNAME_EDIT));
    if (NULL != loc->HTTPPassword)
        free(loc->HTTPPassword);
    loc->HTTPPassword = AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_PROXY_WIZ_PASSWORD_EDIT));
}

/* ----------------------------------------------------------------------------
*/
static BOOL httpOnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    PROPSHEETPAGE * psp = (PROPSHEETPAGE *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, psp->lParam);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT httpOnNotify(HWND hwnd, NMHDR * nmh)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {

        case PSN_KILLACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_RESET:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_SETACTIVE: {

            /* If the user didn't select this proxy, skip this page. */
            if (info->locationConfig->HTTPUseProxy) {
                SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
                httpSow(hwnd, info->locationConfig);
                httpUpdateEnabledStates(hwnd);
                httpCheckButtons(hwnd);
            }
            else
                SetWindowLong(hwnd, DWL_MSGRESULT, -1);
            break;
        }
        case PSN_WIZNEXT:
        case PSN_WIZBACK: {
            httpReap(hwnd, info->locationConfig);
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZFINISH: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }
        default:
            return FALSE;

    }

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL APIENTRY http(HWND hDlg, UINT message,
                          UINT wParam, LONG lParam)
{

    switch (message)
    {
        HANDLE_MSG(hDlg, WM_INITDIALOG, httpOnInitDialog);
        HANDLE_MSG(hDlg, WM_COMMAND, httpOnCommand);
        case WM_NOTIFY:
            return httpOnNotify(hDlg, (NMHDR*)lParam);
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
static void socksCheckButtons(HWND hwnd)
{
    HWND hwnds[2];

    hwnds[0] = GetDlgItem(hwnd, IDC_PROXY_WIZ_SOCKS_NAME_EDIT);
    hwnds[1] = GetDlgItem(hwnd, IDC_PROXY_WIZ_SOCKS_PORT_EDIT);

    AGConfigUtilCheckWizButtons(2, hwnds, 0);
}

/* ----------------------------------------------------------------------------
*/
static void socksSow(HWND hwnd, AGLocationConfig * loc)
{
    char buf[10];

    SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_SOCKS_NAME_EDIT),
        loc->SOCKSName);
    if (loc->SOCKSPort > 0) {
        _itoa(loc->SOCKSPort, buf, 10);
        SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_SOCKS_PORT_EDIT), buf);
    }
    else
        SetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_SOCKS_PORT_EDIT), "");

}

/* ----------------------------------------------------------------------------
*/
static void socksReap(HWND hwnd, AGLocationConfig * loc)
{
    char buf[10];

    if (NULL != loc->SOCKSName)
        free(loc->SOCKSName);
    loc->SOCKSName = AGConfigWindowTextDup(GetDlgItem(hwnd,
        IDC_PROXY_WIZ_SOCKS_NAME_EDIT));
    GetWindowText(GetDlgItem(hwnd, IDC_PROXY_WIZ_SOCKS_PORT_EDIT), buf, 10);
    loc->SOCKSPort = atoi(buf);
}

/* ----------------------------------------------------------------------------
*/
static BOOL socksOnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
    PROPSHEETPAGE * psp = (PROPSHEETPAGE *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, psp->lParam);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT socksOnNotify(HWND hwnd, NMHDR * nmh)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {

        case PSN_KILLACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_RESET:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_SETACTIVE:
            /* If the user didn't select this proxy, skip this page. */
            if (info->locationConfig->SOCKSUseProxy) {
                SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
                socksSow(hwnd, info->locationConfig);
                socksCheckButtons(hwnd);
            }
            else
                SetWindowLong(hwnd, DWL_MSGRESULT, -1);
            break;

        case PSN_WIZNEXT:
        case PSN_WIZBACK: {
            socksReap(hwnd, info->locationConfig);
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZFINISH: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }
        default:
            return FALSE;

    }

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static void socksOnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (codeNotify) {
        case EN_CHANGE:
            socksCheckButtons(hwnd);
            return;
        default:
            break;
    }
}

/* ----------------------------------------------------------------------------
*/
static BOOL APIENTRY socks(HWND hDlg, UINT message,
                           UINT wParam, LONG lParam)
{

    switch (message)
    {
        HANDLE_MSG(hDlg, WM_INITDIALOG, socksOnInitDialog);
        HANDLE_MSG(hDlg, WM_COMMAND, socksOnCommand);
        case WM_NOTIFY:
            return socksOnNotify(hDlg, (NMHDR*)lParam);
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL excludeDomainsOnInitDialog(HWND hwnd, HWND hwndFocus,
                                       LPARAM lParam)
{
    PROPSHEETPAGE * psp = (PROPSHEETPAGE *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, psp->lParam);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT excludeDomainsOnNotify(HWND hwnd, NMHDR * nmh)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {

        case PSN_KILLACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_RESET:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_SETACTIVE:
            // If the user didn't ANY proxy, skip this page.
            if (info->locationConfig->HTTPUseProxy ||
                info->locationConfig->SOCKSUseProxy)
                SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            else
                SetWindowLong(hwnd, DWL_MSGRESULT, -1);

            PropSheet_SetWizButtons(nmh->hwndFrom, PSWIZB_BACK | PSWIZB_NEXT);
            break;

        case PSN_WIZNEXT:
        case PSN_WIZBACK: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZFINISH: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }
        default:
            return FALSE;

    }

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL APIENTRY excludeDomains(HWND hDlg, UINT message,
                                    UINT wParam, LONG lParam)
{

    switch (message)
    {
        HANDLE_MSG(hDlg, WM_INITDIALOG, excludeDomainsOnInitDialog);
        case WM_NOTIFY:
            return excludeDomainsOnNotify(hDlg, (NMHDR*)lParam);
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL completeOnInitDialog(HWND hwnd, HWND hwndFocus,
                                 LPARAM lParam)
{
    PROPSHEETPAGE * psp = (PROPSHEETPAGE *)lParam;
    SetWindowLong(hwnd, GWL_USERDATA, psp->lParam);
    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT completeOnNotify(HWND hwnd, NMHDR * nmh)
{
    pwWindowInfo * info = (pwWindowInfo *)GetWindowLong(hwnd, GWL_USERDATA);

    switch (nmh->code) {

        case PSN_KILLACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_RESET:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;

        case PSN_SETACTIVE:
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            PropSheet_SetWizButtons(nmh->hwndFrom, PSWIZB_BACK | PSWIZB_FINISH);
            break;

        case PSN_WIZNEXT: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            _ASSERT(0);
            break;
        }

        case PSN_WIZBACK: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            break;
        }

        case PSN_WIZFINISH: {
            SetWindowLong(hwnd, DWL_MSGRESULT, FALSE);
            info->userPressedFinish = TRUE;
            break;
        }
        default:
            return FALSE;

    }

    return TRUE;
}

/* ----------------------------------------------------------------------------
*/
static BOOL APIENTRY complete(HWND hDlg, UINT message,
                              UINT wParam, LONG lParam)
{

    switch (message)
    {
        HANDLE_MSG(hDlg, WM_INITDIALOG, completeOnInitDialog);
        case WM_NOTIFY:
            return completeOnNotify(hDlg, (NMHDR*)lParam);
    }
    return FALSE;
}

/* ----------------------------------------------------------------------------
*/
int AGConfigProxyWizardDo(const HWND hwnd, AGLocationConfig * locationConfig)
{
    PROPSHEETPAGE psp[NUM_PAGES];
    PROPSHEETHEADER psh;
    pwWindowInfo info;
    int result = 0;

    /* First time through, select automatic search for proxy. */
    info.automatic = TRUE;
    info.locationConfig = locationConfig;
    info.userPressedFinish = FALSE;
    info.userPressedExpert = FALSE;

    int ppage = 0;
    AGConfigWizardFillInPropertyPage((LPARAM)&info, &psp[ppage++],
        IDD_PROXY_WIZ_INTRO, intro);
    AGConfigWizardFillInPropertyPage((LPARAM)&info, &psp[ppage++],
        IDD_PROXY_WIZ_AUTO_SETTINGS, autoSettings);
    AGConfigWizardFillInPropertyPage((LPARAM)&info, &psp[ppage++],
        IDD_PROXY_WIZ_PROXY_TYPE, proxyType);
    AGConfigWizardFillInPropertyPage((LPARAM)&info, &psp[ppage++],
        IDD_PROXY_WIZ_HTTP, http);
    AGConfigWizardFillInPropertyPage((LPARAM)&info, &psp[ppage++],
        IDD_PROXY_WIZ_SOCKS, socks);
/*    AGConfigWizardFillInPropertyPage((LPARAM)&info, &psp[ppage++],
        IDD_PROXY_WIZ_EXCLUDE_DOMAINS, excludeDomains);*/
    AGConfigWizardFillInPropertyPage((LPARAM)&info, &psp[ppage++],
        IDD_PROXY_WIZ_COMPLETE, complete);
    
    psh.dwSize = sizeof(PROPSHEETHEADER);
    psh.dwFlags = PSH_PROPSHEETPAGE | PSH_WIZARD | PSH_NOAPPLYNOW;
    psh.hwndParent = hwnd;
    psh.pszCaption = NULL;
    psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
    psh.nStartPage = 0;
    psh.ppsp = (LPCPROPSHEETPAGE) &psp;

    ::PropertySheet(&psh);

    if (info.userPressedExpert) {
        result = -1;
    } else if (info.userPressedFinish) {
        result = 1;
    }

    return result;
}
