/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGSyncProcessor.h>
#include <AGClientProcessor.h>
#include <AGBufferWriter.h>
#include <AGConfigMainWindow.h>
#include <AGConfigMainDialog.h>
#include <windowsx.h>
#include <stdlib.h>
#include <stdio.h>
#include <AGConfigDDEHandler.h>

/* Window class names won't ever be localized so we don't bother sticking
them in a resource file. */
#define CLASS_NAME "Mobile Link Main Window Class"

typedef struct mwWindowInfo {

    ATOM classAtom;
    AGDDEHandler * ddeHandler;

} mwWindowInfo;

extern "C" {
    extern HWND hMainDialog;
    extern AGBool selfShotInHead;
}

static BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct)
{
    /* TRUE == success.  This is the opposite of the correct return code
    for a successful WM_CREATE handling, but the windowsx message cracker
    flips the value. */
    return TRUE;
}

static void onDoDialog(HWND hwnd)
{
    AGConfigMainDialogDo(hwnd);
}

static void onDestroy(HWND hwnd)
{
    mwWindowInfo * pInfo = (mwWindowInfo*)GetWindowLong(hwnd, GWL_USERDATA);

    if (IsWindow(hMainDialog))
        DestroyWindow(hMainDialog);

    if (NULL != pInfo) {

        AGDDEHandlerFree(pInfo->ddeHandler);

        free(pInfo);

    }
    SetWindowLong(hwnd, GWL_USERDATA, (LONG)pInfo);
}

static BOOL onEraseBkgnd(HWND hwnd, HDC hdc)
{
    /* Simply return false to mark that the usual WM_PAINT handler should handle
    the background erasing. */
    return FALSE;
}

static void onPaint(HWND hwnd)
{
    PAINTSTRUCT ps;

    BeginPaint(hwnd, &ps);

    RECT r;

    GetClientRect(hwnd, &r);

    FillRect(ps.hdc, &r, GetSysColorBrush(COLOR_WINDOW));

    EndPaint(hwnd, &ps);
}

static LRESULT CALLBACK wndProc(HWND hwnd, UINT message,
                                WPARAM wParam, LPARAM lParam)
{
    mwWindowInfo * pInfo = (mwWindowInfo*)GetWindowLong(hwnd, GWL_USERDATA);
    switch (message) {
        HANDLE_MSG(hwnd, WM_CREATE, onCreate);
        HANDLE_MSG(hwnd, WM_DESTROY, onDestroy);
        HANDLE_MSG(hwnd, WM_ERASEBKGND, onEraseBkgnd);
        HANDLE_MSG(hwnd, WM_PAINT, onPaint);
        case WM_DDE_INITIATE:
            return AGConfigDDEInitiate(hwnd,
                (HWND)wParam,
                lParam,
                pInfo->ddeHandler);
        case WM_AG_CONFIG_SHOW_MAIN_DIALOG:
            onDoDialog(hwnd);
            return 0;
        case WM_AG_CONFIG_HANDLE_FILE:
            AGConfigDDEHandleCommandLineLocally(hwnd, (ATOM)wParam);
            if (lParam != 0)
                PostQuitMessage(0);
            return 0;
        case WM_AG_CONFIG_SHOOT_SELF_IN_HEAD:
            selfShotInHead = TRUE;
            PostQuitMessage(0);
            return 0;
        case WM_AG_CONFIG_SELECT_CE_USER:
            AGConfigSelectCEUser(hMainDialog, (ATOM)wParam);
            GlobalDeleteAtom((ATOM)wParam);
            return 0;
            
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
} 

LPCTSTR AGConfigMainWindowGetClassName(void)
{
    return CLASS_NAME;
}

HWND AGConfigMainWindowCreate(const int nCmdShow)
{
    TCHAR title[MAX_PATH];
    HWND hwnd;

    WNDCLASSEX wcex;
    mwWindowInfo * pInfo;
    HICON hIcon;

    pInfo = (mwWindowInfo *)malloc(sizeof(mwWindowInfo));

    hIcon = LoadIcon(g_hInstance, MAKEINTRESOURCE (IDI_DESKTOP_ICON));

    wcex.cbSize        = sizeof(WNDCLASSEX);
    wcex.style         = 0;
    wcex.lpfnWndProc   = wndProc;
    wcex.cbClsExtra    = 0;
    wcex.cbWndExtra    = 0;
    wcex.hInstance     = g_hInstance;
    wcex.hIcon         = hIcon;
    wcex.hCursor       = LoadCursor (NULL, IDC_ARROW);
    wcex.hbrBackground = NULL;
    wcex.lpszMenuName  = NULL;
    wcex.lpszClassName = CLASS_NAME;
    wcex.hIconSm       = hIcon;

    pInfo->classAtom = RegisterClassEx(&wcex);

    if (0 == pInfo->classAtom)
        return NULL;

    pInfo->ddeHandler = AGDDEHandlerNew();

    if (NULL == pInfo->ddeHandler)
        return NULL;

    LoadString(g_hInstance, IDS_MAIN_WINDOW_TITLE, title, MAX_PATH);

    hwnd = CreateWindowEx(0, (LPCTSTR)MAKELONG(pInfo->classAtom, 0), title,
        WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION,
        CW_USEDEFAULT, CW_USEDEFAULT, 1, 1, NULL, NULL,
        g_hInstance, NULL);

    if (!hwnd)
       return NULL;

    SetWindowLong(hwnd, GWL_USERDATA, (LONG)pInfo);

    ShowWindow(hwnd, SW_HIDE);

    /* Note:  destructor for mwWindowInfo * pInfo is in DestroyWindow
    handler. */

    return hwnd;
}