/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGConfigDDEHandler.h>
#include <AGConfigAGSubHandler.h>
#include <AGConfigXMLHandler.h>
#include <AGConfigUtil.h>
#include <windowsx.h>
#include <AGShlapi.h>

#define DDE_CLASS_SUB_NAME "Mobile Link DDE AGSub Server Class"
#define DDE_CLASS_XML_NAME "Mobile Link DDE XML Server Class"

#define kServerClass "MAL.Server"
#define kHandlerClass "MAL.AGDDEHandler"
#define kSubscriptionTopic "Subscription"
#define kXMLTopic "XML"

extern HINSTANCE g_hInstance;

/* ----------------------------------------------------------------------------
*/
LRESULT AGConfigDDEInitiate(HWND hwnd,
                            HWND hwndClient,
                            LPARAM lParam,
                            AGDDEHandler * ddeHandler)
{
    typedef enum {
        agUNKNOWN,
        agSUBSCRIPTION,
        agXML
    } DDEConversationType;

    HWND hwndServer;
    ATOM aApp, aSubTopic, aXMLTopic;

    aApp = GlobalAddAtom (kServerClass);
    aSubTopic = GlobalAddAtom (kSubscriptionTopic);
    aXMLTopic = GlobalAddAtom (kXMLTopic);

    /* If this conversation request is directed at us, look further... */
    if (LOWORD(lParam) == 0 || LOWORD(lParam) == aApp) {

        DDEConversationType ctype = agUNKNOWN;

        /* Is this topic one we know about? */
        if ((HIWORD (lParam) == 0 || HIWORD (lParam) == aXMLTopic)) {
            ctype = agXML;
        }
        else {
            if (HIWORD(lParam) == aSubTopic)
                ctype = agSUBSCRIPTION;
        }
        
        if (ctype != agUNKNOWN) {
        
            hwndServer = CreateWindow(
                (LPCTSTR)MAKELONG(
                    (ctype == agSUBSCRIPTION)
                    ? ddeHandler->subAtom
                    : ddeHandler->xmlAtom,
                    0),
                NULL,
                WS_CHILD,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                hwnd,
                NULL,
                g_hInstance,
                NULL);

            SetWindowLong(hwndServer, GWL_USERDATA, (LONG)hwndClient);

            SendMessage(hwndClient,
                WM_DDE_ACK,
                (WPARAM)hwndServer,
                MAKELPARAM(aApp,
                    (ctype == agSUBSCRIPTION) ? aSubTopic : aXMLTopic));

            return 0;
        }

    } else {
        GlobalDeleteAtom(aApp);
        GlobalDeleteAtom(aSubTopic);
        GlobalDeleteAtom(aXMLTopic);
    }

    return 0;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT onDDESubExecute(HWND hwnd,
                               HWND hwndClient,
                               GLOBALHANDLE hCommands)
{
    DDEACK DdeAck;
    LPSTR pCommands;
    AGBool submitResult;
    LPSTR parsedCommand = NULL;
    AGBool quitWhenDone = FALSE;

    pCommands = (LPSTR)GlobalLock(hCommands);

    parsedCommand = pCommands;

    if ('*' == parsedCommand[0]) {
        quitWhenDone = TRUE;
        parsedCommand++;
    }

    DdeAck.bAppReturnCode = 0;
    DdeAck.reserved = 0;
    DdeAck.fBusy = FALSE;

    submitResult = AGConfigHandleSubsFile(hwnd,
        (LPSTR)parsedCommand);
    
    DdeAck.fAck = submitResult;

    GlobalUnlock(hCommands);

    if (!PostMessage(hwndClient, WM_DDE_ACK, (WPARAM)hwnd,
        PackDDElParam(WM_DDE_ACK, (DWORD)&DdeAck, (UINT)hCommands))) {
        GlobalFree (hCommands);
        }
    
    if (quitWhenDone)
        PostQuitMessage(0);

    return 0;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT onDDEXMLExecute(HWND hwnd,
                               HWND hwndClient,
                               GLOBALHANDLE hCommands)
{
    DDEACK DdeAck;
    LPSTR pCommands;
    AGBool submitResult;
    LPSTR parsedCommand = NULL;
    AGBool quitWhenDone = FALSE;

    pCommands = (LPSTR)GlobalLock(hCommands);

    parsedCommand = pCommands;

    if ('*' == parsedCommand[0]) {
        quitWhenDone = TRUE;
        parsedCommand++;
    }

    DdeAck.bAppReturnCode = 0;
    DdeAck.reserved = 0;
    DdeAck.fBusy = FALSE;

    submitResult = AGConfigHandleXMLFile(hwnd, (LPSTR)parsedCommand);
    
    DdeAck.fAck = submitResult;

    GlobalUnlock(hCommands);

    if (!PostMessage(hwndClient, WM_DDE_ACK, (WPARAM)hwnd,
        PackDDElParam(WM_DDE_ACK, (DWORD)&DdeAck, (UINT)hCommands))) {
        GlobalFree (hCommands);
        }
    
    if (quitWhenDone)
        PostQuitMessage(0);

    return 0;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT onDDETerminate(HWND hwnd, HWND hwndClient)
{
    PostMessage(hwndClient, WM_DDE_TERMINATE, (WPARAM)hwnd, 0L) ;
    DestroyWindow(hwnd);
    return 0;
}

/* ----------------------------------------------------------------------------
*/
static LRESULT CALLBACK subServerProc(HWND hwnd,
                                      UINT message,
                                      WPARAM wParam,
                                      LPARAM lParam)
{
    switch (message) {
        case WM_DDE_EXECUTE:
            return onDDESubExecute(hwnd, (HWND)wParam, (GLOBALHANDLE)lParam);
        case WM_DDE_TERMINATE:
            return onDDETerminate(hwnd, (HWND)wParam);
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}

/* ----------------------------------------------------------------------------
*/
static LRESULT CALLBACK xmlServerProc(HWND hwnd,
                                      UINT message,
                                      WPARAM wParam,
                                      LPARAM lParam)
{
    switch (message) {
        case WM_DDE_EXECUTE:
            return onDDEXMLExecute(hwnd, (HWND)wParam, (GLOBALHANDLE)lParam);
        case WM_DDE_TERMINATE:
            return onDDETerminate(hwnd, (HWND)wParam);
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}

/* ----------------------------------------------------------------------------
*/
AGDDEHandler * AGDDEHandlerNew(void)
{
    AGDDEHandler * result;

    result = (AGDDEHandler *)malloc(sizeof(AGDDEHandler));

    if (NULL != result) {

        WNDCLASSEX wcex;

        wcex.cbSize        = sizeof(WNDCLASSEX);
        wcex.style         = 0;
        wcex.lpfnWndProc   = subServerProc;
        wcex.cbClsExtra    = 0;
        wcex.cbWndExtra    = 0;
        wcex.hInstance     = g_hInstance;
        wcex.hIcon         = NULL;
        wcex.hCursor       = LoadCursor (NULL, IDC_ARROW);
        wcex.hbrBackground = NULL;
        wcex.lpszMenuName  = NULL;
        wcex.lpszClassName = DDE_CLASS_SUB_NAME;
        wcex.hIconSm       = NULL;

        result->subAtom = RegisterClassEx(&wcex);

        wcex.lpfnWndProc   = xmlServerProc;
        wcex.lpszClassName = DDE_CLASS_XML_NAME;
        result->xmlAtom = RegisterClassEx(&wcex);

    }

    return result;
}

/* ----------------------------------------------------------------------------
*/
void AGDDEHandlerFree(AGDDEHandler * AGDDEHandler)
{
    if (NULL != AGDDEHandler)
        free(AGDDEHandler);
}

/* ----------------------------------------------------------------------------
*/
void AGConfigDDEHandleCommandLineLocally(HWND hwnd,
                                         ATOM cmdLine)
{
    char cmd[MAX_PATH];
    char * extension = cmd;

    GlobalGetAtomName(cmdLine, cmd, MAX_PATH);

    extension = PathFindExtension(cmd);
    if (0 == stricmp(".mal", extension))
        AGConfigHandleXMLFile(hwnd, cmd);

    else if (0 == stricmp(".subs", extension)
        || 0 == stricmp(".sub", extension))
        AGConfigHandleSubsFile(hwnd, cmd);

    GlobalDeleteAtom(cmdLine);

}