/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#include <AGConfig.h>
#include <AGConfigMainWindow.h>

HANDLE hSemaphore = NULL;
HINSTANCE g_hInstance = NULL;
HWND hMainDialog = NULL;
AGBool selfShotInHead = FALSE;

#define kASSearch "-activesync "

static BOOL doASTest(HWND hWnd, char * lpCmdLine, AGBool showMainDialog)
{
    char * astest = NULL;

    astest = strstr(lpCmdLine, kASSearch);

    if (NULL != astest && strlen(astest) > 0) {

        /* skip past activesync option to get to name of device */
        astest += strlen(kASSearch);

        if (showMainDialog)
            PostMessage(hWnd, WM_AG_CONFIG_SHOW_MAIN_DIALOG, 0, 0);

        PostMessage(hWnd,
            WM_AG_CONFIG_SELECT_CE_USER,
            GlobalAddAtom(astest),
            0);

        return TRUE;

    }

    return FALSE;

}

static BOOL CheckForPreviousInstance(char * cmd)
{
    /* Create a semaphore that will exist, system-wide, during the lifetime of
    this instance.  If it already existed, then this app is already running
    and we should exit. */

    hSemaphore = CreateSemaphore(NULL, 1, 1,
        "Mobile Application Link Semaphore");

    if (NULL != hSemaphore && ERROR_ALREADY_EXISTS == GetLastError()) {

        HWND hwnd;
        
        CloseHandle(hSemaphore);

        hwnd = FindWindow(AGConfigMainWindowGetClassName(), NULL);

        if (IsWindow(hwnd)) {

            SetForegroundWindow(hwnd);

            if (IsIconic(hwnd))
                ShowWindow(hwnd, SW_SHOWNORMAL); /* SW_RESTORE is obsolete. */

            if (cmd && *cmd) {

                if (!doASTest(hwnd, cmd, FALSE)) {

                    ATOM aCmd = GlobalAddAtom(cmd);
                    PostMessage(hwnd,
                        WM_AG_CONFIG_HANDLE_FILE,
                        (WPARAM)aCmd,
                        0);

                }

            }

        }
        return TRUE;
    }

    return FALSE;
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
    int ret = 0;
    MSG msg;
    HACCEL haccel = NULL;
    HWND hWnd;

    g_hInstance = hInstance;

    /* Check to see if we're already running. */
    if (CheckForPreviousInstance(lpCmdLine))
        return ret;

    /* Be sure Windows common controls are available. */
    InitCommonControls();

    /* Create the main window.  This window will be invisible. */
    hWnd = AGConfigMainWindowCreate(nCmdShow);

    if (NULL == hWnd)
        return GetLastError();

    if (lpCmdLine && *lpCmdLine) {

        /* If DDE started us up, don't display the main window.
        If we got some other command-line thing, assume it's a
        file from Netscape and send it there. */
        if (strcmp(lpCmdLine, "-dde")) {

            if (!doASTest(hWnd, lpCmdLine, TRUE)) {

                ATOM aCmd = GlobalAddAtom(lpCmdLine);
                PostMessage(hWnd, WM_AG_CONFIG_HANDLE_FILE, (WPARAM)aCmd, 1);

            }

        }

    }
    else {

        /* Tell the main window to put up the dialog when it is ready. */
        PostMessage(hWnd, WM_AG_CONFIG_SHOW_MAIN_DIALOG, 0, 0);

    }

    /* Standard windows event loop. */
    while (GetMessage(&msg, NULL, 0, 0)) {
        if (!TranslateAccelerator(msg.hwnd, haccel, &msg)) {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    DestroyWindow(hWnd);

    /* If we got here, we got a WM_QUIT message and wParam contains
    the result code. */
    ret = msg.wParam;

    if (hSemaphore)
        CloseHandle(hSemaphore);

    return ret;
}
