/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * thunk.h
 *
 * created: djw@avantgo.com, March 18, 1999.
 *
 * Contributor(s):
 */
#ifndef _THUNK_H_
#define _THUNK_H_

#ifndef __PILOT_H__
#include <Pilot.h>
#endif /*__PILOT_H__*/

#define THUNK_MAX_RECURSE 16

typedef Word ThunkType[10];

void* ThunkInit(void* buf, void* funcPtr);
void* ThunkInitFromA4A5(void* pbuf, void* funcPtr, void* a4, void* a5);

void* ThunkMake(void* funcPtr);

#define ThunkStackMake(f,p) ThunkType thunkBuf, *p = ThunkInit(&thunkBuf, (f))

/*
 * At the moment thunks are in writeable memory, but maybe they should
 * be in Dm memory. Use ThunkFree() and be happy....djw
 */
#define ThunkFree(t) MemPtrFree((t))

#endif /*_THUNK_H_*/
