/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * libmal.h
 *
 * defines traps and MALLibAG*() interfaces to libmal.prc
 *
 * created: djw@avantgo.com, March 18, 1999.
 *
 * Contributor(s):
 */
#ifndef _LIBMAL_H_
#define _LIBMAL_H_

#include <Pilot.h>
#include <AGTypes.h>
#include <AGBufferReader.h>
#include <AGBufferWriter.h>
#include <AGClientProcessor.h>
#include <AGCommandProcessor.h>
#include <AGPalmProtocol.h>
#include <AGMD5.h>
#include <AGBase64.h>

/* system reqd */
Err MALLibOpen(Word refNum) SYS_TRAP(sysLibTrapOpen);
Err MALLibClose(Word refNum) SYS_TRAP(sysLibTrapClose);
Err MALLibSleep(Word refNum) SYS_TRAP(sysLibTrapSleep);
Err MALLibWake(Word refNum) SYS_TRAP(sysLibTrapWake);

/* ours */
typedef enum {

    malLibTrapAGBufferReaderFinalize = (unsigned)sysLibTrapCustom,
    malLibTrapAGBufferReaderFree,
    malLibTrapAGBufferReaderInit,
    malLibTrapAGBufferReaderNew,
    malLibTrapAGBufferReaderPeek,
    malLibTrapAGBufferWriterFinalize,
    malLibTrapAGBufferWriterGetBuffer,
    malLibTrapAGBufferWriterGetBufferSize,
    malLibTrapAGBufferWriterInit,
    malLibTrapAGBufferWriterRemoveBuffer,
    malLibTrapAGBufferWriterReset,
    malLibTrapAGBufferWriterWrite,
    malLibTrapAGClientProcessorFinalize,
    malLibTrapAGClientProcessorFree,
    malLibTrapAGClientProcessorInit,
    malLibTrapAGClientProcessorNew,
    malLibTrapAGClientProcessorProcess,
    malLibTrapAGClientProcessorSync,
    malLibTrapAGCommandProcessorFinalize,
    malLibTrapAGCommandProcessorGetPerformFunc,
    malLibTrapAGCommandProcessorInit,
    malLibTrapAGCommandProcessorShouldSyncAgain,
    malLibTrapAGCommandProcessorStart,
    malLibTrapAGDeviceInfoFinalize,
    malLibTrapAGDeviceInfoInit,
    malLibTrapAGGetMsg,
    malLibTrapAGMd5,
    malLibTrapAGNetClose,
    malLibTrapAGNetInit,
    malLibTrapAGNetSetIOFuncs,
    malLibTrapAGPalmMALModToPilotAttribs,
    malLibTrapAGPalmPilotAttribsToMALMod,
    malLibTrapAGPalmReadDBConfigPlatformData,
    malLibTrapAGPalmReadRecordPlatformData,
    malLibTrapAGProtectedMemoryFinalize,
    malLibTrapAGProtectedMemoryInit,
    malLibTrapAGReadInt16,
    malLibTrapAGReadInt32,
    malLibTrapAGReadInt8,
    malLibTrapAGReadProtectedCString,
    malLibTrapAGServerConfigGetDBConfigNamed,
    malLibTrapAGServerConfigIsValid,
    malLibTrapAGServerConfigNew,
    malLibTrapAGServerConfigResetCookie,
    malLibTrapAGSkipCString,
    malLibTrapAGTime,
    malLibTrapAGUserConfigAddServer,
    malLibTrapAGUserConfigCount,
    malLibTrapAGUserConfigFinalize,
    malLibTrapAGUserConfigFree,
    malLibTrapAGUserConfigGetServerByIndex,
    malLibTrapAGUserConfigInit,
    malLibTrapAGUserConfigInitAndReadData,
    malLibTrapAGUserConfigNewAndReadData,
    malLibTrapAGUserConfigRemoveServer,
    malLibTrapAGUserConfigResetCookies,
    malLibTrapAGUserConfigWriteData,
    malLibTrapAGWriteBytes,
    malLibTrapAGWriteCString,
    malLibTrapAGWriteCompactInt,
    malLibTrapAGWriteInt16,
    malLibTrapAGWriteInt32,
    malLibTrapAGWriteInt8,
    malLibTrapAGWriterFinalize,
    malLibTrapAGWriterInit,
    malLibTrapAGBase64Encode,
    malLibTrapAGBase64Decode,
    malLibTrapAGNetCanDoSecure,
    malLibTrapAGNetGetCtxSize,
    malLibTrapAGNetToggle

} MalLibTrapNumber;

void MALLibAGBufferReaderFinalize(Word refnum, AGBufferReader* reader) \
    SYS_TRAP(malLibTrapAGBufferReaderFinalize);
void MALLibAGBufferReaderFree(Word refnum, AGBufferReader* reader) \
     SYS_TRAP(malLibTrapAGBufferReaderFree);
AGBufferReader* MALLibAGBufferReaderInit(Word refnum, AGBufferReader* reader, uint8* buf) \
     SYS_TRAP(malLibTrapAGBufferReaderInit);
AGBufferReader* MALLibAGBufferReaderNew(Word refnum, uint8* buf) \
     SYS_TRAP(malLibTrapAGBufferReaderNew);
uint8* MALLibAGBufferReaderPeek(Word refnum, AGBufferReader* reader) \
     SYS_TRAP(malLibTrapAGBufferReaderPeek);
void MALLibAGBufferWriterFinalize(Word refnum, AGBufferWriter* writer) \
     SYS_TRAP(malLibTrapAGBufferWriterFinalize);
uint8* MALLibAGBufferWriterGetBuffer(Word refnum, AGBufferWriter* writer) \
     SYS_TRAP(malLibTrapAGBufferWriterGetBuffer);
uint32 MALLibAGBufferWriterGetBufferSize(Word refnum, AGBufferWriter* writer) \
     SYS_TRAP(malLibTrapAGBufferWriterGetBufferSize);
AGBufferWriter* MALLibAGBufferWriterInit(Word refnum, AGBufferWriter* writer, uint32 cacheSize) \
     SYS_TRAP(malLibTrapAGBufferWriterInit);
uint8* MALLibAGBufferWriterRemoveBuffer(Word refnum, AGBufferWriter* writer) \
     SYS_TRAP(malLibTrapAGBufferWriterRemoveBuffer);
void MALLibAGBufferWriterReset(Word refnum, AGBufferWriter* writer) \
     SYS_TRAP(malLibTrapAGBufferWriterReset);
int32 MALLibAGBufferWriterWrite(Word refnum, void* aWriter, void* src, int32 len) \
     SYS_TRAP(malLibTrapAGBufferWriterWrite);
void MALLibAGClientProcessorFinalize(Word refnum, AGClientProcessor* processor) \
     SYS_TRAP(malLibTrapAGClientProcessorFinalize);
AGClientProcessor* MALLibAGClientProcessorInit(Word refnum, AGClientProcessor* processor, AGServerConfig* serverInfo,AGDeviceInfo* deviceInfo, AGLocationConfig* lc, AGPlatformCalls* platformCalls, AGBool bufferCommands, AGNetCtx* netctx) \
     SYS_TRAP(malLibTrapAGClientProcessorInit);
int32 MALLibAGClientProcessorProcess(Word refnum, AGClientProcessor* processor) \
     SYS_TRAP(malLibTrapAGClientProcessorProcess);
void MALLibAGClientProcessorSync(Word refnum, AGClientProcessor* processor) \
     SYS_TRAP(malLibTrapAGClientProcessorSync);
void MALLibAGCommandProcessorFinalize(Word refnum, AGCommandProcessor* processor) \
     SYS_TRAP(malLibTrapAGCommandProcessorFinalize);
AGPerformCommandFunc MALLibAGCommandProcessorGetPerformFunc(Word refnum, AGCommandProcessor*) \
     SYS_TRAP(malLibTrapAGCommandProcessorGetPerformFunc);
AGCommandProcessor* MALLibAGCommandProcessorInit(Word refnum,
						 AGCommandProcessor* processor,
						 AGServerConfig*) \
     SYS_TRAP(malLibTrapAGCommandProcessorInit);
AGBool MALLibAGCommandProcessorShouldSyncAgain(Word refnum, AGCommandProcessor*) \
     SYS_TRAP(malLibTrapAGCommandProcessorShouldSyncAgain);
int32 MALLibAGCommandProcessorStart(Word refnum, AGCommandProcessor* processor) \
     SYS_TRAP(malLibTrapAGCommandProcessorStart);
void MALLibAGDeviceInfoFinalize(Word refnum, AGDeviceInfo* deviceInfo) \
     SYS_TRAP(malLibTrapAGDeviceInfoFinalize);
AGDeviceInfo* MALLibAGDeviceInfoInit(Word refnum, AGDeviceInfo* deviceInfo) \
     SYS_TRAP(malLibTrapAGDeviceInfoInit);
sword MALLibAGNetClose(Word refnum, AGNetCtx* ctx) \
     SYS_TRAP(malLibTrapAGNetClose);
sword MALLibAGNetInit(Word refnum, AGNetCtx* ctx) \
     SYS_TRAP(malLibTrapAGNetInit);
void MALLibAGNetSetIOFuncs(Word refnum, AGNetCtx* ctx, AGNetSendFunc send, AGNetConnectFunc connect, AGNetReadFunc recv, AGNetCloseFunc close, AGNetSocketNewFunc socnew, AGNetSocketFreeFunc socfree, AGNetReadProtectedFunc recvdm) \
     SYS_TRAP(malLibTrapAGNetSetIOFuncs);
char* MALLibAGGetMsg(Word refnum, uint32 msgId) \
     SYS_TRAP(malLibTrapAGGetMsg);
uint8 MALLibAGPalmMALModToPilotAttribs(Word refnum, AGRecordStatus mod) \
     SYS_TRAP(malLibTrapAGPalmMALModToPilotAttribs);
AGRecordStatus MALLibAGPalmPilotAttribsToMALMod(Word refnum, uint8 attrib) \
     SYS_TRAP(malLibTrapAGPalmPilotAttribsToMALMod);
void MALLibAGPalmReadDBConfigPlatformData(Word refnum, AGReader* r, uint32* creator, uint32* type, uint32* flags) \
     SYS_TRAP(malLibTrapAGPalmReadDBConfigPlatformData);
void MALLibAGPalmReadRecordPlatformData(Word refnum, AGReader* r, int16* recordIndex) \
     SYS_TRAP(malLibTrapAGPalmReadRecordPlatformData);
uint16 MALLibAGReadInt16(Word refnum, AGReader* r) \
     SYS_TRAP(malLibTrapAGReadInt16);
uint32 MALLibAGReadInt32(Word refnum, AGReader* r) \
     SYS_TRAP(malLibTrapAGReadInt32);
uint8 MALLibAGReadInt8(Word refnum, AGReader* r) \
     SYS_TRAP(malLibTrapAGReadInt8);
char* MALLibAGReadProtectedCString(Word refnum, AGBufferReader* reader) \
     SYS_TRAP(malLibTrapAGReadProtectedCString);
AGDBConfig* MALLibAGServerConfigGetDBConfigNamed(Word refnum, AGServerConfig* config, char* dbname) \
     SYS_TRAP(malLibTrapAGServerConfigGetDBConfigNamed);
uint32 MALLibAGSkipCString(Word refnum, AGReader* r) \
     SYS_TRAP(malLibTrapAGSkipCString);
uint32 MALLibAGTime(Word refnum) \
     SYS_TRAP(malLibTrapAGTime);
int32 MALLibAGUserConfigCount(Word refnum, AGUserConfig*  serverList) \
     SYS_TRAP(malLibTrapAGUserConfigCount);
void MALLibAGUserConfigFree(Word refnum, AGUserConfig*  serverList) \
     SYS_TRAP(malLibTrapAGUserConfigFree);
AGServerConfig* MALLibAGUserConfigGetServerByIndex(Word refnum, AGUserConfig * serverList, int32 index) \
     SYS_TRAP(malLibTrapAGUserConfigGetServerByIndex);
AGUserConfig* MALLibAGUserConfigNewAndReadData(Word refnum, AGReader* r) \
     SYS_TRAP(malLibTrapAGUserConfigNewAndReadData);
void MALLibAGUserConfigResetCookies(Word refnum, AGUserConfig* config) \
     SYS_TRAP(malLibTrapAGUserConfigResetCookies);
void MALLibAGUserConfigWriteData(Word refnum, AGUserConfig*  serverList, AGWriter* w) \
     SYS_TRAP(malLibTrapAGUserConfigWriteData);
uint32 MALLibAGWriteBytes(Word refnum, AGWriter* w, void* buf, int32 len) \
     SYS_TRAP(malLibTrapAGWriteBytes);
void MALLibAGWriteCString(Word refnum, AGWriter* w, char* str) \
     SYS_TRAP(malLibTrapAGWriteCString);
void MALLibAGWriteCompactInt(Word refnum, AGWriter* w, uint32 val) \
     SYS_TRAP(malLibTrapAGWriteCompactInt);
void MALLibAGWriteInt16(Word refnum, AGWriter* w, uint16 val) \
     SYS_TRAP(malLibTrapAGWriteInt16);
void MALLibAGWriteInt32(Word refnum, AGWriter* w, uint32 val) \
     SYS_TRAP(malLibTrapAGWriteInt32);
void MALLibAGWriteInt8(Word refnum, AGWriter* w, uint8 val) \
     SYS_TRAP(malLibTrapAGWriteInt8);
void MALLibAGWriterFinalize(Word refnum, AGWriter* w) \
     SYS_TRAP(malLibTrapAGWriterFinalize);
AGWriter* MALLibAGWriterInit(Word refnum,
			     AGWriter* w, void* in, AGWriteFunc writeFunc) \
     SYS_TRAP(malLibTrapAGWriterInit);
void MALLibAGMd5(UInt refnum, uint8 *buf, int32 buflen, uint8 digest[16]) \
     SYS_TRAP(malLibTrapAGMd5);
AGUserConfig* MALLibAGUserConfigInitAndReadData(UInt refnum,
						AGUserConfig* userConfig,
						AGReader* r) \
     SYS_TRAP(malLibTrapAGUserConfigInitAndReadData);
void MALLibAGUserConfigInit(UInt refnum, AGUserConfig * serverList) \
     SYS_TRAP(malLibTrapAGUserConfigInit);

void MALLibAGUserConfigFinalize(UInt refnum, AGUserConfig * serverList) \
     SYS_TRAP(malLibTrapAGUserConfigFinalize);

AGServerConfig* MALLibAGServerConfigNew(UInt refnum) \
     SYS_TRAP(malLibTrapAGServerConfigNew);

int32 MALLibAGUserConfigAddServer(UInt refnum,
				AGUserConfig* serverList,
				AGServerConfig* serverConfig) \
     SYS_TRAP(malLibTrapAGUserConfigAddServer);
void MALLibAGUserConfigRemoveServer(UInt refnum,
				AGUserConfig* serverList,
				AGServerConfig* serverConfig) \
     SYS_TRAP(malLibTrapAGUserConfigRemoveServer);
void MALLibAGServerConfigResetCookie(UInt refnum, AGServerConfig *config) \
     SYS_TRAP(malLibTrapAGServerConfigResetCookie);
int16 MALLibAGProtectedMemoryInit(UInt refnum) \
     SYS_TRAP(malLibTrapAGProtectedMemoryInit);
void MALLibAGProtectedMemoryFinalize(UInt refnum) \
     SYS_TRAP(malLibTrapAGProtectedMemoryFinalize);
AGBool MALLibAGServerConfigIsValid(UInt refnum, AGServerConfig *config) \
     SYS_TRAP(malLibTrapAGServerConfigIsValid);
AGClientProcessor* MALLibAGClientProcessorNew(UInt refnum,
					    AGServerConfig *serverInfo,
					    AGDeviceInfo *deviceInfo,
					    AGLocationConfig *lc,
					    AGPlatformCalls *platformCalls,
					    AGBool bufferCommands,
					    AGNetCtx *netctx) \
     SYS_TRAP(malLibTrapAGClientProcessorNew);
void MALLibAGClientProcessorFree(UInt refnum, AGClientProcessor *processor) \
     SYS_TRAP(malLibTrapAGClientProcessorFree);
uint8* MALLibAGBase64Decode(UInt refnum, char *source, int32 *len) \
     SYS_TRAP(malLibTrapAGBase64Decode);
char* MALLibAGBase64Encode(UInt refnum, char *source, int32 len) \
     SYS_TRAP(malLibTrapAGBase64Encode);
sword MALLibAGNetCanDoSecure(UInt refnum, AGNetCtx *ctx) \
     SYS_TRAP(malLibTrapAGNetCanDoSecure);
int32 MALLibAGNetGetCtxSize(UInt refnum) \
     SYS_TRAP(malLibTrapAGNetGetCtxSize);
void MALLibAGNetToggle(UInt refnum, AGNetCtx *ctx, AGBool use) \
     SYS_TRAP(malLibTrapAGNetToggle);

#endif /*_LIBMAL_H_*/
