/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#ifndef __AGSYNCPALMDLLENTRY_H__
#define __AGSYNCPALMDLLENTRY_H__

#include <AGTypes.h>

typedef void *CString;
typedef void *CStringArray;

#include <windows.h>
#include <syncmgr.h>
#include <condapi.h>
#include <hslog.h>
#include <basemon.h>

#define AVANTGO_CONDUIT_VERSION			0x00000200
#define AVANTGO_CONDUIT_NAME			TEXT("Mobile Application Link")

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef long (*PROGRESSFN) (char*);
ExportFunc long OpenConduit(PROGRESSFN, CSyncProperties&);
ExportFunc long GetConduitName(char* pszName, WORD nLen);
ExportFunc DWORD GetConduitVersion();
ExportFunc long GetConduitInfo(ConduitInfoEnum infoType,
                               void *pInArgs,
                               void *pOut,
                               DWORD *pdwOutSize);
ExportFunc long ConfigureConduit(CSyncPreference&);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // #ifndef __AGSYNCPALMDLLENTRY_H__


