/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#include <AGSyncPalmDllEntry.h>
#include <AGSyncPalmResource.h>
#include <AGSyncPalm.h>
#include <crtdbg.h>

static HINSTANCE hInst;

#ifdef _DEBUG
#define debug_print(x) OutputDebugString(x)
#else
#define debug_print(x)
#endif

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
    hInst = hInstance;  /* save instance handle... */
    return 1;
}

ExportFunc long GetConduitName(char* pszName,WORD nLen)
{
    strncpy(pszName, AVANTGO_CONDUIT_NAME, nLen-1);  
    return 0;
}

ExportFunc DWORD GetConduitVersion()
{
    return AVANTGO_CONDUIT_VERSION;
}

ExportFunc long GetConduitInfo(ConduitInfoEnum infoType,
                               void *pInArgs,
                               void *pOut,
                               DWORD *pdwOutSize)
{
    if (NULL == pOut)
        return CONDERR_INVALID_PTR;
    if (NULL == pdwOutSize)
        return CONDERR_INVALID_OUTSIZE_PTR;

    switch (infoType) {
        case eConduitName:

            /* This code is for example. This conduit does not use this code */
            
            if (!pInArgs)
                return CONDERR_INVALID_INARGS_PTR;
            ConduitRequestInfoType *pInfo;
            pInfo = (ConduitRequestInfoType *)pInArgs;
            if ((pInfo->dwVersion != CONDUITREQUESTINFO_VERSION_1) ||
                (pInfo->dwSize != SZ_CONDUITREQUESTINFO))
                return CONDERR_INVALID_INARGS_STRUCT;
            
            break;
        case eDefaultAction:
            if (*pdwOutSize != sizeof(eSyncTypes))
                return CONDERR_INVALID_BUFFER_SIZE;
            (*(eSyncTypes*)pOut) = eFast;
            break;
        case eMfcVersion:
            if (*pdwOutSize != sizeof(DWORD))
                return CONDERR_INVALID_BUFFER_SIZE;
            (*(DWORD*)pOut) = MFC_VERSION_50;
            break;
        default:
            return CONDERR_UNSUPPORTED_CONDUITINFO_ENUM;
    }
    return 0;
}

ExportFunc long OpenConduit(PROGRESSFN pFn, CSyncProperties& rProps)
{
    debug_print("OpenConduit()\n");

    AGBool syncCompletedSuccessfully = FALSE;

    if (rProps.m_SyncType == eDoNothing)
        return SYNCERR_NONE;

    LogAddEntry("", slSyncStarted, FALSE);

    CONDHANDLE conduit;
    SyncRegisterConduit(conduit);
    syncCompletedSuccessfully = AGSyncToServer(hInst, rProps.m_UserName);
    SyncUnRegisterConduit(conduit);

    if (syncCompletedSuccessfully)
        LogAddEntry(AVANTGO_CONDUIT_NAME, slSyncFinished, FALSE);
    else {
        LogAddEntry(AVANTGO_CONDUIT_NAME, slSyncAborted, FALSE);
        LogAddEntry("", slWarning, FALSE);
    }

    return (syncCompletedSuccessfully ? SYNCERR_NONE : SYNCERR_UNKNOWN);
}

BOOL syncButtonChecked = FALSE;
BOOL setAsDefaultButtonChecked = FALSE;
HWND syncButton;

BOOL CALLBACK ConfigureEventLoop(HWND hDlg,
                                 UINT msg,
                                 WPARAM wParam,
                                 LPARAM lParam) {
    LRESULT value;

    switch(msg) {
    case WM_INITDIALOG: /** on init of the dialog... */
        if (syncButtonChecked) {
            syncButton = GetDlgItem(hDlg, SYNC_BUTTON);
        } else {
            syncButton = GetDlgItem(hDlg, SYNC_DO_NOTHING);
        }
        SendMessage(syncButton, BM_SETCHECK, 1, 0);
        break;
    case WM_COMMAND:
        switch(wParam) {
        case IDOK:
            /** determine if SYNC_BUTTON is checked */
            syncButton = GetDlgItem(hDlg, SYNC_BUTTON);
            value = SendMessage(syncButton, BM_GETSTATE, 0, 0);
            if (value == BST_CHECKED) {
                syncButtonChecked = TRUE;
            } else {
                syncButtonChecked = FALSE;
            }

            /** determine if SET_DEFAULT_BUTTON is checked */
            syncButton = GetDlgItem(hDlg, SET_DEFAULT_BUTTON);
            value = SendMessage(syncButton, BM_GETSTATE, 0, 0);
            if (value == BST_CHECKED) {
                setAsDefaultButtonChecked = TRUE;
            } else {
                setAsDefaultButtonChecked = FALSE;
            }
            
            EndDialog(hDlg, TRUE);
            break;
        case IDCANCEL:
            /** user pressed the cancel button, send
            FALSE as result for the dialog **/
            EndDialog(hDlg, FALSE);
            break;
        default:
            break;
        }
        break;
    default:
        break;
    }

    return 0;
}

ExportFunc long ConfigureConduit(CSyncPreference& rPrefs) {
    HWND parent;
    BOOL ok = FALSE;

    if (rPrefs.m_SyncType == eFast) {
        syncButtonChecked = TRUE;
    }
    if (rPrefs.m_SyncPref == 1) {
        setAsDefaultButtonChecked = TRUE;
    }

    parent = GetActiveWindow();
    ok = DialogBox(hInst, MAKEINTRESOURCE(CONFIGURE_DIALOG), 
                    parent, (DLGPROC)ConfigureEventLoop);

    if (!ok) {
        return 0;
    }

    if (syncButtonChecked) {
        rPrefs.m_SyncType = eFast;
    } else {
        rPrefs.m_SyncType = eDoNothing;
    }
    if (setAsDefaultButtonChecked) {
        rPrefs.m_SyncPref = ePermanentPreference;
    } else {
        rPrefs.m_SyncPref = eTemporaryPreference;
    }

    return 0;
}

