/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : util.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef MHUTIL_H
#define MHUTIL_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <string>
#include <vector>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <iostream>
#include <dirent.h>
#include <mhgui/Window.h>

#ifndef _WIN32
#include <pwd.h>
#endif

#ifdef _WIN32
//#define BUFFER 512
#include <windows.h>
#include <shlobj.h>
#include <io.h>

typedef HRESULT (*MYPROC) (HWND, int, HANDLE, DWORD, LPTSTR);
#endif

using std::string;
using std::vector;

using namespace mhgui;

typedef vector<string> StringVector;

const StringVector getPixmapsAlternatives     (const string& pixmap);
const StringVector getDataAlternatives        (const string& data);
const StringVector getBackgroundsAlternatives (const string& data);
const StringVector getTexturesAlternatives    (const string& texture);
const StringVector getShadersAlternatives    (const string& shader);

const string searchDataFile       (const string& data_file);
const string searchPixmapFile     (const string& pixmap_file);
const string searchBackgroundFile (const string& data_file);
const string searchTextureFile    (const string& texture_file);
const string searchShaderFile     (const string& shader_file);

const string searchDataDir   (const string& data_dir);
const string searchPixmapDir (const string& pixmap_dir);

const string searchFile (const StringVector &name_vector);
const string searchDir  (const StringVector &name_vector);

const string getHomeDir ();

const string getUserWorkDir();

const string getMyObjPath             ();
const string getMyPosesPath           ();
const string getMyPosesBasePath       ();
const string getMyBodysettingsPath    ();
const string getMyBodysettingsBasePath();
const string getRenderingPath         ();
const string getTexturesPath          ();
const string getShadersPath           ();

void createWorkingDirs();

enum RenderType
{
  NORMAL,
  PREVIEW,
  TOON
};

bool callRender(const string& cmd, Window &mainWindow);
bool compileShaders(const string& shader_compiler, Window &mainWindow);
bool compileTextures(const string& textures_dir, const string& texture_compiler, Window &mainWindow);
void rendering(Window &mainWindow, const RenderType type);

template <class T>
struct deleteFunctor
{
  void operator() (T& t) 
  {
    delete t;
  }
};

#endif // MHUTIL_H
