/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : ViewPanel.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef VIEWPANEL_H
#define VIEWPANEL_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <iostream>
#include <mhgui/Panel.h>
#include <mhgui/Image.h>
#include "ImageListener.h"
#include "util.h"

class ViewPanel : public Panel
{
public:
  ViewPanel ();
  virtual ~ViewPanel ();

  void createWidgets ();

private: // intentionally not implemented
  ViewPanel             (const ViewPanel&);
  ViewPanel& operator = (const ViewPanel&);

  Image *view1;
  Image *view2;
};

#endif // VIEWPANEL_H
