#include <mhgui/ImageSlider.h>
#include <mhgui/CGUtilities.h>
#include "TargetSliderListener.h"
#include "TargetSlider.h"
#include <animorph/Mesh.h>
#include "Global.h"
#include <stdio.h>
#include <assert.h>
#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

using namespace Animorph;
using namespace std;

TargetSliderListener::TargetSliderListener() 
: AbstractListener() 
{
}

TargetSliderListener::~TargetSliderListener() 
{
}

bool TargetSliderListener::mouseOver (const Point& inMousePos, Component *source)
{
  return false;
}

bool TargetSliderListener::mouseOut (const Point& inMousePos, Component *source)
{
  // TODO: the mouseOut event is perhaps a little wrong for this. 
  // better is mouseReleased, but this should generate an event also
  // if released outside the widget (but only for slider!!)

  return false;
}

bool TargetSliderListener::mouseDragged (const Point& inMousePos, Component *source)
{
  TargetSlider *imgSliderSource = dynamic_cast<TargetSlider *>(source); // req. RTTI!
  assert(imgSliderSource); // Check if this is really a TargetSlider object?

  Global &global = Global::instance ();
  Mesh *mesh = global.getMesh ();

  mesh->doMorph (imgSliderSource->getTargetName (), 
		 imgSliderSource->getSliderValue ());

  /* TODO:
   * It's a little slow to calc normals in realtime while morphing.
   * A better way is to calc it once after a drag operation ends. This
   * needs some changes in listener implementation.
   *
   * Another solution is to speed up normals calculation in animorph.
   * I've some good ideas how to do this...
   */
  
  return true;
}

bool TargetSliderListener::mousePressed(const Point& inMousePos, int button, Component *source)
{
  return false;
}

bool TargetSliderListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  Global &global = Global::instance ();
  Mesh *mesh = global.getMesh ();
  mesh->calcNormals ();
  return false;
}

bool TargetSliderListener::keyType (unsigned char key, Component *source)
{
  return false;
}
