/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : ImageListener.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include <iostream>
#include <assert.h>
#include <animorph/RIBExporter.h>
#include <animorph/ObjExporter.h>
#include <animorph/MathUtil.h>
#include <animorph/DirectoryList.h>
#include <mhgui/Window.h>
#include <mhgui/Image.h>
#include <mhgui/CGUtilities.h>
#include <mhgui/Console.h>
#include <mhgui/Camera.h>
#include "ImageListener.h"
#include "ComponentID.h"
#include "Global.h"
#include "util.h"
#include "DialogPanel.h"
#include "TargetPanel.h"
#include "PoseTargetPanel.h"
#include "PosesBodyPanel.h"
#include "BodyPanel.h"
#include "TeethPanel.h"
#include "FacePanel.h"
#include "HandsPanel.h"
#include "FantasyBodyPanel.h"
#include "FantasyFacePanel.h"
#include "FantasyTeethPanel.h"
#include "FantasyHandsPanel.h"
#include "CharacterSettingPanel.h"
#include "ConsoleCommands.h"
#include "BottomPanel.h"
#include "SplashPanel.h"
#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

using namespace std;

const static Point kBottomPosition1 (0,430);
const static Point kBottomPosition2 (0,464);
const static Point kBottomPosition3 (0,496);


ImageListener::ImageListener()
    : AbstractListener()
{
}

ImageListener::~ImageListener()
{
}

bool ImageListener::mouseOver (const Point& inMousePos, Component *source)
{
  Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
  assert(imgSource); // Check if this is really an Image object?

  imgSource->setOverlayRectangle (Color (1,0,0,0.5));

  return false;
}

bool ImageListener::mouseOut (const Point& inMousePos, Component *source)
{
  Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
  assert(imgSource); // Check if this is really an Image object?

  imgSource->setOverlayRectangle (false);

  return false;
}

bool ImageListener::mouseDragged (const Point& inMousePos, Component *source)
{
  return true;
}

bool ImageListener::mousePressed (const Point& inMousePos, int button, Component *source)
{
  if (button == GLUT_LEFT_BUTTON)
  {
    Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
    assert(imgSource); // Check if this is really an Image object?
    imgSource->setOverlayRectangle(Color (1,1,1,0.5));  
    
    return true;
  }  
  return false;
}

bool ImageListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  if (button == GLUT_LEFT_BUTTON)
  {
    Image *imgSource = dynamic_cast<Image *>(source); // req. RTTI!
    assert(imgSource); // Check if this is really an Image object?
    
    if(imgSource->getAbsoluteRect().isHitBy(inMousePos))
    {
      Global &global = Global::instance ();
  
      //DialogPanel *dialogPanel;// = new DialogPanel (imgSource->getID ());

      Window &mainWindow = Window::instance ();
      imgSource->setOverlayRectangle(false);
    
      switch (imgSource->getID ())
      {
      case kComponentID_ImageToolbarPanel_LoadBodysettings:
        {
          if(global.getAppMode() == BODY_DETAILS || 
             global.getAppMode() == FANTASY_BODY_DETAILS ||
             global.getAppMode() == CHARACTER_SETTING)
          {
            mainWindow.getConsole()->openWithCommand(kConsoleCommand_Load_Bodysettings, kConsoleMessage_Load_Bodysettings, getMyBodysettingsPath());
          }
          else if(global.getAppMode() == POSES)
          {
            mainWindow.getConsole()->openWithCommand(kConsoleCommand_Load_Poses, kConsoleMessage_Load_Poses, getMyPosesPath());
          }
        }
        break;
      case kComponentID_ImageToolbarPanel_SaveBodysettings:
        {
          if(global.getAppMode() == BODY_DETAILS || 
             global.getAppMode() == FANTASY_BODY_DETAILS ||
             global.getAppMode() == CHARACTER_SETTING)
          {
            mainWindow.getConsole()->openWithCommand(kConsoleCommand_Save_Bodysettings, kConsoleMessage_Save_Bodysettings, getMyBodysettingsPath());
          }
          else if(global.getAppMode() == POSES)
          {
            mainWindow.getConsole()->openWithCommand(kConsoleCommand_Save_Poses, kConsoleMessage_Save_Poses, getMyPosesPath());
          }
        }
        break;      
      case kComponentID_ImageToolbarPanel_ExportWavefrontObj:
        mainWindow.getConsole()->openWithCommand(kConsoleCommand_Export_Object, kConsoleMessage_Export_Object, getMyObjPath());
        break;
      case kComponentID_ImageToolbarPanel_CharacterSettings:
        {
          if(global.getAppMode() == CHARACTER_SETTING) return true;
          
          hidePanels(global.getAppMode());

          if(global.getAppMode() != FANTASY_BODY_DETAILS && global.getAppMode() != BODY_DETAILS)
          {
            Mesh *mesh = global.getMesh ();
            assert (mesh);
                     
            mesh->bodyDetailsMode();
          }
          
          global.setAppMode(CHARACTER_SETTING);
          showCharacterSetting();
        }
        break;
      case kComponentID_ImageToolbarPanel_BodyDetailsRealistic:
        {
          if(global.getAppMode() == BODY_DETAILS) return true;
          
          hidePanels(global.getAppMode());            

          if(global.getAppMode() != FANTASY_BODY_DETAILS && global.getAppMode() != CHARACTER_SETTING)
          {
            Mesh *mesh = global.getMesh ();
            assert (mesh);
                     
            mesh->bodyDetailsMode();
          }
          
          global.setAppMode(BODY_DETAILS);
          showBodyDetails();           
        }
        break;
      case kComponentID_ImageToolbarPanel_BodyDetailsFantasy:
        {
          if(global.getAppMode() == FANTASY_BODY_DETAILS) return true;
          
          hidePanels(global.getAppMode());          
          
          if(global.getAppMode() != BODY_DETAILS && global.getAppMode() != CHARACTER_SETTING)
          {
            Mesh *mesh = global.getMesh ();
            assert (mesh);
                     
            mesh->bodyDetailsMode();
          }
          global.setAppMode(FANTASY_BODY_DETAILS);
          
          showFantasyBodyDetails();                                   
        }
        break;
      case kComponentID_ImageToolbarPanel_Clothes:

        break;
      case kComponentID_ImageToolbarPanel_Poses:
        {
          if(global.getAppMode() == POSES) return true;
          
          hidePanels(global.getAppMode());       
          global.setAppMode(POSES);                                                
          
          Mesh *mesh = global.getMesh ();
          assert (mesh);          
          mesh->poseMode();
          
          showPoses();
        }        
        break;
      case kComponentID_ImageToolbarPanel_Lights:

        break;
      case kComponentID_ImageToolbarPanel_Expressions:

        break;
      case kComponentID_ImageToolbarPanel_Asymmetry:

        break;
      case kComponentID_ImageToolbarPanel_Hairs:

        break;
      case kComponentID_ImageToolbarPanel_Materials:

        break;
      case kComponentID_ImageToolbarPanel_Rendering:
        rendering(mainWindow, NORMAL);
        break;
      case kComponentID_ImageUtilitybar_Quit: 
        exit (0);
        break;
      case kComponentID_ImageUtilitybar_Grid:
        {
          if (global.getDrawGrid())
	        global.setDrawGrid (false);
          else
	        global.setDrawGrid (true);
        }
        break;
      case kComponentID_ImageUtilitybar_FlatShading:
        {
          if (global.getFlatShading())
	        global.setFlatShading (false);
          else
	        global.setFlatShading (true);
        }
        break;        
      case kComponentID_ImageUtilitybar_MorhingList:
        {
          Panel *p = mainWindow.getPanel (kComponentID_TargetPanel);
          if(p != NULL) delete p;

          if(global.getAppMode() == BODY_DETAILS ||
             global.getAppMode() == FANTASY_BODY_DETAILS ||
             global.getAppMode() == CHARACTER_SETTING)
          {
            TargetPanel *targetPanel;
    
            int x = mainWindow.getSize().getWidth() - 210;
            targetPanel = new TargetPanel (applied_target_list, Rect(x,40,210,550));
            mainWindow.addPanel (targetPanel);
            targetPanel->createWidgets ();
            targetPanel->show_all();
          }
          else if(global.getAppMode() == POSES)
          {
            PoseTargetPanel *targetPanel;
    
            int x = mainWindow.getSize().getWidth() - 210;
            targetPanel = new PoseTargetPanel (applied_target_list, Rect(x,40,210,550));
            mainWindow.addPanel (targetPanel);
            targetPanel->createWidgets ();
            targetPanel->show_all();               
          }
        }
        break;
      case kComponentID_ImageUtilitybar_RenderPreview: 
        {
          rendering(mainWindow, PREVIEW);
        }
        break;
      case kComponentID_ImageUtilitybar_About: 
        {
          SplashPanel *splashScreen = (SplashPanel *)mainWindow.getPanel(kComponentID_SplashPanel);
          
          if(splashScreen == NULL)
          {
            global.setDrawGrid(false);
            splashScreen = new SplashPanel();
            mainWindow.addPanel (splashScreen);
            splashScreen->createWidgets ();
            splashScreen->show_all();
          }
        }
        break;
      case kComponentID_CloseTargetPanel:
        {
          Panel *p = mainWindow.getPanel (kComponentID_TargetPanel);
          mainWindow.removePanel(p);
        }
        break;
      
      // main character setting panel icons  
      case kComponentID_CharacterSettingPanel_Reset:
        {
          CharacterSettingPanel *csp = (CharacterSettingPanel *)mainWindow.getPanel (kComponentID_CharacterSettingPanel);
          if(csp != NULL)  
            csp->resetTargetValues();

          Mesh *mesh = global.getMesh ();
          assert (mesh);
                     
          mesh->resetMorph();
          mesh->calcNormals();
                    
        }   
        break;        
      default:
        cerr << "Unknown widget handler!" << endl;
      }

    return true;
    }
  }

  return false;
}

bool ImageListener::keyType (unsigned char key, Component *source)
{
  return false;
}

void ImageListener::hidePanels(const Modes currentMode)
{
  if(currentMode == POSES)
  {
    hidePoses();             
  }
  else if(currentMode == BODY_DETAILS)
  {
    hideBodyDetails();           
  }
  else if(currentMode == FANTASY_BODY_DETAILS)
  {
    hideFantasyBodyDetails();       
  }
  else if(currentMode == CHARACTER_SETTING)
  {
    hideCharacterSetting();
  }  
}

void ImageListener::hideBodyDetails ()
{
  Window &mainWindow = Window::instance ();
  Panel *p = mainWindow.getPanel (kComponentID_BodyPanel);
  if(p != NULL) delete p;           
          
  p = mainWindow.getPanel (kComponentID_FacePanel);
  if(p != NULL) delete p;

  p = mainWindow.getPanel (kComponentID_TeethPanel);
  if(p != NULL) delete p;     
  
  p = mainWindow.getPanel (kComponentID_HandsPanel);
  if(p != NULL) delete p;  
  
  p = mainWindow.getPanel (kComponentID_TargetPanel);
  if(p != NULL) delete p;  
}

void ImageListener::hideCharacterSetting()
{
  Window &mainWindow = Window::instance ();
  Panel *p = mainWindow.getPanel (kComponentID_CharacterSettingPanel);
  if(p != NULL) delete p;
  
  p = mainWindow.getPanel (kComponentID_TargetPanel);
  if(p != NULL) delete p;        
}

void ImageListener::hidePoses()
{
  Window &mainWindow = Window::instance ();
  Panel *p = mainWindow.getPanel (kComponentID_BodyPanel);
  if(p != NULL) delete p;       
   
  p = mainWindow.getPanel (kComponentID_TargetPanel);
  if(p != NULL) delete p;     
}

void ImageListener::hideFantasyBodyDetails ()
{
  Window &mainWindow = Window::instance ();
  Panel *p = mainWindow.getPanel (kComponentID_FantasyBodyPanel);
  if(p != NULL) delete p;           
          
  p = mainWindow.getPanel (kComponentID_FantasyFacePanel);
  if(p != NULL) delete p;

  p = mainWindow.getPanel (kComponentID_FantasyTeethPanel);
  if(p != NULL) delete p;     
  
  p = mainWindow.getPanel (kComponentID_FantasyHandsPanel);
  if(p != NULL) delete p;  
  
  p = mainWindow.getPanel (kComponentID_TargetPanel);
  if(p != NULL) delete p;  
}

void ImageListener::showCharacterSetting()
{
  Window &mainWindow = Window::instance ();
  
  CharacterSettingPanel *characterSettingPanel = new CharacterSettingPanel();
  mainWindow.addPanel (characterSettingPanel);
  characterSettingPanel->createWidgets ();
  characterSettingPanel->show_all();  
  
  BottomPanel *p = (BottomPanel *)mainWindow.getPanel (kComponentID_BottomPanel);
  assert(p);
  p->setPosition(kBottomPosition1);
  p->createWidgets();
}

void ImageListener::showFantasyBodyDetails()
{
  Window &mainWindow = Window::instance ();
  FantasyBodyPanel *fantasyBodyPanel = new FantasyBodyPanel();
  mainWindow.addPanel (fantasyBodyPanel);
  fantasyBodyPanel->createWidgets ();
  fantasyBodyPanel->show_all();
  
  FantasyFacePanel *fantasyFacePanel = new FantasyFacePanel();
  mainWindow.addPanel (fantasyFacePanel);
  fantasyFacePanel->createWidgets ();
  fantasyFacePanel->show_all();  
  
  FantasyTeethPanel *fantasyTeethPanel = new FantasyTeethPanel();
  mainWindow.addPanel (fantasyTeethPanel);
  fantasyTeethPanel->createWidgets ();
  fantasyTeethPanel->show_all();  
  
  FantasyHandsPanel *fantasyHandsPanel = new FantasyHandsPanel();
  mainWindow.addPanel (fantasyHandsPanel);
  fantasyHandsPanel->createWidgets ();
  fantasyHandsPanel->show_all();
  
  BottomPanel *p = (BottomPanel *)mainWindow.getPanel (kComponentID_BottomPanel);
  assert(p);
  p->setPosition(kBottomPosition3);
  p->createWidgets();  
}

void ImageListener::showBodyDetails()
{
  Window &mainWindow = Window::instance ();
  
  BodyPanel *bodyPanel = new BodyPanel();
  mainWindow.addPanel (bodyPanel);
  bodyPanel->createWidgets ();
  bodyPanel->show_all();
  
  FacePanel *facePanel = new FacePanel();
  mainWindow.addPanel (facePanel);
  facePanel->createWidgets ();
  facePanel->show_all();      

  TeethPanel *teethPanel = new TeethPanel();
  mainWindow.addPanel (teethPanel);
  teethPanel->createWidgets ();
  teethPanel->show_all();
  
  HandsPanel *handsPanel = new HandsPanel();
  mainWindow.addPanel (handsPanel);
  handsPanel->createWidgets ();
  handsPanel->show_all();
  
  BottomPanel *p = (BottomPanel *)mainWindow.getPanel (kComponentID_BottomPanel);
  assert(p);
  p->setPosition(kBottomPosition3);
  p->createWidgets();
}

void ImageListener::showPoses()
{
  Window &mainWindow = Window::instance ();
  PosesBodyPanel *posesPanel = new PosesBodyPanel();
  mainWindow.addPanel (posesPanel);
  posesPanel->createWidgets ();
  posesPanel->show_all();
  
  BottomPanel *p = (BottomPanel *)mainWindow.getPanel (kComponentID_BottomPanel);
  assert(p);
  p->setPosition(kBottomPosition2);
  p->createWidgets();                 
}
