/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : Global.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef GLOBAL_H
#define GLOBAL_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <animorph/Mesh.h>
#include <mhgui/Camera.h>

using namespace Animorph;

enum Modes
{
  BODY_DETAILS,
  POSES,
  FANTASY_BODY_DETAILS,
  CHARACTER_SETTING
};

class Global
{
private: 
    static Global* sSingleGlobal;

  // intentionally not implemented
  Global() : mesh (NULL), drawGrid (false), flatShading(true), appMode(CHARACTER_SETTING) {}

  Global             (const Global&);
  Global& operator = (const Global&);

  //some global variables
  Mesh *mesh;
  Camera *camera;
  bool drawGrid;
  bool flatShading;
  Modes appMode;

  static Global glob;

public:
  static Global& instance() ;

  void setMesh (Mesh *mesh) {this->mesh = mesh;}
  Mesh *getMesh () {return mesh;}
  
  void setCamera (Camera *camera) {this->camera = camera;}
  Camera *getCamera () {return camera;}

  void setDrawGrid (bool grid) {drawGrid = grid;}
  bool getDrawGrid () {return drawGrid;}

  void setFlatShading (bool flat) {flatShading = flat;}
  bool getFlatShading () {return flatShading;}

  void setAppMode (Modes mode) {appMode = mode;}
  Modes getAppMode () {return appMode;}   
};

#endif // GLOBAL_H
