/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : FantasyBodyPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "FantasyBodyPanel.h"
#include "ImageListener.h"
#include "ComponentID.h"

#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/Tooltip.h>
//#include "Global.h"

using namespace std;
using namespace Animorph;

FantasyBodyPanel::FantasyBodyPanel ()
    : Panel (kComponentID_FantasyBodyPanel, Rect(0,16,96,384))
{
}

FantasyBodyPanel::~FantasyBodyPanel ()
{
  for_each (imageVector.begin (), imageVector.end (), deleteFunctor <Image*> ());
}

void FantasyBodyPanel::createWidgets ()
{
  Window &mainWindow = Window::instance ();

  Panel *tooltipPanel = mainWindow.getPanel(kComponentID_TooltipPanel);
  assert(tooltipPanel);

  const Color color_red (1.0, 0.0, 0.0);
  const Point kTooltipPos(70, 12);
  const float alpha = 0.8;
  Image *body;

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_TorsoParams,
                   searchPixmapFile ("ui/ns_body_01.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Torso parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_HeadParams,
                   searchPixmapFile ("ui/ns_body_02.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Head parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_TorsoParams2,
                   searchPixmapFile ("ui/ns_body_03.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Torso parameters 2", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightShoulderParams,
                   searchPixmapFile ("ui/ns_body_04.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Shoulder parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_NeckParams,
                   searchPixmapFile ("ui/ns_body_05.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Neck parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftShoulderParams,
                   searchPixmapFile ("ui/ns_body_06.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Shoulder parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightUpperArmParams,
                   searchPixmapFile ("ui/ns_body_07.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Upper arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_body_08.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftUpperArmParams,
                   searchPixmapFile ("ui/ns_body_09.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Upper arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightLowerArmParams,
                   searchPixmapFile ("ui/ns_body_10.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Lower arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_AbdomenParams,
                   searchPixmapFile ("ui/ns_body_11.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Abdomen parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftLowerArmParams,
                   searchPixmapFile ("ui/ns_body_12.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Lower arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightHandParams,
                   searchPixmapFile ("ui/ns_body_13.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Hand parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_PelvisParams,
                   searchPixmapFile ("ui/ns_body_14.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Pelvis parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftHandParams,
                   searchPixmapFile ("ui/ns_body_15.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Hand parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightUpperLegParams,
                   searchPixmapFile ("ui/ns_body_16.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Upper leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_body_17.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftUpperLegParams,
                   searchPixmapFile ("ui/ns_body_18.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Upper leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightLowerLegParams,
                   searchPixmapFile ("ui/ns_body_19.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Lower leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_body_20.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftLowerLegParams,
                   searchPixmapFile ("ui/ns_body_21.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Lower leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightFootParams2,
                   searchPixmapFile ("ui/ns_body_22.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Foot parameters 2", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_body_23.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftFootParams2,
                   searchPixmapFile ("ui/ns_body_24.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Foot parameters 2", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_RightFootParams,
                   searchPixmapFile ("ui/ns_body_25.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Foot parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/ns_body_26.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_FantasyBody_LeftFootParams,
                   searchPixmapFile ("ui/ns_body_27.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Foot parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

}
