/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : ConsoleCommands.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef CONSOLECOMMANDS_H
#define CONSOLECOMMANDS_H 1

static const string kConsoleCommand_Load_Background            = "lbg";
static const string kConsoleCommand_Load_Bodysettings          = "lbs";
static const string kConsoleCommand_Load_Poses                 = "lps";
static const string kConsoleCommand_Save_Bodysettings          = "sbs";
static const string kConsoleCommand_Save_Poses                 = "sps";
static const string kConsoleCommand_Export_Object              = "ewo";


// console messages
static const string kConsoleMessage_Load_Background            = "Load background image (*.png)";
static const string kConsoleMessage_Load_Background_Success    = "Background image loaded";

static const string kConsoleMessage_Load_Bodysettings          = "Load BodySettings file (*.bs)";
static const string kConsoleMessage_Load_Bodysettings_Success  = "BodySettings loaded";

static const string kConsoleMessage_Save_Bodysettings          = "Save BodySettings file (*.bs)";
static const string kConsoleMessage_Save_Bodysettings_Success  = "BodySettings saved";

static const string kConsoleMessage_Load_Poses                 = "Load Poses file (*.bs)";
static const string kConsoleMessage_Load_Poses_Success         = "Poses loaded";

static const string kConsoleMessage_Save_Poses                 = "Save Poses file (*.bs)";
static const string kConsoleMessage_Save_Poses_Success         = "Poses saved";

static const string kConsoleMessage_Export_Object              = "Export OBJ file (*.obj,*.mtl)";
static const string kConsoleMessage_Export_Object_Success      = "OBJ file exported";

static const string kConsoleMessage_Load_Error                 = "Error: Couldn't load file. Press ESC to exit!";
static const string kConsoleMessage_Save_Error                 = "Error: Couldn't save file. Press ESC to exit!";
static const string kConsoleMessage_Unknown_Command            = "Unknown command";

static const string kConsoleMessage_RenderEngineNotFound       = "Unable to find a render engine. Press ESC to exit!";
static const string kConsoleMessage_TextureCompileError        = "Error during texture compilation. Press ESC to exit!";
static const string kConsoleMessage_ShaderCompileError         = "Error during shader compilation. Press ESC to exit!";
static const string kConsoleMessage_RenderError                = "Rendering error. Press ESC to exit!";

#endif // CONSOLECOMMANDS_H
