/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : CharacterSettingPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "CharacterSettingPanel.h"
#include "ImageListener.h"
#include "ComponentID.h"

#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/Tooltip.h>
//#include "Global.h"

using namespace std;
using namespace Animorph;

CharacterSettingPanel::CharacterSettingPanel ()
    : Panel (kComponentID_CharacterSettingPanel, Rect(0,16,192,430))
{
}

CharacterSettingPanel::~CharacterSettingPanel ()
{
  for_each (imageVector.begin (), imageVector.end (), deleteFunctor <Image*> ());
  for_each (targetVector.begin (), targetVector.end (), deleteFunctor <TargetSlider*> ());
}

void CharacterSettingPanel::createWidgets ()
{
  Window &mainWindow = Window::instance ();

  Panel *tooltipPanel = mainWindow.getPanel(kComponentID_TooltipPanel);
  assert(tooltipPanel);

  const Color c (1.0, 0.0, 0.0);
  const Point kTooltipPos(70, 12);
  const float alpha = 0.8;
  const int overlayMultiplier = 1;
  
  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_EctoLeft,
                                   searchPixmapFile ("ui/mainpanel_01.png"),
                                   "types/ectomorph1.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Ectomorph arms", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);

  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_EctoMiddle,
                                   searchPixmapFile ("ui/mainpanel_02.png"),
                                   "types/ectomorph2.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Ectomorph torso", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);

  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_EctoRight,
                                   searchPixmapFile ("ui/mainpanel_03.png"),
                                   "types/ectomorph3.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Ectomorph legs", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);
  
  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_MesoLeft,
                                   searchPixmapFile ("ui/mainpanel_04.png"),
                                   "types/mesomorph1.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Mesomorph arms", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);  
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);   
  
  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_MesoMiddle,
                                   searchPixmapFile ("ui/mainpanel_05.png"),
                                   "types/mesomorph2.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Mesomorph torso", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);
  
  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_MesoRight,
                                   searchPixmapFile ("ui/mainpanel_06.png"),
                                   "types/mesomorph3.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Mesomorph legs", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);  
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);  
  
  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_EndoLeft,
                                   searchPixmapFile ("ui/mainpanel_07.png"),
                                   "types/endomorph1.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Endomorph arms", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);

  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_EndoMiddle,
                                   searchPixmapFile ("ui/mainpanel_08.png"),
                                   "types/endomorph2.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Endomorph torso", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);

  // -------------------------------------------------------------------------
  target_slider = new TargetSlider (kComponentID_CharacterSettingPanel_EndoRight,
                                   searchPixmapFile ("ui/mainpanel_09.png"),
                                   "types/endomorph3.bs",
                                   Rect(0,0,64,74), 0.0, 1.0);

  target_slider->setListener(&bsSliderListener);
  target_slider->setTooltip(Tooltip("Endomorph legs", kTooltipPos, c, tooltipPanel));
  target_slider->setOverlayMultiplier(overlayMultiplier);
  target_slider->setAlpha (alpha);
  targetVector.push_back (target_slider);
  addWidget (target_slider);
    
  // -------------------------------------------------------------------------
  
  img = new Image (kComponentID_CharacterSettingPanel_Characters1,
                   searchPixmapFile ("ui/mainpanel_10.png"),
                   Rect(0,0,64,64));
  img->setListener(&bsListener);
  img->setTooltip(Tooltip("Characters 1", kTooltipPos, c, tooltipPanel));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
  // -------------------------------------------------------------------------

  img = new Image (kComponentID_CharacterSettingPanel_Characters2,
                   searchPixmapFile ("ui/mainpanel_11.png"),
                   Rect(0,0,64,64));
  img->setListener(&bsListener);
  img->setTooltip(Tooltip("Characters 2", kTooltipPos, c, tooltipPanel));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
  // -------------------------------------------------------------------------

  img = new Image (kComponentID_CharacterSettingPanel_Characters3,
                   searchPixmapFile ("ui/mainpanel_12.png"),
                   Rect(0,0,64,64));
  img->setListener(&bsListener);
  img->setTooltip(Tooltip("Characters 3", kTooltipPos, c, tooltipPanel));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);

  // -------------------------------------------------------------------------

  img = new Image (kComponentID_CharacterSettingPanel_NSCharacters1,
                   searchPixmapFile ("ui/mainpanel_13.png"),
                   Rect(0,0,64,64));
  img->setListener(&bsListener);
  img->setTooltip(Tooltip("Fantasy Characters 1", kTooltipPos, c, tooltipPanel));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
  // -------------------------------------------------------------------------
  
  img = new Image (kComponentID_Dummy,
                   searchPixmapFile ("ui/mainpanel_14.png"),
                   Rect(0,0,64,64));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
  // -------------------------------------------------------------------------

  img = new Image (kComponentID_CharacterSettingPanel_NSCharacters2,
                   searchPixmapFile ("ui/mainpanel_15.png"),
                   Rect(0,0,64,64));
  img->setListener(&bsListener);
  img->setTooltip(Tooltip("Fantasy Characters 2", kTooltipPos, c, tooltipPanel));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
  // -------------------------------------------------------------------------

  img = new Image (kComponentID_CharacterSettingPanel_NSCharacters3,
                   searchPixmapFile ("ui/mainpanel_16.png"),
                   Rect(0,0,64,64));
  img->setListener(&bsListener);
  img->setTooltip(Tooltip("Fantasy Characters 3", kTooltipPos, c, tooltipPanel));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
  // -------------------------------------------------------------------------
  
  img = new Image (kComponentID_CharacterSettingPanel_Reset,
                   searchPixmapFile ("ui/mainpanel_17.png"),
                   Rect(0,0,64,64));
  img->setListener(&imgListener);
  img->setTooltip(Tooltip("Reset mesh", kTooltipPos, c, tooltipPanel));                   
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
  // -------------------------------------------------------------------------
  
  img = new Image (kComponentID_CharacterSettingPanel_MyBS,
                   searchPixmapFile ("ui/mainpanel_18.png"),
                   Rect(0,0,64,64));
  img->setListener(&bsListener);
  img->setTooltip(Tooltip("My Characters", kTooltipPos, c, tooltipPanel));
  img->setAlpha (alpha);
  imageVector.push_back (img);
  addWidget (img);
  
}

void CharacterSettingPanel::resetTargetValues(const string currentTarget)
{       
  for (vector <TargetSlider*>::const_iterator targetvector_it = targetVector.begin ();
         targetvector_it != targetVector.end ();
         targetvector_it++)
  {       
    if((*targetvector_it)->getTargetName() != currentTarget) 
    {
      (*targetvector_it)->setSliderValue(0);            
    }
  }      
}
