/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : BsPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "BsPanel.h"
#include "ComponentID.h"
#include "Global.h"

#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/ImageSlider.h>
#include <mhgui/Tooltip.h>
#include "Global.h"

using namespace std;
using namespace Animorph;

#include "ComponentID.h"

const static string kFilePrefixTarget (".bs");
const static string kFilePrefixPNG    (".png");

BsPanel::BsPanel (const string& category, const Rect& rect)
    : Panel (kComponentID_TargetPanel, rect),
    category (category)
{
  setRightAnchor (true);
  setRowSpacing (5);
  setColumnSpacing (3);
}

BsPanel::~BsPanel ()
{
  for_each (targetVector.begin (), targetVector.end (), deleteFunctor <TargetSlider*> ());
  delete close_image;
}

void BsPanel::createWidgets ()
{
  Global &global = Global::instance ();
  Window &mainWindow = Window::instance ();

  Panel *tooltipPanel = mainWindow.getPanel (kComponentID_TooltipPanel);
  assert(tooltipPanel);

  Mesh *mesh = global.getMesh ();
  assert (mesh);

  CharactersMap &charactersmap = mesh->getCharactersMapRef ();

  const Color c (1.0, 0.0, 0.0);
  const Point kTooltipPos (70, 12);

  TargetSlider *image_slider; 
  
  close_image = new Image(kComponentID_CloseTargetPanel,
                    searchPixmapFile ("ui/close_panel.png"),
                    Rect(0,0,32,32));  
  close_image->setListener(&imgListener);
  close_image->setTooltip(Tooltip("Close panel", kTooltipPos, c, tooltipPanel));  
  addWidget (close_image);
  
  for (CharactersMap::const_iterator charactersmap_it = charactersmap.begin ();
      charactersmap_it != charactersmap.end ();
      charactersmap_it++)
  {
    const string &character_name((*charactersmap_it).first);  

    string::size_type loc = character_name.find ("/", 0 );
    if (loc == string::npos)
     continue;
    else
    {
     string sub = character_name.substr (0, loc);

     if (sub == category)
     {
       // remove ".bs"
        string character_image (character_name);
        if(category == "ok") // user bs
        {
          character_image = "user_bs.png";            
        }
        else
        {
          character_image.replace (character_image.length () - kFilePrefixTarget.length (),
                                   kFilePrefixTarget.length (), kFilePrefixPNG);
        }

        image_slider = new TargetSlider (kComponentID_TargetPanel_Target,
                                         searchPixmapFile ("bsimg/" + character_image),
                                         character_name,
                                         Rect(0,0,32,42), 0.0, 1.0);

        image_slider->setListener(&imgSliderListener);
        image_slider->setTooltip(Tooltip(character_name, kTooltipPos, c, tooltipPanel));
        targetVector.push_back (image_slider);
        addWidget (image_slider);
      }
    }
  }
}
 
void BsPanel::resetTargetValues(const string currentTargetName)
{ 
  for (vector <TargetSlider*>::const_iterator targetvector_it = targetVector.begin ();
         targetvector_it != targetVector.end ();
         targetvector_it++)
  {         
    if((*targetvector_it)->getTargetName() != currentTargetName) 
    {                                 
      (*targetvector_it)->setSliderValue(0);            
    }
  }        
}
