/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This program is free software; you  can  redistribute  it  and/or
 *  modify  it  under  the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either  version  2  of
 *  the License, or (at your option) any later version.
 *
 *  This  program  is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the  implied  warranty  of
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foun-
 *  dation, Inc., 59 Temple Place, Suite 330, Boston,  MA  02111-1307
 *  USA
 *  
 *  File   : BodyPanel.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  App    : makehuman
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "BodyPanel.h"
#include "ImageListener.h"
#include "ComponentID.h"

#include <mhgui/Window.h>
#include <mhgui/Rect.h>
#include <mhgui/Tooltip.h>
//#include "Global.h"

using namespace std;
using namespace Animorph;

BodyPanel::BodyPanel ()
    : Panel (kComponentID_BodyPanel, Rect(0,16,96,384))
{
}

BodyPanel::~BodyPanel ()
{
  for_each (imageVector.begin (), imageVector.end (), deleteFunctor <Image*> ());
}

void BodyPanel::createWidgets ()
{
  Window &mainWindow = Window::instance ();

  Panel *tooltipPanel = mainWindow.getPanel(kComponentID_TooltipPanel);
  assert(tooltipPanel);

  const Color color_red (1.0, 0.0, 0.0);
  const Point kTooltipPos(70, 12);
  const float alpha = 0.8;
  Image *body;

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_TorsoParams,
                   searchPixmapFile ("ui/body_01.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Torso parameters", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_HeadParams,
                   searchPixmapFile ("ui/body_02.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Head parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_TorsoParams2,
                   searchPixmapFile ("ui/body_03.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Torso parameters 2", kTooltipPos, color_red, tooltipPanel));                   
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightShoulderParams,
                   searchPixmapFile ("ui/body_04.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Shoulder parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_NeckParams,
                   searchPixmapFile ("ui/body_05.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Neck parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftShoulderParams,
                   searchPixmapFile ("ui/body_06.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Shoulder parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightUpperArmParams,
                   searchPixmapFile ("ui/body_07.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Upper arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/body_08.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftUpperArmParams,
                   searchPixmapFile ("ui/body_09.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Upper arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightLowerArmParams,
                   searchPixmapFile ("ui/body_10.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Lower arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_AbdomenParams,
                   searchPixmapFile ("ui/body_11.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Abdomen parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftLowerArmParams,
                   searchPixmapFile ("ui/body_12.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Lower arm parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightHandParams,
                   searchPixmapFile ("ui/body_13.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Hand parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_PelvisParams,
                   searchPixmapFile ("ui/body_14.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Pelvis parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftHandParams,
                   searchPixmapFile ("ui/body_15.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Hand parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightUpperLegParams,
                   searchPixmapFile ("ui/body_16.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Upper leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/body_17.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftUpperLegParams,
                   searchPixmapFile ("ui/body_18.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Upper leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightLowerLegParams,
                   searchPixmapFile ("ui/body_19.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Lower leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/body_20.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftLowerLegParams,
                   searchPixmapFile ("ui/body_21.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Lower leg parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightFootParams2,
                   searchPixmapFile ("ui/body_22.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Foot parameters 2", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/body_23.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftFootParams2,
                   searchPixmapFile ("ui/body_24.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Foot parameters 2", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_RightFootParams,
                   searchPixmapFile ("ui/body_25.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Right Foot parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);
  
  // -------------------------------------------------------------------------
  body = new Image(kComponentID_Dummy,
                   searchPixmapFile ("ui/body_26.png"),
                   Rect (0,0,32,32));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

  // -------------------------------------------------------------------------
  body = new Image(kComponentID_ImageBody_LeftFootParams,
                   searchPixmapFile ("ui/body_27.png"),
                   Rect (0,0,32,32));
  body->setListener(&imgListener);
  body->setTooltip(Tooltip("Left Foot parameters", kTooltipPos, color_red, tooltipPanel));
  body->setAlpha (alpha);
  imageVector.push_back (body);
  addWidget(body);

}
