/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	"rfc2045.h"
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	"numlib/numlib.h"

/* $Id: rfc2045mkboundary.c,v 1.6 2000/08/05 21:56:07 mrsam Exp $ */

#if	HAS_GETHOSTNAME

#else

extern int gethostname(char *, size_t);
#endif

extern void rfc2045_enomem();

char *rfc2045_mk_boundary(struct rfc2045 *s, int fd)
{
char	hostnamebuf[256];
pid_t	mypid;
char	pidbuf[NUMBUFSIZE];
time_t	mytime;
char	timebuf[NUMBUFSIZE];
int	cnt=0;
char	cntbuf[60];
char	*p;
int	rc;

	hostnamebuf[sizeof(hostnamebuf)-1]=0;
	if (gethostname(hostnamebuf, sizeof(hostnamebuf)-1))
		hostnamebuf[0]=0;
	mypid=getpid();
	time(&mytime);
	str_pid_t(mypid, pidbuf);
	str_time_t(mytime, timebuf);
	for (;;)
	{
		sprintf(cntbuf, "%d", ++cnt);
		p=malloc(strlen(pidbuf)+strlen(timebuf)+
			strlen(cntbuf)+10);
		if (!p)
		{
			rfc2045_enomem();
			return (NULL);
		}

		sprintf(p, "=_%s-%s-%s", pidbuf, timebuf, cntbuf);
		if ((rc=rfc2045_try_boundary(s, fd, p)) == 0)
			break;
		free(p);
		if (rc < 0)
			return (NULL);
	}
	return (p);
}
