#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mdldapconfig.h"

mdldapconfig *get_ldap_config(char *configfile)
{
  FILE *fp;
  char *buf,*var,*val;
  mdldapconfig *cfg = NULL;

  buf = (char*)malloc(1025);
  var = (char*)malloc(1025);
  val = (char*)malloc(1025);

  fp = fopen(configfile,"r");
  if ( fp )
    {
      cfg = (mdldapconfig*)malloc(sizeof(mdldapconfig)+1);
      cfg->hostname = NULL;
      cfg->basedn = NULL;
      cfg->binddn = NULL;
      cfg->bindpw = NULL;
      cfg->filter = NULL;

      cfg->search_method = NULL;
      cfg->mail_attr = NULL;
      cfg->uid_attr = NULL;
      cfg->uidnumber_attr = NULL;
      cfg->gidnumber_attr = NULL;
      cfg->maildir_attr = NULL;
      cfg->homedirectory_attr = NULL;

      cfg->port = LDAP_DEFAULT_PORT;
      
      cfg->timeout = LDAP_DEFAULT_TIMEOUT;

      while ( fgets(buf,1024,fp) )
      {
	sscanf(buf,"%s %s",var,val);

	if ( !strcasecmp(var,"hostname") )
	  cfg->hostname = (char*)strdup(val);
	if ( !strcasecmp(var,"port") )
	  cfg->port = atoi(val);
	if ( !strcasecmp(var,"basedn") )
	  cfg->basedn = (char*)strdup(val);
	if ( !strcasecmp(var,"binddn") )
	  cfg->binddn = (char*)strdup(val);
	if ( !strcasecmp(var,"bindpw") )
	  cfg->bindpw = (char*)strdup(val);
	if ( !strcasecmp(var,"filter") )
	  cfg->filter = (char*)strdup(val);

	if ( !strcasecmp(var,"mail_attr") )
	  cfg->mail_attr = (char*)strdup(val);
	if ( !strcasecmp(var,"uid_attr") )
	  cfg->uid_attr = (char*)strdup(val);
	if ( !strcasecmp(var,"uidnumber_attr") )
	  cfg->uidnumber_attr = (char*)strdup(val);
	if ( !strcasecmp(var,"gidnumber_attr") )
	  cfg->gidnumber_attr = (char*)strdup(val);
	if ( !strcasecmp(var,"maildir_attr") )
	  cfg->maildir_attr = (char*)strdup(val);
	if ( !strcasecmp(var,"homedirectory_attr") )
	  cfg->homedirectory_attr = (char*)strdup(val);
	if ( !strcasecmp(var,"quota_attr") )
	  cfg->quota_attr = (char*)strdup(val);

	if ( !strcasecmp(var,"search_method") )
	  cfg->search_method = (char*)strdup(val);

	if ( !strcasecmp(var,"timeout") )
	  cfg->timeout = atoi(val);

	if ( !strcasecmp(var,"default_uidnumber") )
	  cfg->default_uidnumber = atoi(val);

	if ( !strcasecmp(var,"default_gidnumber") )
	  cfg->default_gidnumber = atoi(val);
      }

      fclose(fp);

      if ( !cfg->search_method )
	cfg->search_method = (char*)strdup(LDAP_DEFAULT_SEARCH_METHOD);

      if ( !cfg->mail_attr )
	cfg->mail_attr = (char*)strdup(LDAP_DEFAULT_MAIL_ATTR);
      if ( !cfg->uid_attr )
	cfg->uid_attr = (char*)strdup(LDAP_DEFAULT_UID_ATTR);
      if ( !cfg->uidnumber_attr )
	cfg->uidnumber_attr = (char*)strdup(LDAP_DEFAULT_UIDNUMBER_ATTR);
      if ( !cfg->gidnumber_attr )
	cfg->gidnumber_attr = (char*)strdup(LDAP_DEFAULT_GIDNUMBER_ATTR);
      if ( !cfg->maildir_attr )
	cfg->maildir_attr = (char*)strdup(LDAP_DEFAULT_MAILDIR_ATTR);
      if ( !cfg->homedirectory_attr )
	cfg->homedirectory_attr = (char*)strdup(LDAP_DEFAULT_HOMEDIRECTORY_ATTR);
      if ( !cfg->quota_attr )
	cfg->quota_attr = (char*)strdup(LDAP_DEFAULT_QUOTA_ATTR);
    }

  free(buf);
  free(var);
  free(val);

  return cfg;
}

void free_ldap_config(mdldapconfig **cfg)
{
  if ( cfg[0]->hostname )
    free(cfg[0]->hostname);
  if ( cfg[0]->basedn )
    free(cfg[0]->basedn);
  if ( cfg[0]->binddn )
    free(cfg[0]->binddn);
  if ( cfg[0]->bindpw )
    free(cfg[0]->bindpw);
  if ( cfg[0]->filter )
    free(cfg[0]->filter);

  free(cfg[0]->search_method);
  free(cfg[0]->mail_attr);
  free(cfg[0]->uid_attr);
  free(cfg[0]->uidnumber_attr);
  free(cfg[0]->gidnumber_attr);
  free(cfg[0]->maildir_attr);
  free(cfg[0]->homedirectory_attr);
  free(cfg[0]->quota_attr);

  free(*cfg);

  *cfg = NULL;
}
