#include	"maildir.h"
#include	"mio.h"
#include	"alarmtimer.h"
#include	"alarmsleep.h"
#include	"config.h"
#include	"xconfig.h"
#include	"funcs.h"
#include	"varlist.h"
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#include	<errno.h>
#include	<stdlib.h>
#include	"mytime.h"

#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	"../maildir/maildirquota.h"
#include	"../maildir/maildircreate.h"
#include	"../maildir/maildirmisc.h"

static const char rcsid[]="$Id: maildir.C,v 1.9 2000/09/19 16:34:14 mrsam Exp $";

Maildir::Maildir() : is_open(0)
{
}

Maildir::~Maildir()
{
	MaildirAbort();
}

////////////////////////////////////////////////////////////////////////////
//
//  Attempt to detect if this is a Maildir directory.
//
////////////////////////////////////////////////////////////////////////////

int Maildir::IsMaildir(const char *name)
{
Buffer	dirname;
Buffer	subdirname;
struct	stat stat_buf;

int	c;

	if (!name || !*name)	return (0);	// Nope, not a Maildir
	dirname=name;
	c=dirname.pop();
	if (c != SLASH_CHAR)	dirname.push(c);	// Strip trailing /
	subdirname=dirname;
	subdirname += "/tmp";
	subdirname += '\0';
	if ( stat( (const char *)subdirname, &stat_buf ) ||
		! S_ISDIR(stat_buf.st_mode) )	return (0);
	subdirname=dirname;
	subdirname += "/new";
	subdirname += '\0';
	if ( stat( (const char *)subdirname, &stat_buf ) ||
		! S_ISDIR(stat_buf.st_mode) )	return (0);
	subdirname=dirname;
	subdirname += "/cur";
	subdirname += '\0';
	if ( stat( (const char *)subdirname, &stat_buf ) ||
		! S_ISDIR(stat_buf.st_mode) )	return (0);
	return (1);	// If it looks like a duck, walks like a duck...
}

int	Maildir::MaildirOpen(const char *dir, Mio &file, off_t s)
{
Buffer	buf;

	MaildirAbort();

#if MAILDIRQUOTA

	{
	int	quotafd;
	const char *quotap;

	buf="MAILDIRQUOTA";	/* Reuse a convenient buffer */
	buf= *GetVar(buf);
	buf += '\0';

	quotap=buf;

	if (*quotap)
	{
		if (maildir_checkquota(dir, &quotafd, (const char *)buf, s, 1)
			&& errno != EAGAIN)
		{
			if (quotafd >= 0)	close(quotafd);
			merr << "maildrop: maildir over quota.\n";
			return (-1);
		}

		maildir_addquota(dir, quotafd, (const char *)buf, s, 1);
		if (quotafd >= 0)	close(quotafd);
	}
	}
#endif

AlarmTimer	abort_timer;
static long	counter=0;

	buf.set(counter++);
	buf += '\0';

	abort_timer.Set( 24 * 60 * 60 );
	while (!abort_timer.Expired())
	{
	char	*t, *n;

		if (maildir_try_create(dir, (const char *)buf, s, &t, &n) == 0)
		{
			tmpname= t;
			newname= n;
			tmpname += '\0';
			newname += '\0';
			free(t);
			free(n);

		int	f=maildir_safeopen( (const char *)tmpname,
				O_CREAT|O_EXCL|O_WRONLY, 0644);

			if (f >= 0)
			{
				file.fd(f);
				is_open=1;
				return (0);
			}
		}

	AlarmSleep	try_again(2);
	}

	merr << "maildrop: time out on maildir directory.\n";
	return (-1);
}

void	Maildir::MaildirSave()
{
	if (is_open && link( (const char *)tmpname, (const char *)newname) < 0)
		throw "link() failed.";
}

void	Maildir::MaildirAbort()
{
	if (is_open)	unlink( (const char *)tmpname );
}
