/*
** Copyright 1998 - 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"maildirquota.h"
#include	"maildircreate.h"
#include	"maildirmisc.h"
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<sys/types.h>
#include	<errno.h>
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif

#ifndef	BUFSIZE
#define	BUFSIZE	8192
#endif

static const char rcsid[]="$Id: deliverquota.c,v 1.8 2000/05/11 22:04:34 mrsam Exp $";

static long deliver(const char *dir, const char *q, long s)
{
char	*tname, *nname;
char	buf[BUFSIZ];
int	n;
long	ss=0;
int	fd;
int	rc;

	while ((rc=maildir_try_create(dir, 0, s, &tname, &nname)) != 0)
	{
		if (rc < 0)
		{
			perror("maildir_try_create");
			exit(75);
		}
		sleep(3);
	}

	if ((fd=maildir_safeopen(tname, O_WRONLY|O_CREAT|O_EXCL, 0644)) < 0)
	{
		perror(tname);
		exit(77);
	}

	while ((n=read(0, buf, sizeof(buf))) > 0)
	{
	char	*p=buf;

		ss += n;
		while (n)
		{
		int	l;

			if ((l=write(fd, p, n)) < 0)
			{
				close(fd);
				unlink(tname);
				perror(tname);
				exit(77);
			}
			p += l;
			n -= l;
		}
	}
	close(fd);
	if (n < 0)
	{
		unlink(tname);
		perror(tname);
		exit(77);
	}

	if (s != ss)
	{
	char	*qq;
	int	quotafd;

		if (s)	*strrchr(nname, ',')=0;	/* Zap incorrect size */
		qq=malloc(strlen(nname)+100);
		if (!qq)
		{
			unlink(tname);
			perror(tname);
			exit(77);
		}
		sprintf(qq, "%s,S=%ld", nname, ss-s);
		free(nname);
		nname=qq;

		if (*q)
		{
			if (maildir_checkquota(dir, &quotafd, q, ss-s, 1)
				&& errno != EAGAIN)
			{
				if (quotafd >= 0)	close(quotafd);
				unlink(tname);
				printf("Mail quota exceeded.\n");
				exit(77);
			}
			maildir_addquota(dir, quotafd, q, ss-s, 1);
			if (quotafd >= 0)	close(quotafd);
		}
	}

	if (rename(tname, nname))
	{
		unlink(tname);
		perror(tname);
		exit(77);
	}
	return (ss);
}

int main(int argc, char **argv)
{
const char *dir;
const char *q;
struct	stat	stat_buf;
int	quotafd;

	if (argc < 3)
	{
		fprintf(stderr, "Usage: %s maildir quota\n", argv[0]);
		exit(73);
	}

	dir=argv[1];
	q=argv[2];

	if (fstat(0, &stat_buf) == 0 && S_ISREG(stat_buf.st_mode) &&
		stat_buf.st_size > 0 && *q)
	{
		if (maildir_checkquota(dir, &quotafd, q, stat_buf.st_size, 1)
			&& errno != EAGAIN)
		{
			if (quotafd >= 0)	close(quotafd);
			printf("Mail quota exceeded.\n");
			exit(77);
		}
		maildir_addquota(dir, quotafd, q, stat_buf.st_size, 1);
		if (quotafd >= 0)       close(quotafd);
		deliver(dir, q, stat_buf.st_size);
		exit(0);
	}
	deliver(dir, q, 0);
	exit(0);
}
