Summary: LZMA utils
Name: lzma
Version: 4.27.1
Release: 1
License: GPL
Group: Applications/File
Source: http://tukaani.org/lzma/lzma-%{version}.tar.gz
URL: http://tukaani.org/lzma/
Buildroot: %{_tmppath}/lzma-%{version}-root

%description
LZMA provides very high compression ratio and fast decompression.
The core of the LZMA utils is Igor Pavlov's LZMA SDK containing
the actual LZMA encoder/decoder. LZMA utils add a few scripts
which provide gzip-like command line interface and a couple of
other LZMA related tools.

%prep
%setup -q

%build
make CFLAGS="-s -O3 -fomit-frame-pointer -march=i486 -mtune=i686"

%install
rm -rf ${RPM_BUILD_ROOT}
make prefix=${RPM_BUILD_ROOT}/usr mandir=${RPM_BUILD_ROOT}/usr/share/man \
		docdir=${RPM_BUILD_ROOT}/usr/share/doc install

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc /usr/share/doc/lzma-%{version}/*
/usr/bin
/usr/share/man

%changelog
* Mon Sep 12 2005 Lasse Collin <lasse.collin@tukaani.org>
- Added support to chown and chmod files on non-GNU/*/Linux systems
- Modified the 'bugs' section in lzmash(1) to include better security notices

* Wed Aug 24 2005 Lasse Collin <lasse.collin@tukaani.org>
- Upgraded to LZMA SDK 4.27
- Enable only hc3, hc4 and bt4 match finders
- Use LzmaDecode.c instead of LzmaStateDecode.c for lzmadec

* Thu Jul 28 2005 Lasse Collin <lasse.collin@tukaani.org>
- Upgraded to LZMA SDK 4.23

* Thu Jul 1 2005 Lasse Collin <lasse.collin@tukaani.org>
- Initial release, using LZMA SDK 4.22
