// -*- C++ -*-
/**
 * \file lfuns.h
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * Full author contact details are available in file CREDITS.
 *
 * To add a new function:
 * - add a new enum constant immediately before LFUN_LASTACTION
 * - add an appropriate line in LyXAction.C
 * - add a branch to a suitable ::doDispatch() method
 * - add correct test to the corresponding ::getStatus() method
 */

#ifndef LFUNS_H
#define LFUNS_H

#include <iosfwd>

/** These are all the lyx functions, the main mechanism
 * through which the frontends communicate with the core.
 *
 * They are managed in LyXAction.C and handled in various
 * ::dispatch() functions, starting with LyXFunc.C:dispatch(),
 * BufferView_pimpl::dispatch(), LCursor::dispatch() and
 * Inset*::doDispatch();
 */
enum kb_action {
	LFUN_UNKNOWN_ACTION = -1,
	// 0
	LFUN_NOACTION = 0,
	LFUN_PREFIX,
	LFUN_CENTER,
	LFUN_MENUNEW,
	LFUN_MENUWRITE,
	// 5
	LFUN_WRITEAS,
	LFUN_BUILDPROG,
	LFUN_TOCVIEW,
	LFUN_PREVIEW,
	LFUN_CLOSEBUFFER,
	// 10
	LFUN_QUIT,
	LFUN_AUTOSAVE,
	LFUN_UNDO,
	LFUN_REDO,
	LFUN_PASTE,
	// 15
	LFUN_PASTESELECTION,
	LFUN_CUT,
	LFUN_COPY,
	LFUN_GOTOERROR,
	LFUN_GOTONOTE,
	// 20
	LFUN_INSET_TOGGLE,
	LFUN_HYPHENATION,
	LFUN_LIGATURE_BREAK,
	LFUN_HFILL,
	LFUN_FREEFONT_APPLY,
	// 25
	LFUN_FREEFONT_UPDATE,
	LFUN_EMPH,
	LFUN_BOLD,
	LFUN_ROMAN,
	LFUN_NOUN,
	// 30
	LFUN_ITAL,
	LFUN_FRAK,
	LFUN_RIGHT,
	LFUN_LEFT,
	LFUN_UP,
	// 35
	LFUN_DOWN,
	LFUN_PRIOR,
	LFUN_NEXT,
	LFUN_HOME,
	LFUN_END,
	// 40
	LFUN_CELL_FORWARD,
	LFUN_CELL_BACKWARD,
	LFUN_WORDRIGHT,
	LFUN_WORDLEFT,
	LFUN_BEGINNINGBUF,
	// 45
	LFUN_ENDBUF,
	LFUN_RIGHTSEL,
	LFUN_LEFTSEL,
	LFUN_UPSEL,
	LFUN_DOWNSEL,
	// 50
	LFUN_PRIORSEL,
	LFUN_NEXTSEL,
	LFUN_HOMESEL,
	LFUN_ENDSEL,
	LFUN_WORDRIGHTSEL,
	// 55
	LFUN_WORDLEFTSEL,
	LFUN_WORDSEL,
	LFUN_BEGINNINGBUFSEL,
	LFUN_ENDBUFSEL,
	LFUN_SPACE_INSERT,  // JSpitzm 20030520
	// 60
	LFUN_SETMARK,
	LFUN_DELETE,
	LFUN_BACKSPACE,
	LFUN_BREAKLINE,
	LFUN_BREAKPARAGRAPH,
	// 65
	LFUN_BREAKPARAGRAPHKEEPLAYOUT,
	LFUN_QUOTE,
	LFUN_CIRCUMFLEX,
	LFUN_SUBSCRIPT,
	LFUN_SUPERSCRIPT,
	// 70
	LFUN_GRAVE,
	LFUN_ACUTE,
	LFUN_TILDE,
	LFUN_CEDILLA,
	LFUN_MACRON,
	// 75
	LFUN_UNDERBAR,
	LFUN_UNDERDOT,
	LFUN_CIRCLE,
	LFUN_TIE,
	LFUN_BREVE,
	// 80
	LFUN_CARON,
	LFUN_SPECIAL_CARON,
	LFUN_HUNG_UMLAUT,
	LFUN_UMLAUT,
	LFUN_DOT,
	// 85
	LFUN_OGONEK,
	LFUN_SELFINSERT,
	LFUN_GETBUFNAME,
	LFUN_GETXY,
	LFUN_SETXY,
	// 90
	LFUN_CHARATCURSOR,
	LFUN_LINEATCURSOR,
	LFUN_GETLAYOUT,
	LFUN_GETFONT,
	LFUN_GETNAME,
	// 95
	LFUN_NOTIFY,
	LFUN_GOTOFILEROW,
	LFUN_INSERT_NOTE,
	LFUN_ENVIRONMENT_INSERT,
	LFUN_KMAP_OFF,
	// 100
	LFUN_KMAP_PRIM,
	LFUN_KMAP_SEC,
	LFUN_KMAP_TOGGLE,
	LFUN_INSERT_MATH,
	LFUN_INSERT_MATRIX,
	// 105
	LFUN_MATH_LIMITS,
	LFUN_MATH_DELIM,                // Alejandro 180696
	LFUN_MATH_DISPLAY,              // Alejandro 180696
	LFUN_MATH_MODE,                 // Alejandro 040696
	LFUN_MATH_NUMBER,               // Alejandro 040696
	// 110
	LFUN_MATH_NONUMBER,             // Alejandro 180696
	LFUN_MATH_SIZE,                 // Alejandro 150896
	LFUN_MATH_MACRO,                // ale970510
	LFUN_MATH_EXTERN,               // Andre' 20010424
	LFUN_MATH_MUTATE,               // Andre' 20010523
	// 115
	LFUN_MATH_IMPORT_SELECTION,     // Andre' 20010704
	LFUN_MATH_SPACE,                // Andre' 20010725
	LFUN_DELETE_WORD_FORWARD,
	LFUN_DELETE_WORD_BACKWARD,
	LFUN_DELETE_LINE_FORWARD,
	// 120
	LFUN_MARK_OFF,
	LFUN_MARK_ON,
	LFUN_LAYOUT,
	LFUN_LAYOUT_PARAGRAPH,
	LFUN_DROP_LAYOUTS_CHOICE,
	// 125
	LFUN_CODE,
	LFUN_SANS,
	LFUN_DEFAULT,
	LFUN_UNDERLINE,
	LFUN_FONT_SIZE,
	// 130
	LFUN_FONT_STATE,
	LFUN_UPCASE_WORD,
	LFUN_LOWCASE_WORD,
	LFUN_CAPITALIZE_WORD,
	LFUN_INSERT_LABEL,
	// 135
	LFUN_DEPTH_MIN,
	LFUN_DEPTH_PLUS,
	LFUN_MENU_OPEN_BY_NAME,
	LFUN_CANCEL,
	LFUN_META_FAKE,
	// 140
	LFUN_EXEC_COMMAND,
	LFUN_FILE_INSERT,
	LFUN_FILE_INSERT_ASCII,         // CFO-G 1997-11-19
	LFUN_FILE_INSERT_ASCII_PARA,    // Levon 2001-02-14
	LFUN_FILE_NEW,
	// 145
	LFUN_FILE_OPEN,
	LFUN_UP_PARAGRAPH,              // Asger 1996-10-01
	LFUN_UP_PARAGRAPHSEL,           // Asger 1996-10-01
	LFUN_DOWN_PARAGRAPH,            // Asger 1996-10-01
	LFUN_DOWN_PARAGRAPHSEL,         // Asger 1996-10-01
	// 150
	LFUN_BREAKPARAGRAPH_SKIP,
	LFUN_BACKSPACE_SKIP,
	LFUN_DELETE_SKIP,
	LFUN_MENUNEWTMPLT,              // Asger 1997-02-02
	LFUN_MENURELOAD,                // Asger 1997-02-02
	// 155
	LFUN_RECONFIGURE,               // Asger 1997-02-14
	LFUN_INDEX_PRINT,               // Lgb 97-02-27
	LFUN_CELL_SPLIT,
	LFUN_CHILDOPEN,                 // Ale 970528
	LFUN_TOC_INSERT,                // Lgb 97-05-27
	// 160
	LFUN_FLOAT_LIST,                // Lgb 20010503
	LFUN_READ_ONLY_TOGGLE,          // Lgb 97-05-27
	LFUN_VC_REGISTER,               // Lgb 97-07-01
	LFUN_VC_CHECKIN,                // Lgb 97-07-01
	LFUN_VC_CHECKOUT,               // Lgb 97-07-01
	// 165
	LFUN_VC_REVERT,                 // Lgb 97-07-01
	LFUN_VC_UNDO,                   // Lgb 97-07-01
	LFUN_EXPORT,                    // Lgb 97-07-29
	LFUN_LABEL_GOTO,                // Ale 970806
	LFUN_LDOTS,                     // Asger 970929
	// 170
	LFUN_END_OF_SENTENCE,           // Asger 970929
	LFUN_TOGGLECURSORFOLLOW,        // ARRae 971202
	LFUN_RUNCHKTEX,                 // Asger 971030
	LFUN_HTMLURL,                   // CFO-G 971121
	LFUN_URL,                       // CFO-G 971121
	// 175
	LFUN_WORDFINDFORWARD,           // Etienne 980216
	LFUN_WORDFINDBACKWARD,          // Etienne 980220
	LFUN_APPENDIX,                  // ettrich 980505
	LFUN_IMPORT,                    // Asger 980724
	LFUN_MENU_SEPARATOR,            // Asger 990220
	// 180
	LFUN_SEQUENCE,                  // Andre' 991111
	LFUN_SAVEPREFERENCES,           // Lgb 991127
	LFUN_HELP_OPEN,                 // Jug 990627
	LFUN_DATE_INSERT,	        // jdblair 20000131
	LFUN_LANGUAGE,                  // Dekel 20000203
	// 185
	LFUN_INSET_ERT,	                // Jug 20000218
	LFUN_INSET_FOOTNOTE,            // Jug 20000307
	LFUN_PARAGRAPH_SPACING,         // Lgb 20000411
	LFUN_TABULAR_INSERT,            // Jug 20000412
	LFUN_LOFVIEW,                   // Dekel 20000519
	// 190
	LFUN_LOTVIEW,                   // Dekel 20000519
	LFUN_LOAVIEW,                   // Dekel 20000519
	LFUN_SET_COLOR,                 // SLior 20000611
	LFUN_INSET_MARGINAL,            // Lgb 20000626
	LFUN_INSET_FLOAT,               // Lgb 20000627
	// 195
	LFUN_INSET_WIDE_FLOAT,          // Lgb 20010531
	LFUN_INSET_CAPTION,             // Lgb 20000718
	LFUN_SWITCHBUFFER,
	LFUN_TABULAR_FEATURE,           // Jug 20000728
	LFUN_LAYOUT_TABULAR,            // Jug 20000731
	// 200
	LFUN_SCROLL_INSET,              // Jug 20000801
	LFUN_UPDATE,                    // Dekel 20000805
	LFUN_INDEX_INSERT,              // Angus 20000803
	LFUN_SCREEN_FONT_UPDATE,        // ARRae 20000813
	LFUN_GOTO_PARAGRAPH,            // Dekel 20000826
	// 205
	LFUN_REFERENCE_GOTO,            // Dekel 20010114
	LFUN_BOOKMARK_SAVE,             // Dekel 20010127
	LFUN_BOOKMARK_GOTO,             // Dekel 20010127
	LFUN_SELECT_FILE_SYNC,          // Levon 20010214
	LFUN_MESSAGE,                   // Lgb 20010408
	// 210
	LFUN_TRANSPOSE_CHARS,           // Lgb 20010425
	LFUN_ESCAPE,                    // Lgb 20010517
	LFUN_THESAURUS_ENTRY,           // Levon 20010720
	LFUN_TOOLTIPS_TOGGLE,           // Angus 8 Mar 2002
	LFUN_INSET_OPTARG,              // Martin 12 Aug 2002
	// 215
	LFUN_MOUSE_PRESS,               // Andr 9 Aug 2002
	LFUN_MOUSE_MOTION,              // Andr 9 Aug 2002
	LFUN_MOUSE_RELEASE,             // Andr 9 Aug 2002
	LFUN_MOUSE_DOUBLE,              // Andr 9 Aug 2002
	LFUN_MOUSE_TRIPLE,              // Andr 9 Aug 2002
	// 220
	LFUN_INSET_WRAP,                // Dekel 7 Apr 2002
	LFUN_TRACK_CHANGES,             // Levon 20021001 (cool date !)
	LFUN_MERGE_CHANGES,             // Levon 20021016
	LFUN_ACCEPT_CHANGE,             // Levon 20021016
	LFUN_REJECT_CHANGE,             // Levon 20021016
	// 225
	LFUN_ACCEPT_ALL_CHANGES,        // Levon 20021016
	LFUN_REJECT_ALL_CHANGES,        // Levon 20021016
	LFUN_INSERT_BIBITEM,            // Andr 14 Feb 2003
	LFUN_DIALOG_SHOW,
	LFUN_DIALOG_SHOW_NEW_INSET,
	// 230
	LFUN_DIALOG_SHOW_NEXT_INSET,
	LFUN_DIALOG_UPDATE,
	LFUN_DIALOG_HIDE,
	LFUN_DIALOG_DISCONNECT_INSET,
	LFUN_INSET_APPLY,
	// 235
	LFUN_INSET_INSERT,
	LFUN_INSET_MODIFY,
	LFUN_INSET_DIALOG_UPDATE,
	LFUN_INSET_SETTINGS,
	LFUN_PARAGRAPH_APPLY,
	// 240
	LFUN_PARAGRAPH_UPDATE,
	LFUN_EXTERNAL_EDIT,
	LFUN_INSERT_BRANCH,
	LFUN_INSET_DIALOG_SHOW,
	LFUN_INSERT_BOX,
	// 245
	LFUN_INSERT_LINE,
	LFUN_INSERT_PAGEBREAK,
	LFUN_REPEAT,
	LFUN_FINISHED_LEFT,
	LFUN_FINISHED_RIGHT,
	// 250
	LFUN_FINISHED_UP,
	LFUN_FINISHED_DOWN,
	LFUN_INSERT_CHARSTYLE,
	LFUN_WORD_FIND,
	LFUN_WORD_REPLACE,
	// 255
	LFUN_EXPORT_CUSTOM,
	LFUN_PRINT,
	LFUN_NEXT_INSET_TOGGLE,
	LFUN_ALL_INSETS_TOGGLE,
	LFUN_LANGUAGE_BUFFER,
	// 260
	LFUN_TEXTCLASS_APPLY,
	LFUN_TEXTCLASS_LOAD,
	LFUN_SAVE_AS_DEFAULT,
	LFUN_BUFFERPARAMS_APPLY,
	LFUN_LYXRC_APPLY,
	// 265
	LFUN_GRAPHICS_EDIT,
	LFUN_INSET_REFRESH,
	LFUN_NEXTBUFFER,
	LFUN_PREVIOUSBUFFER,
	LFUN_WORDS_COUNT,
	// 270
	LFUN_OUTPUT_CHANGES,             // jspitzm 20050121
	LFUN_BIBDB_ADD,
	LFUN_BIBDB_DEL,
	LFUN_INSERT_CITATION,

	LFUN_LASTACTION                  // end of the table
};

std::ostream & operator<<(std::ostream &, kb_action);

#endif // LFUNS_H
