#ifdef __GNUG__
#pragma implementation
#endif

#include "math_spaceinset.h"
#include "math_support.h"
#include "LColor.h"
#include "Painter.h"
#include "math_mathmlstream.h"


char const * latex_mathspace[] = {
	"!", ",", ":", ";", "quad", "qquad", "lyxnegspace"
};



MathSpaceInset::MathSpaceInset(int sp)
	: space_(sp)
{}


MathInset * MathSpaceInset::clone() const
{
	return new MathSpaceInset(*this);
}


void MathSpaceInset::metrics(MathMetricsInfo const &) const
{
	switch (space_) {
		case 0: width_ = 6; break;
		case 1: width_ = 6; break;
		case 2: width_ = 8; break;
		case 3: width_ = 10; break;
		case 4: width_ = 20; break;
		case 5: width_ = 40; break;
		case 6: width_ = -2; break;
		default: width_ = 6; break;
	}
	ascent_  = 4;
	descent_ = 0;
}


void MathSpaceInset::draw(Painter & pain, int x, int y) const
{

// Sadly, HP-UX CC can't handle that kind of initialization.
// XPoint p[4] = {{++x, y-3}, {x, y}, {x+width-2, y}, {x+width-2, y-3}};
	if (space_ == 6)
		return;

	int xp[4];
	int yp[4];

	xp[0] = ++x;             yp[0] = y - 3;
	xp[1] = x;	             yp[1] = y;
	xp[2] = x + width_ - 2;  yp[2] = y;
	xp[3] = x + width_ - 2;  yp[3] = y - 3;

	pain.lines(xp, yp, 4, space_ ? LColor::latex : LColor::math);
}


void MathSpaceInset::incSpace()
{
	space_ = (space_ + 1) % 6;
}


void MathSpaceInset::maplize(MapleStream & os) const
{
	os << ' ';
}


void MathSpaceInset::octavize(OctaveStream & os) const
{
	os << ' ';
}


void MathSpaceInset::normalize(NormalStream & os) const
{
	os << "[space " << space_ << "] ";
}


void MathSpaceInset::write(WriteStream & os) const
{
	if (space_ >= 0 && space_ < 7)
		os << '\\' << latex_mathspace[space_] << ' ';
}
