#ifdef __GNUG__
#pragma implementation
#endif

#include "math_macrotemplate.h"
#include "math_mathmlstream.h"
#include "Painter.h"
#include "debug.h"


MathMacroTemplate::MathMacroTemplate()
	: MathNestInset(2), numargs_(0), name_()
{}


MathMacroTemplate::MathMacroTemplate(string const & nm, int numargs)
	: MathNestInset(2), numargs_(numargs), name_(nm)
{
	if (numargs_ > 9)
		lyxerr << "MathMacroTemplate::MathMacroTemplate: wrong # of arguments: "
			<< numargs_ << std::endl;
}


MathInset * MathMacroTemplate::clone() const
{
	//lyxerr << "cloning MacroTemplate!\n";
	return new MathMacroTemplate(*this);
}


int MathMacroTemplate::numargs() const
{
	return numargs_;
}


void MathMacroTemplate::numargs(int numargs)
{
	numargs_ = numargs;
}


string const & MathMacroTemplate::name() const
{
	return name_;
}


void MathMacroTemplate::metrics(MathMetricsInfo const & mi) const
{
	xcell(0).metrics(mi);
	xcell(1).metrics(mi);
	width_   = xcell(0).width() + xcell(1).width() + 10;
	ascent_  = std::max(xcell(0).ascent(),  xcell(1).ascent())  + 2;
	descent_ = std::max(xcell(0).descent(), xcell(1).descent()) + 2;
}


void MathMacroTemplate::draw(Painter & pain, int x, int y) const
{
	int const w0 = xcell(0).width();
	int const w1 = xcell(1).width();
	xcell(0).draw(pain, x + 2, y + 1);
	pain.rectangle(x, y - ascent() + 1, w0 + 4, height(), LColor::blue);
	xcell(1).draw(pain, x + 8 + w0, y + 1);
	pain.rectangle(x + w0 + 6 , y - ascent() + 1, w1 + 4, height(), LColor::blue);
}


void MathMacroTemplate::write(WriteStream & os) const
{
	if (os.latex()) {
		os << "\n\\newcommand{\\" << name_.c_str() << '}';
		if (numargs_ > 0)
			os << '[' << numargs_ << ']';
		os << '{' << cell(0) << "}\n";
	} else {
		// writing .lyx
		os << "\n\\newcommand{\\" << name_.c_str() << '}';
		if (numargs_ > 0)
			os << '[' << numargs_ << ']';
		os << '{' << cell(0) << '}';
		// write special .tex export only if necessary
		if (!cell(1).empty())
			os << "\n{" << cell(1) << '}';
	}
}
