#include <config.h>

#ifdef __GNUG__
#pragma implementation
#endif

#include "math_funcinset.h"
#include "font.h"
#include "Painter.h"
#include "math_support.h"
#include "math_mathmlstream.h"
#include "math_streamstr.h"


extern LyXFont WhichFont(short type, int size);


MathFuncInset::MathFuncInset(string const & nm)
	: name_(nm)
{}


MathInset * MathFuncInset::clone() const
{
	return new MathFuncInset(*this);
}


string const & MathFuncInset::name() const
{
	return name_;
}


void MathFuncInset::setName(string const & n)
{
	name_ = n;
}


void MathFuncInset::metrics(MathMetricsInfo const & mi) const
{
	whichFont(font_, LM_TC_TEXTRM, mi);
	mathed_string_dim(font_, name_, ascent_, descent_, width_);
}


void MathFuncInset::draw(Painter & pain, int x, int y) const
{
	drawStr(pain, font_, x, y, name_);
}


bool MathFuncInset::match(MathInset * p) const
{
	MathFuncInset const * q = p->asFuncInset();
	return q && name_ == q->name_;
}


void MathFuncInset::maplize(MapleStream & os) const
{
	os << ' ' << name_;
}


void MathFuncInset::mathmlize(MathMLStream & os) const
{
	os << MTag("mi") << name_ << ETag("mi");
}


void MathFuncInset::octavize(OctaveStream & os) const
{
	os << ' ' << name_;
}


void MathFuncInset::normalize(NormalStream & os) const
{
	os << "[func " << name_ << ']';
}


void MathFuncInset::write(WriteStream & os) const
{
	os << "\\" << name_ << ' ';
}
