#! /bin/sh
#
# NOTE: This is NOT the same fdfix.sh as in ${top_srcdir}/forms
#       It is a modified version to suit use for gui-indep.
#

if [ ! -f $1 ]; then
    echo "Input file does not exist. Cannot continue"
    exit 1
fi

FDESIGN=fdesign

# names of the files generated by fdesign and by running the sed scripts
BASE=`basename $1 .fd`

if [ $1 = $BASE ]; then
    echo "Input file is not a .fd file. Cannot continue"
    exit 1
fi

CIN=$BASE.c
COUT=$BASE.C
HIN=$BASE.h
HOUT=$BASE.H

# Ascertain the class name from the name of the file
# eg form_my_new_dialog -> FormMyNewDialog
CLASSNAME=""
SECTION="start"
i=1
while :
do
    SECTION=`echo $BASE | cut -d_ -f$i`
    i=`expr $i + 1 `

    if [ $SECTION ]
    then
	FIRST=`echo $SECTION | cut -c1 | tr a-z A-Z`
	SECOND=`echo $SECTION | cut -c2-`
	CLASSNAME=$CLASSNAME$FIRST$SECOND
    else
	break
    fi
done

# Create .c and .h files
$FDESIGN -convert $1
FDFIXH=fdfixh.sed
FDFIXC=fdfixc.sed
FDFIXC_MOD=fdfixc_modified.sed

# Modify .h file for use by LyX
echo "// File modified by fdfix.sh for use by lyx (with xforms >= 0.88) and gettext" > $HOUT
sed -f $FDFIXH < $HIN >> $HOUT

# Patch the .h file if a patch exists
if [ -f "$HOUT.patch" ] ; then
    echo "Patching $HOUT with $HOUT.patch"
    patch -s $HOUT < $HOUT.patch
fi

# Modify the .c file sed-script
# (Quicker to modify the sed script than the .c file!)
sed -e "s/CLASSNAME/$CLASSNAME/" < $FDFIXC > $FDFIXC_MOD

# Modify .c file for use by LyX
echo "// File modified by fdfix.sh for use by lyx (with xforms >= 0.88) and gettext" > $COUT
echo "#include <config.h>" >> $COUT
echo "#include \"xforms_helpers.h\"" >> $COUT
echo "#include \"gettext.h\"" >> $COUT

grep bmtable $CIN > /dev/null
if [ $? -eq 0 ]; then
    echo "#include \"bmtable.h\"" >> $COUT
fi

echo >> $COUT

sed -f $FDFIXC_MOD < $CIN >> $COUT

# Patch the .C file if a patch exists
if [ -f "$COUT.patch" ] ; then
    echo "Patching $COUT with $COUT.patch"
    patch -s $COUT < $COUT.patch
fi

# Clean up, to leave .C and .h files
rm -f $CIN $HIN $FDFIXC_MOD
mv $HOUT $HIN
