/**
 * \file xforms/FormToc.C
 * Copyright 2000-2001 The LyX Team.
 * See the file COPYING.
 *
 * \author Angus Leeming, a.leeming@ic.ac.uk
 */

#include <config.h>

#ifdef __GNUG__
#pragma implementation
#endif

#include "FormToc.h"
#include "xformsBC.h"
#include "ControlToc.h"
#include "form_toc.h"
#include "helper_funcs.h" // getStringFromVector
#include "support/lstrings.h" // frontStrip, strip
#include "debug.h"
#include "gettext.h"

#include <vector>

using std::endl;


typedef FormCB<ControlToc, FormDB<FD_form_toc> > base_class;

FormToc::FormToc(ControlToc & c)
	: base_class(c, _("Table of Contents"))
{}


void FormToc::build()
{
	dialog_.reset(build_toc());

	string const choice =
		" " + getStringFromVector(controller().getTypes(), " | ") + " ";
	fl_addto_choice(dialog_->choice_toc_type, choice.c_str());

	// Manage the cancel/close button
	bc().setCancel(dialog_->button_close);
}


void FormToc::update()
{
	updateType();
	updateContents();
}


ButtonPolicy::SMInput FormToc::input(FL_OBJECT * ob, long)
{
	if (ob == dialog_->browser_toc) {
		unsigned int const choice = fl_get_browser(dialog_->browser_toc);

		if (choice - 1 < toclist_.size() && choice >= 1) {
			controller().Goto(toclist_[choice - 1].par->id());
		}
		return ButtonPolicy::SMI_VALID;
	}

	if (ob != dialog_->choice_toc_type) {
		updateType();
	}

	updateContents();

	return ButtonPolicy::SMI_VALID;
}


void FormToc::updateType()
{
	// Update the choice list from scratch
	fl_clear_choice(dialog_->choice_toc_type);
	string const choice = getStringFromVector(controller().getTypes(), "|");
	fl_addto_choice(dialog_->choice_toc_type, choice.c_str());

	// And select the correct one
	string const type = toc::getType(controller().params().getCmdName());

	fl_set_choice(dialog_->choice_toc_type, 1);
	for (int i = 1;
	     i <= fl_get_choice_maxitems(dialog_->choice_toc_type); ++i) {
		string const choice =
			fl_get_choice_item_text(dialog_->choice_toc_type, i);

		if (choice == type) {
			fl_set_choice(dialog_->choice_toc_type, i);
			break;
		}
	}
}


void FormToc::updateContents()
{
	char const * tmp = fl_get_choice_text(dialog_->choice_toc_type);

	if (!tmp) {
		fl_clear_browser(dialog_->browser_toc);
		fl_add_browser_line(dialog_->browser_toc,
				    _("*** No Lists ***"));
		return;
	}

	string const type = frontStrip(strip(tmp));

	Buffer::SingleList const contents = controller().getContents(type);

	if (contents.empty()) {
		fl_clear_browser(dialog_->browser_toc);
		fl_add_browser_line(dialog_->browser_toc,
				    _("*** No Lists ***"));
	}

	// Check if all elements are the same.
	if (toclist_ == contents) {
		return;
	}

	// List has changed. Update browser
	toclist_ = contents;

	unsigned int const topline =
		fl_get_browser_topline(dialog_->browser_toc);
	unsigned int const line = fl_get_browser(dialog_->browser_toc);

	fl_clear_browser(dialog_->browser_toc);

	Buffer::SingleList::const_iterator cit = toclist_.begin();
	Buffer::SingleList::const_iterator end = toclist_.end();

	for (; cit != end; ++cit) {
		string const line = string(4 * cit->depth, ' ') + cit->str;
		fl_add_browser_line(dialog_->browser_toc, line.c_str());
	}

	fl_set_browser_topline(dialog_->browser_toc, topline);
	fl_select_browser_line(dialog_->browser_toc, line);
}
