Summary: A WYSIWYM (What You See Is What You Mean) frontend to LaTeX
Name: lyx
Version: 1.2.3
Release: 1
Copyright: see COPYING file
Group: X11/Editors
Url: http://www.lyx.org/
Packager: Kayvan A. Sylvan <kayvan@sylvan.com>
Source: ftp://ftp.lyx.org/pub/lyx/stable/lyx-%{PACKAGE_VERSION}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Icon: lyx.xpm
Prefix: /usr
Requires: xforms >= 0.88, tetex-xdvi, tetex, tetex-latex
Obsoletes: tetex-lyx

%description
LyX is a modern approach to writing documents which breaks with the
obsolete "typewriter paradigm" of most other document preparation
systems.

It is designed for people who want professional quality output
with a minimum of time and effort, without becoming specialists in
typesetting.

The major innovation in LyX is WYSIWYM (What You See Is What You Mean).
That is, the author focuses on content, not on the details of formatting.
This allows for greater productivity, and leaves the final typesetting
to the backends (like LaTeX) that are specifically designed for the task.

With LyX, the author can concentrate on the contents of his writing,
and let the computer take care of the rest.

%prep
%setup

%build
unset LINGUAS || true
ISTRING=--with-included-string
if gcc -v 2>&1 | grep -e "version 3.\(1\|2\)"; then ISTRING=; fi
CXXFLAGS="$RPM_OPT_FLAGS" CFLAGS="$RPM_OPT_FLAGS" \
./configure --prefix=%{_prefix} --mandir=%{_mandir} \
	--bindir=%{_bindir} --datadir=%{_datadir} \
	--without-warnings $ISTRING
make

%install
unset LINGUAS || true
rm -rf ${RPM_BUILD_ROOT}
install -d -m 755 ${RPM_BUILD_ROOT}
make DESTDIR=${RPM_BUILD_ROOT} install
gzip -f9 ${RPM_BUILD_ROOT}%{_mandir}/man?/*

#
# Set up the lyx-specific class files where TeX can see them
#
TEXMF=%{_datadir}/texmf
mkdir -p ${RPM_BUILD_ROOT}${TEXMF}/tex/latex
mv ${RPM_BUILD_ROOT}%{_datadir}/lyx/tex \
      ${RPM_BUILD_ROOT}/${TEXMF}/tex/latex/lyx

#
# Miscellaneous files
#
cp -a lib/images/lyx.xpm ${RPM_BUILD_ROOT}%{_datadir}/lyx/images/
cp lib/reLyX/README README.reLyX

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
# Make TeX understand where LyX-specific packages are
texhash

# Before configuring lyx for the local system
# PATH needs to be imported 
if [ -f /etc/profile ]; then 
    . /etc/profile
fi 
#
# Now configure LyX
#
echo "Configuring LyX for your system..."
cd %{_datadir}/lyx
./configure --srcdir

# Fix reLyX perl program if the prefix is non-standard
if [ "%{_prefix}" != "/usr" ]
then
    perl -pi -e "s!/usr/share/lyx!%{_datadir}/lyx!" \
        %{_bindir}/reLyX
fi

%postun
# Fix the TeX file hash
#
texhash

%files
%defattr(-,root,root)
%doc ABOUT-NLS ANNOUNCE COPYING 
%doc README UPGRADING ChangeLog NEWS
%doc lib/CREDITS README.reLyX
%{_bindir}/*
%{_mandir}/man?/*
%{_datadir}/locale/*/LC_MESSAGES/*
%{_datadir}/%{name}
%{_datadir}/texmf/tex/latex/%{name}
