Summary: A WYSYWIG frontend to LaTeX
Name: lyx
Version: 1.1.6fix1
Release: 1
Copyright: see COPYING file
Group: X11/Editors
Url: http://www.lyx.org/
Packager: Kayvan A. Sylvan <kayvan@sylvan.com>
Source: ftp://ftp.lyx.org/pub/lyx/stable/lyx-%{PACKAGE_VERSION}.tar.gz
BuildRoot: /var/tmp/rpm/lyx-root
Icon: lyx.xpm
Prefix: /usr
Requires: xforms >= 0.88, tetex-xdvi, tetex, tetex-latex

%description
LyX is a modern approach of writing documents with a computer
which breaks with the tradition of the obsolete typewriter
concept.  It is designed for people who want a professional
output with a minimum of time and effort, without becoming specia-
lists in typesetting.  Compared to common word processors LyX
will increase the productivity a lot, since most of the type-
setting will be done by the computer, not the author.  With LyX
the author can concentrate on the contents of his writing,
since the computer will take care of the look.

%package -n tetex-lyx
Summary: Files for LyX packaged for tetex
Requires: lyx
Group: Applications/Publishing

%description -n tetex-lyx
This package contains the LaTeX files for LyX installed in the normal
place that the Redhat tetex package is installed and would see it.

%prep
%setup

%build
unset LINGUAS || true
CXXFLAGS="$RPM_OPT_FLAGS" CFLAGS="$RPM_OPT_FLAGS" \
./configure --prefix=/usr --without-warnings --with-included-string
# The following check is to ensure that lyx RPMs generated on RH 6.X machines
# with gcc-2.95 still run against older Redhat OS/compiler combinations.
# It will eventually be ripped out.
if [ -r /usr/lib/libstdc++-libc6.1-1.so.2 ]
then
	make CXX=gcc LYX_LIBS='/usr/lib/libstdc++-libc6.1-1.so.2 -lforms -lXpm'
else
	make
fi


%install
unset LINGUAS || true
rm -rf ${RPM_BUILD_ROOT}
install -d -m 755 ${RPM_BUILD_ROOT}
make prefix=${RPM_BUILD_ROOT}/usr install
gzip -f9 ${RPM_BUILD_ROOT}/usr/man/man?/*

#
# Set up the lyx-specific class files where TeX can see then
#
TEXMF=/usr/share/texmf
mkdir -p ${RPM_BUILD_ROOT}${TEXMF}/tex/latex
cp -r ${RPM_BUILD_ROOT}/usr/share/lyx/tex \
      ${RPM_BUILD_ROOT}${TEXMF}/tex/latex/lyx

#
# Miscellaneous files
#
cp -a lib/images/lyx.xpm ${RPM_BUILD_ROOT}/usr/share/lyx/images/
cp lib/reLyX/README README.reLyX

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
# Before configuring lyx for the local system
# PATH needs to be imported 
if [ -f /etc/profile ]; then 
    . /etc/profile
fi 
#
# Now configure LyX
#
echo "Configuring LyX for your system..."
cd $RPM_INSTALL_PREFIX/share/lyx
./configure --srcdir

%post -n tetex-lyx
# Fix the TeX file hash
#
texhash

# Before configuring lyx for the local system
# PATH needs to be imported 
if [ -f /etc/profile ]; then 
. /etc/profile
fi 
#
# Now configure LyX
#
echo "Re-configuring LyX for your system..."
cd $RPM_INSTALL_PREFIX/share/lyx
./configure --srcdir

%postun -n tetex-lyx
# Fix the TeX file hash
#
texhash

# Before configuring lyx for the local system
# PATH needs to be imported 
if [ -f /etc/profile ]; then 
. /etc/profile
fi 
#
# Now configure LyX
#
echo "Reconfiguring LyX for your system..."
cd $RPM_INSTALL_PREFIX/share/lyx
./configure --srcdir

%files
%attr(-,root,root) %doc ABOUT-NLS ANNOUNCE OLD-CHANGES COPYING 
%attr(-,root,root) %doc README UPGRADING ChangeLog NEWS
%attr(-,root,root) %doc lib/CREDITS README.reLyX

%attr(-,root,root) /usr/bin/*
%attr(-,root,root) /usr/man/*
%attr(-,root,root) /usr/share/locale/*/LC_MESSAGES/*
%attr(-,root,root) /usr/share/lyx

%files -n tetex-lyx
%attr(-,root,root) /usr/share/texmf/tex/latex/lyx
