
#include <config.h>

#include <stdlib.h>

#ifdef __GNUG__
#pragma implementation
#endif

#include FORMS_H_LOCATION  
#include "insetbib.h"
#include "combox.h"
#include "buffer.h"
#include "error.h"
#include "lyx_gui_misc.h"
#include "BufferView.h"
#include "gettext.h"
#include "bibforms.h"
#include "lyxtext.h"
#include "filetools.h"

extern BufferView *current_view;

FD_citation_form *citation_form=0;
FD_bibitem_form *bibitem_form=0;
static Combox *bibcombox = NULL;

extern void UpdateInset(Inset* inset, bool mark_dirty = true);
void BibitemUpdate(Combox *);
void bibitem_cb(FL_OBJECT *, long);
FD_citation_form * create_form_citation_form(void);
FD_bibitem_form * create_form_bibitem_form(void);


void bibitem_cb(FL_OBJECT *, long data)
{
	switch (data) {
//       case 0: fl_hide_form(citation_form->citation_form);
//               break;
//       case 1: 
	case 1: // OK, citation
        {
//               InsetCommand *inset = (InsetCommand*)citation_form->vdata;
//               inset->setContents(bibcombox->getline());
//               inset->setOptions(fl_get_input(citation_form->label));
//               fl_hide_form(citation_form->citation_form);
//               UpdateInset(inset);
//               break;
		if(!current_view->currentBuffer()->isReadonly()) {
			InsetCommand *inset = (InsetCommand*)citation_form->vdata;
			inset->setContents(bibcombox->getline());
			inset->setOptions(fl_get_input(citation_form->label));
			fl_hide_form(citation_form->citation_form);
			// shouldn't mark the buffer dirty unless something
			// was actually altered
			UpdateInset(inset);
			break;
		}
		// fall through to Cancel on RO-mode
        }       
//       case 2:  fl_hide_form(bibitem_form->bibitem_form);
	case 0: fl_hide_form(citation_form->citation_form);
                break;
//       case 3:

	case 3: // OK, bibitem
        {
//               InsetCommand *inset = (InsetCommand *)bibitem_form->vdata;
//               inset->setContents(fl_get_input(bibitem_form->key));
//               inset->setOptions(fl_get_input(bibitem_form->label));
//               fl_hide_form(bibitem_form->bibitem_form);
//              // Does look like a hack? It is! (but will change at 0.13)
//               current_view->currentBuffer()->text->RedoParagraph();
//               current_view->currentBuffer()->update(1);
//               break;
		if(!current_view->currentBuffer()->isReadonly()) {
			InsetCommand *inset = (InsetCommand *)bibitem_form->vdata;
			inset->setContents(fl_get_input(bibitem_form->key));
			inset->setOptions(fl_get_input(bibitem_form->label));
			fl_hide_form(bibitem_form->bibitem_form);
			// Does look like a hack? It is! (but will change at 0.13)
			current_view->currentBuffer()->text->RedoParagraph();
			current_view->currentBuffer()->update(1);
			break;
		} // fall through to Cancel on RO-mode
        }
	case 2: // Cancel, bibitem
		fl_hide_form(bibitem_form->bibitem_form); // Cancel, bibitem
		break;
        }
}

FD_citation_form *create_form_citation_form(void)
{
	FL_OBJECT *obj;
	FD_citation_form *fdui = (FD_citation_form *) fl_calloc(1, sizeof(*fdui));

	fdui->citation_form = fl_bgn_form(FL_NO_BOX, 220, 130);
	obj = fl_add_box(FL_UP_BOX,0,0,220,130,"");
	fdui->key = obj = fl_add_text(FL_NORMAL_TEXT,20,10,60,30,_("Key:"));
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	  fl_set_object_lalign(obj,FL_ALIGN_RIGHT);

	bibcombox = new Combox(FL_COMBOX_INPUT);
	bibcombox->add(80,10,130,30, 120);

	obj = fl_add_button(FL_RETURN_BUTTON,20,90,90,30,_("OK"));
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	  fl_set_object_callback(obj,bibitem_cb,1);
	obj = fl_add_button(FL_NORMAL_BUTTON,120,90,90,30,idex(_("Cancel|^[")));
	  fl_set_button_shortcut(obj,scex(_("Cancel|^[")),1);
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	  fl_set_object_callback(obj,bibitem_cb,0);
	fdui->label = obj = fl_add_input(FL_NORMAL_INPUT,80,50,130,30,idex(_("Remark:|#R")));
	  fl_set_input_shortcut(obj,scex(_("Remark:|#R")),1);
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	fl_end_form();

	//fdui->citation_form->fdui = fdui;

	return fdui;
}
/*---------------------------------------*/

FD_bibitem_form *create_form_bibitem_form(void)
{
	FL_OBJECT *obj;
	FD_bibitem_form *fdui = (FD_bibitem_form *) fl_calloc(1, sizeof(*fdui));

	fdui->bibitem_form = fl_bgn_form(FL_NO_BOX, 220, 130);
	obj = fl_add_box(FL_UP_BOX,0,0,220,130,"");
	fdui->key = obj = fl_add_input(FL_NORMAL_INPUT,80,10,130,30,idex(_("Key:|#K")));
	  fl_set_input_shortcut(obj,scex(_("Key:|#K")),1);
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	obj = fl_add_button(FL_RETURN_BUTTON,20,90,90,30,_("OK"));
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	  fl_set_object_callback(obj,bibitem_cb,3);
	obj = fl_add_button(FL_NORMAL_BUTTON,120,90,90,30,idex(_("Cancel|^[")));
	  fl_set_button_shortcut(obj,scex(_("Cancel|^[")),1);
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	  fl_set_object_callback(obj,bibitem_cb,2);
	fdui->label = obj = fl_add_input(FL_NORMAL_INPUT,80,50,130,30,idex(_("Label:|#L")));
	  fl_set_input_shortcut(obj,scex(_("Label:|#L")),1);
	  fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	fl_end_form();

	//fdui->bibitem_form->fdui = fdui;

	return fdui;
}
/*---------------------------------------*/


InsetCitation::InsetCitation(LString const & key, LString const & note):
	InsetCommand("cite", key, note)
{

}
InsetCitation::~InsetCitation()
{
	if(citation_form && citation_form->citation_form
	   && citation_form->citation_form->visible
	   && citation_form->vdata == this)
		fl_hide_form(citation_form->citation_form);
}


void InsetCitation::Edit(int, int)
{
	if(current_view->currentBuffer()->isReadonly())
		WarnReadonly();

	if (!citation_form) {
		citation_form = create_form_citation_form();
		fl_set_form_atclose(citation_form->citation_form, 
				    CancelCloseBoxCB, NULL);
	}
	citation_form->vdata = this;

	BibitemUpdate(bibcombox);
	if (!bibcombox->select_text(getContents().c_str()))
		bibcombox->addline(getContents().c_str());
	    
	fl_set_input(citation_form->label, getOptions().c_str());
	if (citation_form->citation_form->visible) {
		fl_raise_form(citation_form->citation_form);
	} else {
		fl_show_form(citation_form->citation_form,FL_PLACE_MOUSE, FL_FULLBORDER,
			     _("Citation"));
	}   
}


LString InsetCitation::getScreenLabel() const
{
	LString temp('[');

	if (contents.empty()) {
		temp+="???";
	} else {
		temp+=contents;
	}

	if (!options.empty()) {
		temp+=","+options;
	}

	return temp+']';
}


InsetBibKey::InsetBibKey(LString const & key, LString const & label):
	InsetCommand("bibitem", key, label)
{
	counter = 1;
	if (key.empty())
		contents = ' ';
}


InsetBibKey::InsetBibKey(InsetBibKey const *b):
	InsetCommand("bibitem", b->contents, b->options)
{
	counter = b->counter;
}

InsetBibKey::~InsetBibKey()
{
	if(bibitem_form && bibitem_form->bibitem_form
	   && bibitem_form->bibitem_form->visible)
				fl_hide_form(bibitem_form->bibitem_form);
}

void InsetBibKey::setCounter(int c) 
{ 
	counter = c; 
    
	if (contents.empty())
		contents += counter;
}


// I'm sorry but this is still necessary because \bibitem is used also
// as a LyX 2.x command, and lyxlex is not enough smart to understand
// real LaTeX commands. Yes, that could be fixed, but would be a waste 
// of time cause LyX3 won't use lyxlex anyway.  (ale)
void InsetBibKey::Write(FILE *file)
{
	LString s;
	if (!options.empty()) {
		s += '[';
		s += options + ']';
	}
	s += '{';
	s += contents + '}';
	fprintf(file,"\\bibitem %s\n", s.c_str());
}


LString InsetBibKey::getScreenLabel() const
{
	if (!options.empty())
		return options;
    
	LString s;
	return s + counter;
}


/*
  The value in "Key:" isn't allways set right after a few bibkey insets have
  been added/removed.  Perhaps the wrong object is deleted/used somewhere upwards?
  (Joacim 1998-03-04)
*/
void InsetBibKey::Edit(int, int)
{
	if(current_view->currentBuffer()->isReadonly())
		WarnReadonly();
	
	if (!bibitem_form) {
		bibitem_form = create_form_bibitem_form();
		fl_set_form_atclose(bibitem_form->bibitem_form, 
				    CancelCloseBoxCB, NULL);
	}
	bibitem_form->vdata = this;
	// InsetBibtex uses the same form, with different labels
	fl_set_object_label(bibitem_form->key, idex(_("Key:|#K")));
	fl_set_button_shortcut(bibitem_form->key,scex(_("Key:|#K")),1);
	fl_set_object_label(bibitem_form->label, idex(_("Label:|#L")));
	fl_set_button_shortcut(bibitem_form->label,scex(_("Label:|#L")),1);
	fl_set_input(bibitem_form->key, getContents().c_str());
	fl_set_input(bibitem_form->label, getOptions().c_str());
	if (bibitem_form->bibitem_form->visible) {
		fl_raise_form(bibitem_form->bibitem_form);
	} else {
		fl_show_form(bibitem_form->bibitem_form,FL_PLACE_MOUSE,
			     FL_FULLBORDER,
			     _("Bibliography item"));
	}   
}



InsetBibtex::InsetBibtex(LString const & dbase, LString const & style,
			 Buffer *o)
	:InsetCommand("BibTeX", dbase, style), owner(o)
{
}


InsetBibtex::~InsetBibtex()
{
}


LString InsetBibtex::getScreenLabel() const
{
	return _("BibTeX Generated References");
}


int InsetBibtex::Latex(FILE *file, signed char /*fragile*/)
{
	LString bib;
	signed char dummy = 0;
	int result = Latex(bib, dummy);
	fprintf(file, "%s", bib.c_str());
	return result;
}


int InsetBibtex::Latex(LString &file, signed char /*fragile*/)
{
	// If we generate in a temp dir, we might need to give an
	// absolute path there. This is a bit complicated since we can
	// have a comma-separated list of bibliographies
	LString db_in, adb, db_out;
	db_in = getContents();
	db_in.split(adb, ',');
	while(!adb.empty()) {
		if (!owner->niceFile &&
		    IsFileReadable(MakeAbsPath(adb,owner->filepath)+".bib")) 
			adb = MakeAbsPath(adb,owner->filepath);
		db_out += adb;
		db_out += ',';
		db_in.split(adb,',');
	}
	db_out.strip(',');

	// Idem, but simpler
	LString style;
	if (!owner->niceFile 
	    && IsFileReadable(MakeAbsPath(getOptions(), owner->filepath)
			      + ".bst")) 
		style = MakeAbsPath(getOptions(), owner->filepath);
	else
		style = getOptions();

	file += "\\bibliographystyle{";
	file += style;
	file += "}\n";
	file += "\\bibliography{";
	file += db_out;
	file += "}\n";
	return 2;
}


// BibTeX should have its own dialog. This is provisional.
void InsetBibtex::Edit(int, int)
{
	if (!bibitem_form) {
		bibitem_form = create_form_bibitem_form();
		fl_set_form_atclose(bibitem_form->bibitem_form, 
				    CancelCloseBoxCB, NULL);
	}

	bibitem_form->vdata = this;
	fl_set_object_label(bibitem_form->key, _("Database:"));
	fl_set_object_label(bibitem_form->label, _("Style:  "));
	fl_set_input(bibitem_form->key, getContents().c_str());
	fl_set_input(bibitem_form->label, getOptions().c_str());
	if (bibitem_form->bibitem_form->visible) {
		fl_raise_form(bibitem_form->bibitem_form);
	} else {
		fl_show_form(bibitem_form->bibitem_form,FL_PLACE_MOUSE, FL_FULLBORDER,
			     _("BibTeX"));
	}   
}


bool InsetBibtex::addDatabase(LString const &db)
{
	if (!contents.contains(db.c_str())) {
		if (!contents.empty()) 
			contents += ',';
		contents += db;
		return true;
	}
	return false;
}


bool InsetBibtex::delDatabase(LString const &db)
{
	if (contents.contains(db.c_str())) {
		LString bd = db;
		int n = contents.tokenPos(',', bd);
		if (n > 0) {
			LString tmp(',');
			tmp += bd;
			contents.subst(tmp.c_str(), ",");
		} else if (n==0)
			contents.split(bd, ',');
		else 
			return false;
	}
	return true;
}


// This function should be in LyXView when multiframe works ale970302
void BibitemUpdate(Combox* combox)
{
	combox->clear();
    
	if (!current_view->available())
		return;

	LyXParagraph *par = current_view->currentBuffer()->paragraph;    
	while (par) {
		if (par->bibkey) 
			combox->addto(par->bibkey->getContents().c_str());
	
		par = par->next;
	}
}


// ale070405 This function maybe shouldn't be here. We'll fix this at 0.13.
int bibitemMaxWidth(const class LyXFont &font)
{
	int w = 0;
	// Does look like a hack? It is! (but will change at 0.13)
	LyXParagraph *par = current_view->currentBuffer()->paragraph;
    
	while (par) {
		if (par->bibkey) {
			int wx = par->bibkey->Width(font);
			if (wx>w) w = wx;
		}
		par = par->next;
	}
	return w;
}


// ale070405 
LString bibitemWidthest()
{
	int w = 0;
	// Does look like a hack? It is! (but will change at 0.13)
	LyXParagraph *par = current_view->currentBuffer()->paragraph;
	InsetBibKey *bkey=0;
	LyXFont font;
      
	while (par) {
		if (par->bibkey) {
			int wx = par->bibkey->Width(font);
			if (wx>w) {
				w = wx;
				bkey = par->bibkey;
			}
		}
		par = par->next;
	}
    
	if (bkey)
		return bkey->getOptions();
    
	return LString();
}
