// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, The Document Processor
*        
*           Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*
*======================================================*/

#ifndef _FILE_INFO_H
#define _FILE_INFO_H

#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "LString.h"

/** Use objects of this class to get information about files. */
class FileInfo {
public:
	///
	FileInfo();

	/** Get information about file.
	If link is true, the information is about the link itself, not
	the file that is obtained by tracing the links. */
	FileInfo(LString const &path, bool link = false);

	///
	FileInfo(int fildes);

	///
	~FileInfo();

	///
	FileInfo& newFile(LString const &path, bool link = false);

	///
        FileInfo& newFile(int fildes);
	
	/// returns a character describing file type (ls -F)
	char const *typeIndicator();

	///
	mode_t getMode();

	///
	long getBlockSize();
	
	/// constructs standard mode string (ls style)
	void modeString(char *szString);
	
	/// returns a letter describing a file type (ls style)
	char typeLetter();
	
	/// builds 'rwx' string describing file access rights
	void flagRWX(unsigned short i, char *szString);
	
	/// updates mode string to match suid/sgid/sticky bits
	void setSticky(char *szString);

	///
	time_t& getModificationTime();

	///
	time_t& getAccessTime();

	///
	time_t& getStatusChangeTime();

	///
	off_t getSize();

	///
	nlink_t getNumberOfLinks();

	///
	uid_t getUid();
	///
	gid_t getGid();
	///
	bool isOK();
	///
	enum perm_test {
		rperm = R_OK, // test for read permission
		wperm = W_OK, // test for write permission
		xperm = X_OK, // test for execute (search) permission
		eperm = F_OK  // test for existence of file
	};
	///
	bool access(int p);
	///
	bool writable() { return access(FileInfo::wperm); }
	///
	bool readable() { return access(FileInfo::rperm); }
	///
	bool executable() { return access(FileInfo::xperm); }
	///
	bool exist() { return access(FileInfo::eperm); }
	///
	bool isLink();
	///
	bool isRegular();
	///
	bool isDir();
	///
	bool isChar();
	///
	bool isBlock();
	///
	bool isFifo();
	///
	bool isSocket();
	///
	int getError();
	///
	enum {
		///
		NoErr = -1
	};
private:
	///
	void init();
	///
	void dostat(bool);
	///
	struct stat *buf;
	///
	int status;
	///
	int err;
	///
	LString fname;
};

#endif

