#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include "func.h"
#include <stdlib.h>
#include <string.h>

typedef unsigned long int uint32;

int split_files( char *filename , uint32 _s)
{
	struct stat *buf;

	FILE	*fp_orig = NULL,
			*fp_split = NULL;

	uint32	orig_pos, orig_size,
			split_pos, split_size,
			bytes_left;

	int		filenr,
			pieces,
			bytes_read,
			allow_read;

	char	*c_byte = NULL,
			*split_fname = NULL,
			*orig_fname = NULL,
			split_sfname[31];


	orig_pos = orig_size = 0;
	split_pos = split_size = 0;
	filenr = 1;

	buf = (struct stat*)malloc(sizeof(struct stat));
	c_byte = (char*)malloc(sizeof(char)*4096);
	split_fname = (char*)malloc(sizeof(char) * 200);
	orig_fname = (char*)malloc(sizeof(char) * 200);

	strcpy(orig_fname,filename);

	stat(orig_fname,buf);
	orig_size = buf->st_size;

	if (_s >= orig_size)
	{
		printf("Splitted filesize is same as size of the filename!\n"
			   "Try using cp(1) instead...\n");
		exit(0);
	}

	fp_orig = fopen(orig_fname,"r");

	if (fp_orig == NULL)
	{
		perror("error opening input file");
		return -1;
	}

	split_size = _s;

	bytes_left = orig_size;

	orig_fname = strip_path( orig_fname );

	pieces = orig_size / split_size;
	if ((orig_size % split_size) > 0) pieces++;

	if (pieces > 999)
	{
		printf("This operation would end up with more than 999 files.\n" \
			   "Try increasing the split size to reduce this value.?\n");
		exit(0);
	}

	printf("Splitting %s into %d pieces.\n",orig_fname, pieces);

	while (orig_pos < orig_size)
	{
		if (filenr < 10)
			sprintf(split_fname,"%s.00%d",orig_fname,filenr);
		else if (filenr < 100)
			sprintf(split_fname,"%s.0%d",orig_fname,filenr);
		else if (filenr < 1000)
			sprintf(split_fname,"%s.%d",orig_fname,filenr);

		fp_split = fopen(split_fname,"w");

		if (fp_split == NULL)
		{
			perror("error opening output file");
			return -1;
		}

		split_pos = 0;

		shorten_path(split_fname, split_sfname);
		printf("%s\t\t\t%lu bytes\n",split_sfname,split_size);
		
		bytes_read = 0;
		allow_read = 4096;

		while (split_pos < split_size)
		{
			if ((split_pos+allow_read)-1 - split_size < 4096)
			{
				allow_read = split_size % 4096;
			}
			bytes_read = fread(c_byte, 1, allow_read, fp_orig);
			fwrite(c_byte, 1, bytes_read, fp_split);

			orig_pos+=bytes_read;
			split_pos+=bytes_read;
#ifndef NO_DEBUG
			printf("split pos:\t%lu\n",split_pos);
			printf("split size:\t%lu\n",split_size);
			printf("allow_read:\t%d\n",allow_read);
			sleep(1);
#endif
		}

		bytes_left -= split_size;

		if (bytes_left < split_size)
			split_size = bytes_left;

		filenr++;

		fclose(fp_split);
	}

	fclose(fp_orig);

	free( buf );
	free( c_byte );
	free( split_fname );
	free( orig_fname );


	return 0;
}

