.\" luac.man,v 1.17 1999/07/07 16:02:07 lhf Exp
.TH LUAC 1 "1999/07/07 16:02:07"
.SH NAME
luac \- Lua compiler
.SH SYNOPSIS
.B luac
[
.I options
] [
.I filenames
]
.SH DESCRIPTION
.B luac
is the Lua compiler.
It translates programs written in the Lua programming language
into binary files that can be loaded and executed with
.B lua_dofile
in C or with
.B dofile
in Lua.
.LP
The main advantages of pre-compiling chunks are:
faster loading,
protecting source code from user changes,
and
off-line syntax error detection.
The binary files created by
.B luac
are portable to all architectures.
.LP
Pre-compiling does not imply faster execution
because in Lua chunks are always compiled into bytecodes before being executed.
.B luac
simply allows those bytecodes to be saved in a file for later execution.
.LP
.B luac
produces a single output file containing the bytecodes
for all source files given.
By default,
the output file is named
.BR luac.out ,
but you can change this with the
.B \-o
option.
.LP
You can use
.B "\-"
to indicate
.I stdin
as a source file.
.LP
.B luac
can also load and list binary files with the
.B \-u
option.
.LP
Binary files produced by differents runs of
.B luac
(even in different machines)
can be combined into one large file,
using 
.BR cat (1).
The result is still a valid binary file
and can be loaded with a single call to
.B lua_dofile
or 
.BR dofile .
.LP
The internal format of the binary files produced by
.B luac
may change when a new version of Lua is released.
We try to maintain compatibility even for binary files,
but sometimes it cannot be done.
So,
save the source files of all Lua programs that you precompile.
.LP
.SH OPTIONS
Options must be separate.
.TP
.B \-c
compile (this is the default).
.TP
.B \-u
undump, i.e., load and list the given binary files.
If no files are given, then luac undumps
.BR luac.out .
Listing a binary file is useful to learn Lua's virtual machine.
Listing is also useful to test the integrity of binary files:
corrupted files will probably generate errors when undumped.
To test without listing, use
.BR \-q .
For a thourough integrity test,
use
.BR \-t .
.TP
.B \-d
turn debugging on.
Individual chunks may
still control the generation of debug information with
$debug and $nodebug.
If debugging is on, then listings show the names of the local variables.
.TP
.BI \-D " name"
predefine symbol
.I name
for conditional compilation.
By default,
.B luac
does
.I not
predefine any symbols,
not even the built-in functions.
.TP
.B \-l
produce a listing of the compiled bytecode for Lua's virtual machine.
This is the default when undumping.
.TP
.B \-n
Save numbers in native format.
By default,
numbers are saved in text form,
for maximum portability.
Binary files with numbers in native format are slightly faster to load,
but are not completely portable.
.TP
.BI \-o " filename"
output to
.IR filename ,
instead of the default
.BR luac.out .
The output file cannot be a source file.
.TP
.B \-O
optimize.
Debug information is removed
and
duplicate constants are coalesced.
.TP
.B \-p
parse sources files but do not generate any output file.
Used mainly for syntax checking.
.TP
.B \-q
quiet; produces no listing.
This is the default when compiling.
.TP
.B \-t
perform a thourough integrity test when undumping.
Code that passes this test is completely safe,
in the sense that it will not break the interpreter.
However,
there is no guarantee that such code does anything sensible.
(None can be given, because the halting problem is unsolvable.)
.TP
.BI \-U " name"
undefine symbol
.I name
for conditional compilation.
.TP
.B \-v
print version information.
.TP
.B \-V
verbose;
print the names of the source files as they are processed.
.SH FILES
.TP 15
.B luac.out
default output file
.SH "SEE ALSO"
.BR lua (1)
.br
.I "Reference Manual of the Programming Language Lua"
.br
http://www.tecgraf.puc-rio.br/lua/
.br
"Lua: an extensible extension language",
.I Software: Practice & Experience
.B 26
#6 (1996) 635-652.
.SH DIAGNOSTICS
Error messages should be self explanatory.
.SH AUTHORS
L. H. de Figueiredo,
R. Ierusalimschy and
W. Celes
.I (lua@tecgraf.puc-rio.br)
.\" EOF
