/*
 * dstore.c - SunOS (Solaris 1.x and 2.x) global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.12 2000/06/19 12:11:38 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */

#if	defined(HAS_AFS)

# if	defined(HASAOPT)
char *AFSApath = (char *)NULL;		/* alternate AFS name list path
					 * (from -a) */
# endif	/* defined(HASAOPT) */

dev_t AFSdev;				/* AFS file system device number */
int AFSdevStat = 0;			/* AFSdev status: 0 = unknown;
					 *		  1 = known */

#if	defined(solaris)
int AFSfstype = -1;			/* AFS file system type index */
# endif	/* defined(solaris) */

KA_T AFSVfsp = (KA_T)NULL;		/* AFS vfs struct kernel address */
#endif	/* defined(HAS_AFS) */

struct clone *Clone = NULL;		/* clone list */

#if	defined(solaris)
major_t CloneMaj;			/* clone major device number */
#endif	/* defined(solaris) */

#if	!defined(solaris)
char *Cwd = NULL;			/* cwd path name buffer */
struct file *Fileptr;			/* for process_file() in dfile.c */
#endif


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *	       (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {

# if	defined(solaris)
	{ "arFid",	"afs_rootFid"		},
	{ "avops",	"afs_vnodeops"		},
	{ "Avops",	"Afs_vnodeops"		},
	{ "avol",	"afs_volumes"		},
	{ "auvops",	"auto_vnodeops"		},
	{ "cvops",	"cachefs_vnodeops"	},
	{ "clmaj",	"clonemaj"		},
	{ "fvops",	"fifo_vnodeops"		},
	{ "hvops",	"hsfs_vnodeops"		},
	{ "lvops",	"lo_vnodeops"		},
	{ "mntops",	"mntvnodeops"		},
	{ "mvops",	"mvfs_vnodeops"		},
	{ X_NCACHE,	"ncache"		},
	{ X_NCSIZE,	"ncsize"		},

#  if	defined(NCACHE_NEGVN)
	{ NCACHE_NEGVN,	NCACHE_NEGVN		},
#  endif	/* defined(NCACHE_NEGVN) */

	{ "nvops",	"nfs_vnodeops"		},
	{ "n3vops",	"nfs3_vnodeops"		},
	{ "nmvops",	"nm_vnodeops"		},
        { "nproc",	"nproc"			},
	{ "pdvops",	"pcfs_dvnodeops"	},
	{ "pfvops",	"pcfs_fvnodeops"	},
	{ "prvops",	"prvnodeops"		},
	{ "sgvops",	"segvn_ops"		},
	{ "sckvops",	"sock_vnodeops"		},
	{ "spvops",	"spec_vnodeops"		},
	{ "tvops",	"tmp_vnodeops"		},
	{ "uvops",	"ufs_vnodeops"		},
	{ "vvops",	"vx_vnodeops"		},
	{ "vvfops",	"fdd_vnops"		},
	{ "vvfcops",	"fdd_chain_vnops"	},

# if	solaris>=20500
	{ "dvops",	"door_vnodeops"		},
	{ "kbase",	"_kernelbase"		},
# endif	/* solaris>=20500 */

# else	/* !defined(solaris) */
	{ "arFid",	"_afs_rootFid"		},
	{ "avops",	"_afs_vnodeops"		},
	{ "avol",	"_afs_volumes"		},
	{ "fvops",	"_fifo_vnodeops"	},
        { "lfsvops",	"_lfs_vnodeops"		},
        { "hvops",	"_hsfs_vnodeops"	},
	{ X_NCACHE,	"_ncache"		},
	{ X_NCSIZE,	"_ncsize"		},
        { "nvops",	"_nfs_vnodeops"		},
        { "n3vops",	"_nfs3_vnodeops"	},
        { "nproc",	"_nproc"		},
	{ "pdvops",	"_pcfs_dvnodeops"	},
	{ "pfvops",	"_pcfs_fvnodeops"	},
	{ "sgvops",	"_segvn_ops"		},
	{ "spvops",	"_spec_vnodeops"	},
	{ "tvops",	"_tmp_vnodeops"		},
	{ "uvops",	"_ufs_vnodeops"		},
# endif	/* defined(solaris) */

# if	defined(SUNOSV)
	{ "kasp",	"_kas"			},
# else	/* !defined(SUNOSV) */
#  if	defined(solaris) && solaris>=20501
	{ "kasp",	"kas"			},
#  endif	/* defined(solaris) && solaris>=20501 */
# endif	/* defined(SUNOSV) */

	{ "",		""			},
	{ NULL,		NULL			}
};

#if	defined(solaris)
char **Fsinfo = NULL;			/* file system information */
int Fsinfomax = 0;			/* maximum file system type */
#endif

#if	defined(solaris)
int HaveCloneMaj = 0;			/* clone major device number has
					 * been identified and is in
					 * CloneMaj */
#endif	/* defined(solaris) */

kvm_t *Kd = NULL;			/* kvm descriptor */
struct l_vfs *Lvfs = NULL;		/* local vfs structure table */

# if	defined(solaris)
struct netclone *Netclone = NULL;	/* net clone devices from
					 * /devices/pseudo */
# endif	/* defined(solaris) */

# if	defined(HASFSTRUCT)
/*
 * Pff_tab[] - table for printing file flags
 */
struct pff_tab Pff_tab[] = {
#  if	defined(solaris)
	{ (long)FREAD,		FF_READ		},
	{ (long)FWRITE,		FF_WRITE	},
	{ (long)FNDELAY,	FF_NDELAY	},
	{ (long)FAPPEND,	FF_APPEND	},
	{ (long)FSYNC,		FF_SYNC		},

#   if	defined(FREVOKED)
	{ (long)FREVOKED,	FF_REVOKED	},
#   endif	/* defined(FREVOKED) */

	{ (long)FDSYNC,		FF_DSYNC	},
	{ (long)FRSYNC,		FF_RSYNC	},

#   if	defined(FOFFMAX)
	{ (long)FOFFMAX,	FF_LARGEFILE	},
#   endif	/* defined(FFOFFMAX) */

	{ (long)FNONBLOCK,	FF_NBLOCK	},
	{ (long)FNOCTTY,	FF_NOCTTY	},
	{ (long)FASYNC,		FF_ASYNC	},
	{ (long)FNODSYNC,	FF_NODSYNC	},
#  else	/* !defined(solaris) */
	{ (long)_FREAD,		FF_READ		},
	{ (long)_FWRITE,	FF_WRITE	},
	{ (long)_FNDELAY,	FF_NDELAY	},
	{ (long)_FAPPEND,	FF_APPEND	},
	{ (long)_FSETBLK,	FF_SETBLK	},
	{ (long)_FASYNC,	FF_ASYNC	},
	{ (long)_FSHLOCK,	FF_SHLOCK	},
	{ (long)_FEXLOCK,	FF_EXLOCK	},
	{ (long)_FNBIO,		FF_NBIO		},
	{ (long)_FSYNC,		FF_SYNC		},
	{ (long)_FNONBLOCK,	FF_NBLOCK	},
	{ (long)_FNOCTTY,	FF_NOCTTY	},
	{ (long)_FMARK,		FF_MARK		},
	{ (long)_FDEFER,	FF_DEFER	},
#  endif	/* defined(solaris) */

	{ (long)0,		NULL		}
};


/*
 * Pof_tab[] - table for print process open file flags
 */

struct pff_tab Pof_tab[] = {

# if	defined(UF_EXCLOSE)
	{ (long)UF_EXCLOSE,	POF_CLOEXEC	},
# endif	/* defined(UF_EXCLOSE) */

# if	defined(FD_CLOEXEC)
	{ (long)FD_CLOEXEC,	POF_CLOEXEC	},
# endif	/* defined(FD_CLOEXEC) */

# if	defined(UF_FDLOCK)
	{ (long)UF_FDLOCK,	POF_FDLOCK	},
# endif	/* defined(UF_FDLOCK) */

	{ (long)0,		NULL		}
};
#endif	/* defined(HASFSTRUCT) */

#if	defined(solaris)
struct pseudo *Pseudo = NULL;		/* non-clone devices from
					 * /devices/pseudo */
#else	/* !defined(solaris) */
char *Rtd = NULL;			/* root directory path name buffer */
#endif	/* defined(solaris) */
