/*
 * dnode2.c - Pyramid DC/OSx and Reliant UNIX node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */

/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode2.c,v 1.4 99/05/04 09:03:13 abe Exp $";
#endif


#include "lsof.h"

#if	defined(HASVXFS)
#undef	fs_bsize
#include <sys/fs/vx_fs.h>
#include <sys/fs/vx_inode.h>
#endif	/* defined(HASVXFS) */


/*
 * readvxfslino() - read rxfs inode's local inode information
 */

int
readvxfslino(v, i)
	struct vnode *v;		/* containing vnode */
	struct l_ino *i;		/* local inode information */
{

#if	defined(HASVXFS)
	struct inode vx;

	if (kread((KA_T)v->v_data, (char *)&vx, sizeof(vx)))
	    return(1);
	i->dev = vx.i_dev;
	i->rdev = vx.i_rdev;
	i->nlink = (long)vx.i_nlink;
	i->nlink_def = 1;
	i->number = vx.i_number;
	i->size = vx.i_size;
	return(0);
#else	/* !defined(HASVXFS) */
	return(1);
#endif	/* defined(HASVXFS) */

}


#if	defined(HASTFS)
#undef	fs_bfree
#undef	fs_devvp
#undef	fs_flags
#undef	fs_ifree
#undef	fs_magic
#undef	fs_mntpt
#undef	fs_ninode
#undef	fs_size
#undef	fs_version
#undef	i_gen
#undef	i_gid
#undef	i_mode
#undef	i_mtime
#undef	i_reserve
#undef	i_size
#undef	i_uid
#define	_KERNEL
#include <sys/fs/tfs.h>
#endif	/* defined(HASTFS) */


/*
 * readtfslino() - read TFS inode's local inode information
 */

int
readtfslino(v, i, kv)
	struct vnode *v;		/* containing vnode */
	struct l_ino *i;		/* local inode information */
	struct vfs *kv;			/* local copy of vnode's virtual file
					 * system structure */
{

#if	defined(HASTFS)
	struct tfs_inode t;

	if (kread((KA_T)v->v_data, (char *)&t, sizeof(t)))
	    return(1);
	i->dev = kv ? kv->vfs_dev : 0;
	i->rdev = v->v_rdev;
	i->nlink_def = 0;
	i->number = t.i_inum;
	i->size = t.i_size;
	return(0);

#else	/* !defined(HASTFS) */
	return(1);
#endif	/* defined(HASTFS) */

}
