/*
 * dlsof.h - AIX header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.18 2000/03/14 20:34:27 abe Exp $
 */


#if	!defined(AIX_LSOF_H)
#define	AIX_LSOF_H	1

#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <setjmp.h>
#include <unistd.h>

# if	!defined(_KERNEL)
#define _KERNEL	1
# endif

#include <sys/vnode.h>
#include <sys/file.h>
#include <procinfo.h>		/* <procinfo.h> #includes <sys/user.h> */
#define p_pid	pi_pid
#define	p_pgrp	pi_pgrp
#define	p_ppid	pi_ppid

# if	AIXV<4300
#define p_stat	pi_stat
# else	/* AIXV>=4300 */
#define	p_stat	pi_state
# endif	/* AIXV<4300 */

#define p_uid	pi_uid
#undef	sleep
#undef	_KERNEL

#include <sys/mbuf.h>
#include <sys/mntctl.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/sysmacros.h>
#include <sys/un.h>
#include <sys/unpcb.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/raw_cb.h>

# if	AIXV>=4100
#include <netinet/ip.h>
# endif	/* AIXV>=4100 */

#include <netinet/in_pcb.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <sys/vattr.h>
#include <sys/statfs.h>

#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>

# if	defined(HAS_AFS)
#define	__XDR_INCLUDE__
# endif	/* defined(HAS_AFS) */

#include <sys/vfs.h>
#include <sys/vmount.h>

# if	AIXV>=4100
#  if	AIXV>=4110
#undef	u
#undef	u_comm
#undef	u_cdir
#undef	u_rdir
#undef	u_maxofile
#undef	u_ufd
#undef	u_loader
#  endif	/* AIXV>=4110 */

#define	u_comm		U_comm
#define	u_cdir		U_cdir
#define	u_rdir		U_rdir
#define	u_maxofile	U_maxofile
#define	u_ufd		U_ufd
#define	u_loader	U_loader
# endif	/* AIXV>=4100 */

# if	defined(HAS_NFS)
#  if	AIXV<4210
#include <nfs/rnode.h>
#  else	/* AIXV>=4210 */
/*
 * Private rnode struct definition for AIX 4.2.1 and above
 *
 * The rnode struct IBM ships in <nfs/rnode.h> doesn't match the one
 * the kernel uses.  The kernel's rnode struct definition comes from
 * <oncplus/nfs/rnode.h>, a header file IBM does not ship with AIX.
 */

struct rnode {
	caddr_t	r_d1[11];		/* dummies; links? */
	struct vnode r_vnode;		/* vnode for remote file */
	struct gnode r_gnode;		/* gnode for remote file */

#  if	AIXV<4330
	caddr_t r_d2[29];		/* dummies; rnode elements? */
#  else	/* AIXV>=4330 */
	caddr_t r_d2[26];		/* dummies; rnode elements? */
#  endif	/* AIXV<4330 */

	off_t r_size;			/* client's view of file size (long)*/
	struct vattr r_attr;		/* cached vnode attributes */
};
#  endif	/* AIXV<4210 */
# endif	/* defined(HAS_NFS) && AIXV<4210 */

#  if	AIXV>=3200
#include <sys/specnode.h>
#  endif	/* AIXV>=3200 */

/*
 * AIX doesn't supply cdrnode.h.
 */

struct cdrnode {
	caddr_t		f1[4];
	struct gnode	f2;
	dev_t		f3;
	ino_t		cn_inumber;	/* inode number */
	caddr_t		f4;
	cnt_t		f5[2];
	u_short		f6;
	uint		f7[2];
	uchar		f8[3];
	off_t		cn_size;	/* size of file in bytes */
};


/*
 * AIX doesn't supply ld_data.h.
 */

struct le {				/* loader entry */

	struct le *next;		/* next entry pointer */

# if	AIXV<4300
	ushort dummy1;
	ushort dummy2;
	uint dummy3;
	struct file *fp;		/* file table entry pointer */

#  if	AIXV>=4110
	int ft;				/* file type indicator */
	unsigned dummy4;
	char *dummy5;
	unsigned dummy6;
	char *dummy7[3];
	char *nm;			/* name */
#  endif	/* AIXV>=4110 */
# else	/* AIXV>=4300 */
	uint flags;
	struct file *fp;		/* file table entry pointer */
	char *nm;			/* name */
# endif	/* AIXV<4300 */

};

# if	AIXV>=4300
/*
 * The elements of interest from the AIX >= 4.3 loader anchor structure.
 */
struct la {			/* loader anchor */

    struct le *list;
    struct le *exec;
};
# endif	/* AIXV>=4300 */

# if	defined(HAS_AFS)

/*
 *  Avoid typdef conflicts in <afs/stds.h>.
 */

#  if	defined(HASINT16TYPE)
#define	int16	AFS_int16
#  endif	/* defined(HASINT16TYPE */
#  if	defined(HASUINT16TYPE)
#define	u_int16	AFS_u_int16
#  endif	/* defined(HASUINT16TYPE */
#  if	defined(HASINT32TYPE)
#define int32	AFS_int32
#  endif	/* defined(HASINT32TYPE) */

#include <afs/stds.h>
#include <afs/param.h>
#include <afs/afsint.h>
#include <afs/vldbint.h>
# endif	/* defined(HAS_AFS) */


/*
 * Miscellaneous definitions.
 */

# if	defined(HAS_AFS)
#define	AFSAPATHDEF	"/usr/vice/etc/dkload/???"
#define	AFSDEV		1	/* AFS "fake" device number */

#  if	!defined(MNT_AFS)
#define	MNT_AFS		AFS_MOUNT_AFS
#  endif	/* !defined(MNT_AFS) */
# endif	/* defined(HAS_AFS) */

#define	COMP_P		const void
#define DEVINCR		1024	/* device table malloc() increment */

# if	AIXV<4200
typedef	off_t		KA_T;
# else	/* AIXV>=4200 */
typedef	unsigned int	KA_T;
# endif	/* AIXV<4200 */

#define KMEM		"/dev/kmem"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	unsigned
#define	N_UNIX		"/unix"
#define QSORT_P		void
#define	READLEN_T	unsigned
#define STRNCPY_L	size_t

# if	AIXV>=4200
#define	SZOFFTYPE	unsigned long long
				/* size and offset type definition */
#define	SZOFFPSPEC	"ll"	/* SZOFFTYPE print specification modifier */
# endif	/* AIXV>=4200 */

#define U_SIZE		sizeof(struct user)


# if	AIXV>=4110
/*
 * readx() definitions for AIX 4.1.1 and above.
 */

#define	LIBMASK		0xf0000000		/* library table mask */
#define	LIBNMCOMP	0xd0000000		/* library table name has
						 * multiple components */
#define	LIBNMLN		40			/* maximum library table name
						 * length */
#define	RDXMASK		0x0fffffff		/* kreadx() address mask */
# endif	/* AIXV>=4110 */


/*
 * Name list (Nl[]) indexes
 */

#define	X_UADDR		0
#define	X_NL_NUM	1


/*
 * Definition for ckfa.c
 */

#define	CKFA_MPXCHAN	1


/*
 * Definitions for dvch.c
 */

# if	AIXV>=4140
#define	DCACHE_CLONE	rw_clone_sect	/* clone function for read_dcache */
#define	DCACHE_CLR	clr_sect	/* function to clear clone and
					 * pseudo caches when reading the
					 * device cache file fails */
# endif	/* AIXV>=4140 */


/*
 * Definitions for enter_dir()
 */

#define	DIRTYPE	dirent
#define	HASDNAMLEN	1


# if	defined(HAS_AFS)
/*
 * AFS name list (AFSnl[]) indexes
 */

#define	X_AFS_FID	0
#define	X_AFS_VOL	1
#define	X_AFSNL_NUM	2
# endif	/* defined(HAS_AFS) */


# if	AIXV>=4140
/*
 * Local clone information
 */

struct clone {
	struct l_dev cd;		/* device, inode, name, verify status */
	struct clone *next;		/* next entry */
};
extern struct clone *Clone;
extern int CloneMaj;
extern int ClonePtc;
#endif	/* AIXV>=4140 */


/*
 * Local vfs information
 */

struct l_vfs {
	KA_T addr;			/* kernel address */
	dev_t dev;			/* device */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */
	int vmt_flags;			/* vmount flags */
	int vmt_gfstype;		/* vmount gfs type */
	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;


/*
 * Local mount information
 */

struct mounts {
        char *dir;              	/* directory (mounted on) */
	char *fsname;           	/* file system
					 * (symbolic links unresolved) */
	char *fsnmres;           	/* file system
					 * (symbolic links resolved) */
        dev_t dev;              	/* directory st_dev */
	dev_t rdev;			/* directory st_rdev */
	ino_t inode;			/* directory st_ino */
	u_short mode;			/* directory st_mode */
	u_short fs_mode;		/* file system st_mode */
        struct mounts *next;    	/* forward link */
};
extern struct mounts *Mtab;


/*
 * Search file information
 */

struct sfile {
	char *aname;			/* file name argument */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	chan_t ch;			/* channel (last path component,
					 * (if numeric) */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};


/*
 * Miscellaneous external definitions
 */

# if	defined(HAS_AFS)
extern struct nlist AFSnl[];	/* AFS kernel symbol name list table */

#  if	defined(HASAOPT)
extern char *AFSApath;		/* alternate AFS name list path (from -a) */
#  endif	/* defined(HASAOPT) */

extern KA_T AFSVfsp;		/* AFS struct vfs kernel pointer */
# endif	/* defined(HAS_AFS) */

extern int Kd;
extern int Km;
extern struct nlist Nl[];

# if	defined(TCPSTATES) && AIXV<=3250
/*
 * For AIX 3.2.5 and below, there is no header file with the  definition
 * of tcpstates[], needed by ptti.c's print_tcptpi() function.
 */

static char *tcpstates[] = {
	"CLOSED",       "LISTEN",       "SYN_SENT",     "SYN_RCVD",
	"ESTABLISHED",  "CLOSE_WAIT",   "FIN_WAIT_1",   "CLOSING",
	"LAST_ACK",     "FIN_WAIT_2",   "TIME_WAIT"
};
# endif	/* defined(TCPSTATES) && AIXV<=3250 */

#endif	/* AIX_LSOF_H */
