#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <netdb.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "browse.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "whois.h"

#ifdef WINMX_QUEUE_BEHAVIER
void whois_action_client(whois_t* whois);
#endif

void whois_request(char* user, int flag) {
  whois_t* whois;

  whois = whois_new(user, flag);
  send_command(CMD_CLIENT_WHOIS, whois->user);
}

whois_t* whois_new(char* user, int flag) {
  whois_t* result;

  if (!user) return NULL;

  result = (whois_t*)malloc(sizeof(whois_t));
  result->flag = flag;
  result->received = 0;
  result->online = 0;
  result->advanced = 0;
  result->yourself = 0;
  result->user = strdup(user);
  result->level = L_USER;
  result->online_time = 0;
  result->channels = NULL;
  result->status = NULL;
  result->shared = 0;
  result->downloads = 0;
  result->uploads = 0;
  result->link = 0;
  result->client = NULL;
  result->total_down = 0;
  result->total_up = 0;
  result->ip = NULL;
  result->server_port = 0;
  result->data_port = 0;
  result->email = NULL;

  global.whois_requests = g_list_append(global.whois_requests, result);

  return result;
}

void whois_destroy(whois_t* whois) {
  if (whois->user) free(whois->user);
  if (whois->channels) free(whois->channels);
  if (whois->status) free(whois->status);
  if (whois->client) free(whois->client);
  if (whois->ip) free(whois->ip);
  if (whois->email) free(whois->email);
  free(whois);
}

void whois_remove(whois_t* whois) {
  global.whois_requests = g_list_remove(global.whois_requests, whois);
  whois_destroy(whois);
}

void whois_action(whois_t* whois) {
  if (!whois) return;
  if (!whois->received) return;

  if (whois->yourself) whois_action_yourself(whois);
  if (whois->flag & WHOIS_SHOW) whois_action_show(whois);
  if (whois->flag & WHOIS_ONLINE) whois_action_online(whois);
  whois_action_hotlist(whois);
#ifdef WINMX_QUEUE_BEHAVIER
  whois_action_client(whois);
#endif
  whois_remove(whois);
}

whois_t* whois_search(char* user) {
  GList* dlist;
  whois_t* whois;

  if (!user || !*user) return NULL;

  for (dlist = global.whois_requests; dlist; dlist = dlist->next) {
    whois = (whois_t*)(dlist->data);
    if (!strcasecmp(whois->user, user)) return whois;
  }
  return NULL;
}

whois_t* whois_search_unreceived(char* user) {
  GList* dlist;
  whois_t* whois;

  if (!user || !*user) return NULL;

  for (dlist = global.whois_requests; dlist; dlist = dlist->next) {
    whois = (whois_t*)(dlist->data);
    if (!strcasecmp(whois->user, user) && !whois->received) return whois;
  }
  return NULL;
}

void whois_eval_whois(char* data) {
  whois_t* whois;
  char* pos1;

  pos1 = arg(data, 0);

  whois = whois_search_unreceived(pos1);

  if (!whois) return;

  free(whois->user);
  whois->user = strdup(pos1);

  if (!strcasecmp(whois->user, SERVER->nick)) whois->yourself = 1;
  
  whois->online = 1;
  time(&whois->received);

  pos1 = arg(NULL, 0);
  whois->level = level2int(pos1);
  
  pos1 = arg(NULL, 0);
  whois->online_time = strtoul(pos1, NULL, 10);
  
  pos1 = arg(NULL, 0);
  if (whois->channels) free(whois->channels);
  whois->channels = strdup(pos1);

  pos1 = arg(NULL, 0);
  if (whois->status) free(whois->status);
  whois->status = strdup(pos1);

  pos1 = arg(NULL, 0);
  whois->shared = atoi(pos1);

  pos1 = arg(NULL, 0);
  whois->downloads = atoi(pos1);

  pos1 = arg(NULL, 0);
  whois->uploads = atoi(pos1);

  pos1 = arg(NULL, 0);
  whois->link = atoi(pos1);
  
  pos1 = arg(NULL, 0);
  if (whois->client) free(whois->client);
  whois->client = strdup(pos1);

  pos1 = arg(NULL, 0);
  if (!pos1) {
    whois->advanced = 0;
  } else {
    whois->advanced = 1;
    whois->total_down = atoi(pos1);

    pos1 = arg(NULL, 0);
    whois->total_up = atoi(pos1);
    
    pos1 = arg(NULL, 0);
    if (whois->ip) free(whois->ip);
    whois->ip = strdup(pos1);
    
    pos1 = arg(NULL, 0);
    whois->server_port = atoi(pos1);
    
    pos1 = arg(NULL, 0);
    whois->data_port = atoi(pos1);
    
    pos1 = arg(NULL, 0);
    if (whois->email) free(whois->email);
    whois->email = strdup(pos1);
  }

  whois_action(whois);
}

void whois_eval_whowas(char* data) {
  whois_t* whois;
  char* pos1;

  pos1 = arg(data, 0);

  whois = whois_search_unreceived(pos1);
  free(whois->user);
  whois->user = strdup(pos1);

  whois->online = 0;
  whois->advanced = 0;
  time(&whois->received);

  pos1 = arg(NULL, 0);
  whois->level = level2int(pos1);

  pos1 = arg(NULL, 0);
  whois->online_time = strtoul(pos1, NULL, 10);

  whois_action(whois);
}

void whois_eval_not_online(char* data) {
  whois_t* whois;
  char* pos1;

  whois = whois_search_unreceived(data);
  free(whois->user);
  whois->user = strdup(data);

  whois->online = 0;
  whois->advanced = 0;
  time(&whois->received);

  pos1 = arg(NULL, 0);
  whois->level = L_USER;

  pos1 = arg(NULL, 0);
  whois->online_time = 0;

  whois_action(whois);
}

// and now the whois actions:
// WHOIS_SHOW
void whois_action_show(whois_t* whois) {
  char* text;
  char* text2;
  char str[1024];
  GtkEntry* entry;
  GtkWidget* temp;

  if (!whois) return;
  if (!whois->received) return;
  
  if (!global.whois_win) {
    global.whois_win = create_whois_win();
  } else {
    gdk_window_raise(global.whois_win->window);
  }
  gtk_widget_show(global.whois_win);

  text = strdup(ctime(&whois->received));
  text[strlen(text)-1] = 0;
  text2 = g_strdup_printf("%s [%s]", _("Whois User"), text);
  gtk_window_set_title (GTK_WINDOW (global.whois_win), text2);
  g_free(text);
  g_free(text2);

  temp = lookup_widget(global.whois_win, "label116");
  if (whois->online)
    gtk_label_set_text(GTK_LABEL(temp), _("Online"));
  else
    gtk_label_set_text(GTK_LABEL(temp), _("Last Seen"));

  temp = lookup_widget(global.whois_win, "label527");
  gtk_label_set_text(GTK_LABEL(temp), whois->user);

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry25"));
  gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
  gtk_entry_set_text(entry, _("Level: "));
  gtk_entry_append_text(entry, Level[whois->level]);

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry26"));
  if (whois->online) {
    if (whois->online_time >= 60*60*24) 
      text = g_strdup_printf(_("%ld days %ld hours %ld minutes %ld seconds"), 
			     whois->online_time/(24*60*60), 
			     (whois->online_time%(24*60*60))/(60*60), 
			     (whois->online_time%(60*60))/60, whois->online_time%60);
    else if (whois->online_time >= 60*60)
      text = g_strdup_printf(_("%ld hours %ld minutes %ld seconds"), 
			      whois->online_time/(60*60),
			      (whois->online_time%(60*60))/60, 
			      whois->online_time%60);
    else
      text = g_strdup_printf(_("%ld minutes %ld seconds"), 
			      whois->online_time/60, whois->online_time%60);
  } else if (whois->online_time > 0) {
    text = g_strdup_printf("%s", ctime(&whois->online_time));
  } else {
    text = strdup(_("Unregistered"));
  }
  gtk_entry_set_text(entry, text);
  g_free(text);
  
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry27"));
  if (whois->online) {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
    gtk_entry_set_text(entry, whois->channels);
  } else {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
    gtk_entry_set_text(entry, "");
  }

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry28"));
  if (whois->online) {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
    gtk_entry_set_text(entry, _("Status: "));
    gtk_entry_append_text(entry, whois->status);
  } else {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
    gtk_entry_set_text(entry, "");
  }

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry62"));
  if (whois->online) {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
    gtk_entry_set_text(entry, _("Shared: "));
    sprintf(str, "%d", whois->shared);
    gtk_entry_append_text(entry, str);
  } else {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
    gtk_entry_set_text(entry, "");
  }

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry30"));
  if (whois->online) {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
    sprintf(str, "%d", whois->downloads);
    gtk_entry_set_text(entry, str);
    gtk_entry_append_text(entry, _(" downs"));
  } else {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
    gtk_entry_set_text(entry, "");
  }

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry59"));
  if (whois->online) {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
    sprintf(str, "%d", whois->uploads);
    gtk_entry_set_text(entry, str);
    gtk_entry_append_text(entry, _(" ups"));
  } else {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
    gtk_entry_set_text(entry, "");
  }

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry61"));
  if (whois->online) {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
    gtk_entry_set_text(entry, _("Link: "));
    gtk_entry_append_text(entry, LineSpeed(whois->link));
  } else {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
    gtk_entry_set_text(entry, "");
  }

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry60"));
  if (whois->online) {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), TRUE);
    gtk_entry_set_text(entry, whois->client);
  } else {
    gtk_widget_set_sensitive(GTK_WIDGET(entry), FALSE);
    gtk_entry_set_text(entry, "");
  }

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry34"));
  gtk_entry_set_text(entry, "");

  temp = lookup_widget(global.whois_win, "table18");
  if (!whois->advanced) {
    gtk_widget_hide(temp);
    return;
  } else {
    gtk_widget_show(temp);
  }
  
  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry63"));
  sprintf(str, "%d", whois->total_down);
  gtk_entry_set_text(entry, str);
  gtk_entry_append_text(entry, _(" downs"));

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry64"));
  sprintf(str, "%d", whois->total_up);
  gtk_entry_set_text(entry, str);
  gtk_entry_append_text(entry, _(" ups"));

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry65"));
  gtk_entry_set_text(entry, whois->ip);

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry66"));
  sprintf(str, "%d", whois->server_port);
  gtk_entry_set_text(entry, _("Server: "));
  gtk_entry_append_text(entry, str);

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry67"));
  sprintf(str, "%d", whois->data_port);
  gtk_entry_set_text(entry, _("Data: "));
  gtk_entry_append_text(entry, str);

  entry = GTK_ENTRY(lookup_widget(global.whois_win, "entry68"));
  gtk_entry_set_text(entry, whois->email);
}

void whois_action_yourself(whois_t* whois) {
  GtkWidget* temp;

  if (!whois) return;

  global.user.level = whois->level;
#ifdef GLOBAL_DEBUG
  printf("user level: %d\n", global.user.level);
#endif
  if (global.user.level >= L_MOD) {
    temp = lookup_widget(global.win, "global_users");
    gtk_widget_set_sensitive(temp, TRUE);
    temp = lookup_widget(global.win, "banned_users");
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    temp = lookup_widget(global.win, "global_users");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "banned_users");
    gtk_widget_set_sensitive(temp, FALSE);
  }
  
  global.user.status = status2int(whois->status);
  update_user_stats(0);
}

void whois_action_online(whois_t* whois) {

  if (whois->online) resume_user_online(whois->user, whois->link);
  else resume_user_offline(whois->user);

}

void whois_action_hotlist(whois_t* whois) {
  GtkCList* clist;
  int row;
  hot_t* hot;
  char str[1024];

  if (!whois->online) return;

  hot = hotlist_search_user(whois->user);
  if (!hot) return;

  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  row = gtk_clist_find_row_from_data(clist, hot);
  if (row >= 0) {
    gtk_clist_set_text(clist, row, 2, LineSpeed(whois->link));
    sprintf(str, "%d", whois->shared);
    gtk_clist_set_text(clist, row, 1, str);
    gtk_clist_sort(clist);
  }
}

#ifdef WINMX_QUEUE_BEHAVIER
void whois_action_client(whois_t* whois) {
  user_info_t* userinfo;

  if (!whois->online) return;
  userinfo = search_user_info(whois->user, 1);
  if (!userinfo) return;

  if (!strncasecmp(whois->client, "WinMX", 5)) {
    userinfo->client = C_WINMX;
#ifdef WINMX_QUEUE_BEHAVIER
    //    send_private(whois->user, "//WantQueue", 1);
#endif
  } else userinfo->client = C_OTHER;
}
#endif
