#include <sys/time.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "resume.h"
#include "server.h"
#include "preferences.h"

void set_options_channels() {
  GList* dlist;
  int i1;
  GtkWidget* temp;
  char* pos;

  if (!global.options_win) return;

  dlist = NULL;
  temp = lookup_widget(global.win, "channel_list");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &pos);
    dlist = g_list_append(dlist, strdup(pos));
  }
  if (dlist) {
    temp = lookup_widget(global.options_win, "combo8");
    gtk_combo_set_popdown_strings (GTK_COMBO (temp), dlist);
  }
}

void setup_preferences(unsigned long flags) {
  GtkWidget* win;
  GtkWidget* temp;
  GList* dlist;
  GList* list2;
  int row;
  command_t* command;
  char* pos;

  if (!global.options_win) return;
  else win = global.options_win;

  if (flags & P_TREE) {
    GtkCTreeNode* node;
    GtkCTreeNode* node2;
    GtkCTree* ctree;

    ctree = GTK_CTREE(lookup_widget(win, "ctree2"));
    gtk_ctree_set_line_style(ctree, GTK_CTREE_LINES_NONE);
    gtk_ctree_set_expander_style(ctree, GTK_CTREE_EXPANDER_TRIANGLE);
    strcpy(tstr[0], _("General"));
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				 NULL, NULL, NULL, NULL,
				 FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void*)1);
    strcpy(tstr[0], _("Search"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)2);
    strcpy(tstr[0], _("Transfers"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)3);
    strcpy(tstr[0], _("Mimetypes"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)4);
    strcpy(tstr[0], _("Paths"));
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void*)5);
    strcpy(tstr[0], _("Download"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)6);
    strcpy(tstr[0], _("Shares"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)7);
    strcpy(tstr[0], _("Appearance"));
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				 NULL, NULL, NULL, NULL,
				 FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void*)8);
    strcpy(tstr[0], _("Chat"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)9);
    strcpy(tstr[0], _("Schemes"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)10);
    strcpy(tstr[0], _("Advanced"));
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				 NULL, NULL, NULL, NULL,
				 FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void*)11);
    strcpy(tstr[0], _("Aliases"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)12);
    strcpy(tstr[0], _("Channels"));
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL,
				  TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void*)13);

    temp = lookup_widget(win, "frame266");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame267");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame268");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame69");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame37");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame39");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame11");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame155");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame185");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame92");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame93");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "label427");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "label428");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame167");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame67");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame176");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "label429");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame184");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "label506");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "label510");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame187");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame188");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "label513");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame240");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "label780");
    gtk_widget_set_style(temp, global.style[STYLE_PREF]);
    temp = lookup_widget(win, "frame306");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame307");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame308");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame318");
    gtk_widget_set_style(temp, global.style[3]);
    temp = lookup_widget(win, "frame321");
    gtk_widget_set_style(temp, global.style[3]);
  }
  if (flags & P_GENERAL) {
    temp = lookup_widget(win, "entry4");
    gtk_entry_set_text(GTK_ENTRY(temp), global.user.username);
    temp = lookup_widget(win, "entry5");
    gtk_entry_set_text(GTK_ENTRY(temp), global.user.password);
    temp = lookup_widget(win, "entry7");
    gtk_entry_set_text(GTK_ENTRY(temp), global.user.email);
    temp = GTK_COMBO(lookup_widget(win, "combo3"))->entry;
    gtk_entry_set_text(GTK_ENTRY(temp), LineSpeed(global.user.linespeed));
    temp = lookup_widget(win, "spinbutton2");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.network.port);
    if (global.network.firewall) 
      gtk_widget_set_sensitive(GTK_WIDGET(temp), FALSE);
    else
      gtk_widget_set_sensitive(GTK_WIDGET(temp), TRUE);
    temp = lookup_widget(win, "checkbutton4");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.network.firewall);
    temp = lookup_widget(win, "entry83");
    pos = create_string_from_ports(global.allowed_ports);
    if (pos) gtk_entry_set_text(GTK_ENTRY(temp), pos);
    g_free(pos);
  }

  if (flags & P_NSEARCH) {
    temp = lookup_widget(win, "spinbutton50");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), 
			      (gfloat)global.limit.max_searches);
  }
  if (flags & P_RSEARCH) {
    temp = lookup_widget(win, "spinbutton51");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), global.resume_timeout);
    if (global.resume_timer >= 0) {
      gtk_widget_set_sensitive(temp, TRUE);
      temp = lookup_widget(win, "checkbutton48");
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    } else {
      gtk_widget_set_sensitive(temp, FALSE);
      temp = lookup_widget(win, "checkbutton48");
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
    }
  }
  if (flags & P_PINGS) {
    temp = lookup_widget(global.win, "checkbutton45");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
      temp = lookup_widget(win, "checkbutton49");
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
      temp = lookup_widget(win, "entry85");
      if (global.ping_command)
	gtk_entry_set_text(GTK_ENTRY(temp), global.ping_command);
      gtk_widget_set_sensitive(temp, TRUE);
    } else {
      temp = lookup_widget(win, "checkbutton49");
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
      temp = lookup_widget(win, "entry85");
      if (global.ping_command)
	gtk_entry_set_text(GTK_ENTRY(temp), global.ping_command);
      gtk_widget_set_sensitive(temp, FALSE);
    }
  }

  if (flags & P_D_LIMIT) {
    temp = lookup_widget(win, "spinbutton38");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.limit.max_downloads);
  }
  if (flags & P_U_LIMIT) {
    temp = lookup_widget(win, "spinbutton39");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.limit.max_uploads);
  }
  if (flags & P_D_ULIMIT) {
    temp = lookup_widget(win, "spinbutton1");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.limit.default_downloads);
  }
  if (flags & P_U_ULIMIT) {
    temp = lookup_widget(win, "spinbutton3");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.limit.default_uploads);
  }
  if (flags & P_AUTORESUME) {
    temp = lookup_widget(win, "checkbutton34");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.network.auto_resume);
  }
  if (flags & P_REST1) {
    temp = lookup_widget(win, "spinbutton40");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)(global.network.transfer_timeout));
    temp = lookup_widget(win, "checkbutton62");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.confirm_delete);
  }

  if (flags & P_MIMETYPES) {
    int i1;
    suffix_t* suffix;

    temp = lookup_widget(win, "clist17");
    for (i1 = 1; i1 < MIME_SIZE; i1++) {
      for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
	suffix = (suffix_t*)(dlist->data);
	strcpy(tstr[0], suffix->suffix);
	strcpy(tstr[1], MimeNames(i1));
	strcpy(tstr[2], suffix->application);
	if (suffix->as_mp3) strcpy(tstr[3], _("Yes"));
	else strcpy(tstr[3], _("No"));
	gtk_clist_append(GTK_CLIST(temp), list);
      }
    }
  }

  if (flags & P_PATHS) {
    temp = lookup_widget(win, "entry75");
    if (global.incomplete_path)
      gtk_entry_set_text(GTK_ENTRY(temp), global.incomplete_path);
    else
      gtk_entry_set_text(GTK_ENTRY(temp), "");
  }

  if (flags & P_DOWNLOAD) {
    int i1;
    temp = lookup_widget(win, "clist18");
    for (i1 = 0; i1 < MIME_SIZE; i1++) {
      strcpy(tstr[0], MimeNames(i1));
      if (global.mimetype[i1].download)
	strcpy(tstr[1], global.mimetype[i1].download);
      else strcpy(tstr[1], "");
      gtk_clist_append(GTK_CLIST(temp), list);
    }
  }

  if (flags & P_SHARES) {
    int i1;
    GList* dlist;

    temp = lookup_widget(win, "clist19");
    for (i1 = 0; i1 < MIME_SIZE; i1++) {
      for (dlist = global.mimetype[i1].shared; dlist; dlist = dlist->next) {
	strcpy(tstr[0], MimeNames(i1));
	strcpy(tstr[1], dlist->data);
	gtk_clist_append(GTK_CLIST(temp), list);
      }
    }
  }

  if (flags & P_HIGHLIGHT) {
    temp = lookup_widget(win, "entry42");
    pos = make_string_from_list(global.highlight, " ");
    gtk_entry_set_text(GTK_ENTRY(temp), pos);
  }
  if (flags & P_FRIENDS) {
    temp = lookup_widget(win, "entry44");
    pos = make_string_from_list(global.frienduser, " ");
    gtk_entry_set_text(GTK_ENTRY(temp), pos);
  }
  if (flags & P_ENEMIES) {
    temp = lookup_widget(win, "entry52");
    pos = make_string_from_list(global.enemyuser, " ");
    gtk_entry_set_text(GTK_ENTRY(temp), pos);
  }
  if (flags & P_IGNORE) {
    temp = lookup_widget(win, "checkbutton12");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.public_ignore);
  }
  if (flags & P_PARSE_COLOR) {
    temp = lookup_widget(win, "checkbutton22");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.parse_color);
  }
  if (flags & P_TAB_STYLE) {
    temp = lookup_widget(win, "checkbutton57");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), 
				 global.options.tab_style&TAB_ICON);
    
    temp = lookup_widget(win, "checkbutton58");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), 
				 global.options.tab_style&TAB_TEXT);
    
  }
  if (flags & P_SHOW_JOIN) {
    temp = lookup_widget(win, "combo_entry25");
    switch (global.options.show_parts) {
    case 0:
      gtk_entry_set_text(GTK_ENTRY(temp), _("None"));
      break;
    case 1:
      gtk_entry_set_text(GTK_ENTRY(temp), _("Recent Users"));
      break;
    case 2:
    default:
      gtk_entry_set_text(GTK_ENTRY(temp), _("All"));
      break;
    }

    temp = lookup_widget(win, "spinbutton56");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), global.options.recent_timeout);

    temp = lookup_widget(win, "combo_entry24");
    switch (global.options.show_joins) {
    case 0:
      gtk_entry_set_text(GTK_ENTRY(temp), _("None"));
      break;
    case 1:
    default:
      gtk_entry_set_text(GTK_ENTRY(temp), _("All"));
      break;
    }
  }

  if (flags & P_TIMESTAMPS) {
    temp = lookup_widget(win, "entry108");
    switch (global.options.timestamps) {
    case TIME_NONE:
      gtk_entry_set_text(GTK_ENTRY(temp), _("None"));
      break;
    case TIME_BEATTIME:
      gtk_entry_set_text(GTK_ENTRY(temp), _("BeatTime"));
      break;
    case TIME_HOUR_MIN:
      gtk_entry_set_text(GTK_ENTRY(temp), _("Hour:Minute"));
      break;
    case TIME_HOUR_MIN_SEC:
    default:
      gtk_entry_set_text(GTK_ENTRY(temp), _("Hour:Minute:Second"));
      break;
    }
  }

  if (flags & P_SCHEMES) {
    if (global.scheme)
      scheme_update_list(global.scheme->name);
    else
      scheme_update_list(NULL);
  }

  if (flags & P_ADVANCED) {
    temp = lookup_widget(win, "checkbutton65");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.check_version);
    temp = lookup_widget(win, "checkbutton13");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.network.auto_connect);
    temp = lookup_widget(win, "checkbutton38");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.network.allow_dcc);
    temp = lookup_widget(win, "checkbutton54");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.dummy_md5);

    temp = lookup_widget(win, "button312");
    gtk_object_set_data(GTK_OBJECT(temp), "value", (void*)global.options.piping);

    temp = lookup_widget(win, "checkbutton33");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.network.auto_reconnect);
    temp = lookup_widget(win, "spinbutton32");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), global.network.auto_reconnect);
    gtk_widget_set_sensitive(temp, (global.network.auto_reconnect > 0));

    temp = lookup_widget(win, "checkbutton16");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.logging);
    temp = lookup_widget(win, "spinbutton34");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), global.options.log_expire);
    gtk_widget_set_sensitive(temp, global.options.logging);
    switch (global.options.popup_create) {
    case 1: temp = lookup_widget(win, "radiobutton1"); break;
    case 2: temp = lookup_widget(win, "radiobutton2"); break;
    case 3: temp = lookup_widget(win, "radiobutton3"); break;
    default: temp = lookup_widget(win, "radiobutton1"); break;
    }
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);

    temp = lookup_widget(win, "combo_entry27");
    gtk_entry_set_text(GTK_ENTRY(temp), browser_to_string(global.browser));

    temp = lookup_widget(win, "spinbutton41");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), (gfloat)global.network.transfer_delay);
  }

  if (flags & P_ALIASES) {
    list2 = NULL;
    temp = lookup_widget(win, "combo6");
    if (global.commands) {
      dlist = g_list_first(global.commands);
      while (dlist) {
	command = (command_t*)(dlist->data);
	if (command->is_alias == 0)
	  list2 = g_list_append (list2, command->name);
	dlist = g_list_next(dlist);
      }
      gtk_combo_set_popdown_strings (GTK_COMBO (temp), list2);
      g_list_free (list2);
    }
  }

  if (flags & P_CHANNEL) {
    temp = lookup_widget(win, "clist6");
    if (global.channels) {
      for (row = 0; row < g_list_length(global.channels); row++) {
	strcpy(tstr[0], g_list_nth(global.channels, row)->data);
	gtk_clist_append(GTK_CLIST(temp), &list[0]);
      }
    }
    set_options_channels();
  }  
  if (flags & P_REJOIN) {
    temp = lookup_widget(win, "checkbutton60");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.channel_rejoin);
  }
}

int search_shared_folder(char* folder, int mime) {
  GList* dlist;

  for (dlist = global.mimetype[mime].shared; dlist; dlist = dlist->next) {
    if (!strcmp(folder, (char*)(dlist->data))) return 1;
  }
  return 0;
}

void clear_shared_folder() {
  int i1;
  GList* dlist;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!global.mimetype[i1].shared) continue;
    for (dlist = global.mimetype[i1].shared; dlist; dlist = dlist->next) {
      free(dlist->data);
    }
    g_list_free(global.mimetype[i1].shared);
    global.mimetype[i1].shared = NULL;
  }
}

int count_shared_folder() {
  int i1;
  GList* dlist;
  int result = 0;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!global.mimetype[i1].shared) continue;
    for (dlist = global.mimetype[i1].shared; dlist; dlist = dlist->next) {
      result++;
    }
  }
  return result;
}

void clear_suffixes() {
  int i1;
  GList* dlist;
  suffix_t* suffix;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!global.mimetype[i1].suffixes) continue;
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t*)(dlist->data);
      free(suffix->suffix);
      free(suffix->application);
      free(suffix);
    }
    g_list_free(global.mimetype[i1].suffixes);
    global.mimetype[i1].suffixes = NULL;
  }
}

void apply_preferences() {
  GtkWidget* win;
  GtkWidget* temp;
  char str[4096];
  int i1;
  int i2;
  char* pos;
  char* pos2;
  int do_refresh;
  scheme_t* scheme;

  if (!global.options_win) return;
  else win = global.options_win;

  // general
  temp = lookup_widget(win, "entry4");
  strcpy(global.user.username, gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "entry5");
  strcpy(global.user.password, gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "entry7");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strcmp(pos, global.user.email)) {
    strcpy(global.user.email, pos);
    send_command(CMD_CLIENT_CHANGE_EMAIL, global.user.email);
  }
  temp = GTK_COMBO(lookup_widget(win, "combo3"))->entry;
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  i1 = speed2int(pos);
  if (i1 != global.user.linespeed) {
    global.user.linespeed = i1;
    sprintf(str, "%d", global.user.linespeed);
    send_command(CMD_CLIENT_CHANGE_SPEED, str);
  }

  temp = lookup_widget(win, "entry83");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  destroy_allowed_ports(global.allowed_ports);
  global.allowed_ports = create_allowed_ports(pos);
  free(pos);
  pos = create_string_from_ports(global.allowed_ports);
  if (pos) gtk_entry_set_text(GTK_ENTRY(temp), pos);
  g_free(pos);

  temp = lookup_widget(win, "spinbutton2");
  i1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton4");
  i2 = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  if ((global.network.port != i1) || 
      (global.network.firewall != i2)) {
    global.network.firewall = i2;
    create_upload_port(i1, TRUE);
  }

  // search
  temp = lookup_widget(win, "spinbutton50");
  global.limit.max_searches = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton42");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_searches);

  temp = lookup_widget(win, "spinbutton51");
  global.resume_timeout = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton48");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(global.win, "checkbutton46");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  } else {
    temp = lookup_widget(global.win, "checkbutton46");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  }
  temp = lookup_widget(global.win, "spinbutton48");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.resume_timeout);
  
  temp = lookup_widget(win, "entry85");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  free(global.ping_command);
  global.ping_command = strdup(pos);

  temp = lookup_widget(win, "checkbutton49");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(global.win, "checkbutton45");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  } else {
    temp = lookup_widget(global.win, "checkbutton45");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  }
  

  // Transfers
  temp = lookup_widget(win, "spinbutton38");
  global.limit.max_downloads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton5");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_downloads);
  temp = lookup_widget(win, "spinbutton39");
  global.limit.max_uploads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton6");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_uploads);

  temp = lookup_widget(win, "spinbutton1");
  global.limit.default_downloads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton35");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_downloads);

  temp = lookup_widget(win, "spinbutton3");
  global.limit.default_uploads = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton36");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_uploads);
  
  temp = lookup_widget(win, "spinbutton40");
  global.network.transfer_timeout = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton34");
  global.network.auto_resume =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton35");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.network.auto_resume);

  temp = lookup_widget(win, "checkbutton62");
  global.options.confirm_delete =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));


  // mimetypes
  clear_suffixes();
  temp = lookup_widget(win, "clist17");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    int mime;
    char* suf;
    char* app;
    char* as_mp3;
    suffix_t* suffix;

    gtk_clist_get_text (GTK_CLIST(temp), i1, 1, &pos);
    mime = mime2int(pos);
    gtk_clist_get_text (GTK_CLIST(temp), i1, 0, &suf);
    gtk_clist_get_text (GTK_CLIST(temp), i1, 2, &app);
    gtk_clist_get_text (GTK_CLIST(temp), i1, 3, &as_mp3);
    suffix = (suffix_t*)malloc(sizeof(suffix_t));
    suffix->suffix = strdup(suf);
    suffix->application = strdup(app);
    if (!strcasecmp(as_mp3, _("Yes"))) suffix->as_mp3 = 1;
    else suffix->as_mp3 = 0;
    if (mime == MIME_MP3) suffix->as_mp3 = 1;
    global.mimetype[mime].suffixes = 
      g_list_append(global.mimetype[mime].suffixes, suffix);
  }
  

  // paths
  temp = lookup_widget(win, "entry75");
  if (global.incomplete_path) free(global.incomplete_path);
  global.incomplete_path = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  // download
  temp = lookup_widget(win, "clist18");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    int mime;
    
    gtk_clist_get_text (GTK_CLIST(temp), i1, 0, &pos);
    mime = mime2int(pos);
    gtk_clist_get_text (GTK_CLIST(temp), i1, 1, &pos);
    if (global.mimetype[mime].download) 
      free(global.mimetype[mime].download);
    global.mimetype[mime].download = strdup(pos);
  }

  // shares
  temp = lookup_widget(win, "clist19");
  do_refresh = 0;
  i2 = 0;
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    int mime;
    gtk_clist_get_text (GTK_CLIST(temp), i1, 0, &pos);
    mime = mime2int(pos);
    gtk_clist_get_text (GTK_CLIST(temp), i1, 1, &pos);
    if (search_shared_folder(pos, mime)) i2++;
  }

  if (i2 < GTK_CLIST(temp)->rows) do_refresh = 1;
  if (i2 < count_shared_folder()) do_refresh = 1;
  
  clear_shared_folder();
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    int mime;
    gtk_clist_get_text (GTK_CLIST(temp), i1, 0, &pos);
    mime = mime2int(pos);
    gtk_clist_get_text (GTK_CLIST(temp), i1, 1, &pos);
    global.mimetype[mime].shared = 
      g_list_append(global.mimetype[mime].shared, strdup(pos));
  }

  // Appearance
  temp = lookup_widget(global.options_win, "button312");
  global.options.piping = (int)gtk_object_get_data(GTK_OBJECT(temp), "value");

  temp = lookup_widget(win, "entry42");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  make_list_from_string(&global.highlight, pos, " ");
  free(pos);
  pos = make_string_from_list(global.highlight, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(win, "entry44");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  make_list_from_string(&global.frienduser, pos, " ");
  free(pos);
  pos = make_string_from_list(global.frienduser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(win, "entry52");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  make_list_from_string(&global.enemyuser, pos, " ");
  free(pos);
  pos = make_string_from_list(global.enemyuser, " ");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);

  temp = lookup_widget(win, "combo_entry24");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "combo_entry25");
  pos2 = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "spinbutton56");
  i1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(global.win, "combo_entry23");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  free(pos);
  temp = lookup_widget(global.win, "combo_entry22");
  gtk_entry_set_text(GTK_ENTRY(temp), pos2);
  free(pos2);
  temp = lookup_widget(global.win, "spinbutton55");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), i1);

  temp = lookup_widget(win, "checkbutton12");
  global.options.public_ignore =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton10");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.public_ignore);

  temp = lookup_widget(win, "checkbutton22");
  global.options.parse_color =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton21");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.parse_color);
  temp = lookup_widget(win, "checkbutton57");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.tab_style |= TAB_ICON;
  else global.options.tab_style &= (0x03^TAB_ICON);
  temp = lookup_widget(win, "checkbutton58");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.tab_style |= TAB_TEXT;
  else global.options.tab_style &= (0x03^TAB_TEXT);

  temp = lookup_widget(win, "checkbutton60");
  global.options.channel_rejoin =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(global.win, "checkbutton59");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.channel_rejoin);

  temp = lookup_widget(win, "entry108");
  pos = strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(global.win, "combo_entry26");
  gtk_entry_set_text(GTK_ENTRY(temp), pos);
  free(pos);

  setup_main_tab();

  // saving color scheme
  //  on_button100_clicked(NULL, NULL);

  // setting up new color scheme
  temp = lookup_widget(win, "combo_entry15");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = scheme_load(pos);
  if (scheme) {
    scheme_destroy(global.scheme);
    global.scheme = scheme;
    client_message(_("Message"), _("Scheme [%s] loaded!"), scheme->name);
  } else {
    client_message(_("Message"), _("Loading scheme [%s] failed!"), pos);
  }

  // Advanced
  temp = lookup_widget(win, "checkbutton65");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    if (!global.options.check_version)
      global.options.check_version = 1;
  } else {
    global.options.check_version = 0;
  }

  temp = lookup_widget(win, "checkbutton13");
  global.network.auto_connect =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton38");
  global.network.allow_dcc =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton54");
  global.options.dummy_md5 =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton33");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "spinbutton32");
    global.network.auto_reconnect = 
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  } else {
    global.network.auto_reconnect = 0;
  }
  
  temp = lookup_widget(win, "checkbutton16");
  global.options.logging =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(win, "spinbutton34");
  global.options.log_expire = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "spinbutton41");
  global.network.transfer_delay = 
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  
  temp = lookup_widget(win, "combo_entry27");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  global.browser = browser_to_int(pos);

  temp = lookup_widget(win, "radiobutton1");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.popup_create = 1;
  temp = lookup_widget(win, "radiobutton2");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.popup_create = 2;
  temp = lookup_widget(win, "radiobutton3");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.popup_create = 3;

  // channels
  if (global.channels) {
    g_list_free(global.channels);
    global.channels = NULL;
  }
  temp = lookup_widget(win, "clist6");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &pos);
    global.channels = 
      g_list_append(global.channels, strdup(pos));
  }
  
  write_rc();

  if (do_refresh) lib_refresh();
}

void preferences_goto(int section) {
  GtkCList* clist;

  if (!global.options_win) {
    on_preferences_activate(NULL, NULL);
  }
  if (!global.options_win) return;

  clist = GTK_CLIST(lookup_widget(global.options_win, "ctree2"));
  gtk_clist_select_row(clist, section, 0);
}

void on_toggle_pipe(GtkMenuItem     *menuitem,
		    gpointer         user_data) {
  int value;
  GtkWidget* temp;
  int no = (int)user_data;

  temp = lookup_widget(global.options_win, "button312");
  value = (int)gtk_object_get_data(GTK_OBJECT(temp), "value");
  value = value ^ no;
  gtk_object_set_data(GTK_OBJECT(temp), "value", (gpointer)value);
}

GtkWidget* create_pipe_popup (int val) {
  GtkWidget *mode_popup;
  GtkAccelGroup *mode_popup_accels;
  GtkWidget *mode;

  mode_popup = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (mode_popup), "mode_popup", mode_popup);
  mode_popup_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (mode_popup));

  mode = gtk_check_menu_item_new_with_label (_("Away Logging"));
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (val & PIPE_AWAY_LOG)
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
		      (GtkSignalFunc)on_toggle_pipe,
		      (gpointer)PIPE_AWAY_LOG);

  mode = gtk_check_menu_item_new_with_label (_("Channel Operator Message"));
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (val & PIPE_CHWALLOP)
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
		      (GtkSignalFunc)on_toggle_pipe,
		      (gpointer)PIPE_CHWALLOP);

  mode = gtk_check_menu_item_new_with_label (_("Operator Messages"));
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (val & PIPE_WALLOP)
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
		      (GtkSignalFunc)on_toggle_pipe,
		      (gpointer)PIPE_WALLOP);

  mode = gtk_check_menu_item_new_with_label (_("Global Messages"));
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (val & PIPE_GLOBAL)
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
		      (GtkSignalFunc)on_toggle_pipe,
		      (gpointer)PIPE_GLOBAL);

  mode = gtk_check_menu_item_new_with_label (_("Server Messages"));
  gtk_widget_show (mode);
  gtk_container_add (GTK_CONTAINER (mode_popup), mode);
  if (val & PIPE_SERVER)
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (mode), TRUE);
  gtk_signal_connect (GTK_OBJECT (mode), "activate",
		      (GtkSignalFunc)on_toggle_pipe,
		      (gpointer)PIPE_SERVER);

  return mode_popup;
}

