#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netdb.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "browse.h"
#include "share.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "about.h"

typedef struct {
  int timeout;
  int progress;
  GtkWidget* area;
  GdkGC *gc;
  int func;
  int color;
} about_t;

void func1(about_t* about, int progress, int* x, int* y) {
  int width, height;
  int width2, height2;
  double val;

  width = about->area->allocation.width;
  height = about->area->allocation.height;
  width2 = width/2;
  height2 = height/2;
  
  val = (double)(progress)/100;
  *x = width2 + sin(12*val)*width2*0.50 + 
    sin(29*val)*width2*0.40;
  *y = height2 + cos(12*val)*height2*0.50 + 
    cos(29*val)*height2*0.40;
}

void func2(about_t* about, int progress, int* x, int* y) {
  int width, height;
  int width2, height2;
  double val;

  width = about->area->allocation.width;
  height = about->area->allocation.height;
  width2 = width/2;
  height2 = height/2;
  
  val = (double)(progress)/100;
  *x = width2 + sin(12*val)*width2*0.90;
  *y = height2 + cos(23*val)*height2*0.90;
}

void func(about_t* about, int progress, int* x, int* y) {
  switch (about->func) {
  case 0: func1(about, progress, x, y);break;
  case 1: func2(about, progress, x, y);break;
  }
}

int about_timeout(gpointer data) {
  about_t* about;
  int x1,y1, x2,y2;
  GdkColor color;
  gushort *red, *green, *blue;
  int progress;

  about = (about_t*)data;

  if (!about->gc) about->gc = gdk_gc_new(about->area->window);

  color.pixel = 0;
  about->progress++;
  if (about->progress%2000 == 0) about->color++;
  if (about->color>2) about->color = 0;
  switch (about->color) {
  case 0:
    red = &color.red;
    green = &color.green;
    blue = &color.blue;
    break;
  case 1:
    red = &color.green;
    green = &color.red;
    blue = &color.blue;
    break;
  case 2:
  default:
    red = &color.blue;
    green = &color.green;
    blue = &color.red;
    break;
  }
  *red = 30000+random()%35536;
  *green = random()%30000;
  *blue = random()%30000;

  gdk_color_alloc(gtk_widget_get_colormap(about->area), &color);
  gdk_gc_set_foreground(about->gc, &color);

  progress = random();
  func(about, progress, &x1, &y1);
  progress++;
  func(about, progress, &x2, &y2);
  //  printf("%d %d %d %d\n", x1,y1,x2,y2);
  gdk_draw_line(about->area->window, about->gc, 
		x1, y1, x2, y2);
  

  return 1;
}


void about_destroy(about_t* about) {
  gtk_timeout_remove(about->timeout);
  free(about);
}

void about_show() {
  GtkWidget* win;
  GtkWidget* temp;
  about_t* about;

  win = create_about_win();
  gtk_widget_show(win);

  temp = lookup_widget(win, "drawingarea10");
  
  about = (about_t*)malloc(sizeof(about_t));
  about->timeout = gtk_timeout_add(10, about_timeout, about);
  about->area = temp;
  about->progress = 0;
  about->gc = NULL;
  about->func = random()%2;
  about->color = random()%3;
  gtk_object_set_data_full(GTK_OBJECT(temp), "about", about, 
			   (GtkDestroyNotify)about_destroy);
}
