char* extract_filename(char* filename);
char* status_names(int status);
void convert_local_name(char* fname);

GtkWidget* create_upload_popup(transfer_t* transfer);
GtkWidget* create_download_popup(transfer_t* transfer);

int check_dcc_message(char *from, char *message);
transfer_t* transfer_new();
void transfer_destroy(transfer_t* transfer);
void transfer_set_md5(transfer_t* transfer, char* md5);
int transfer_in_progress(transfer_t* transfer);
int transfer_is_active(transfer_t* transfer);
int transfer_status_dist(int s1, int s2);
void transfer_status_set(socket_t* socket, int status);
void transfer_connect_and_start(socket_t* socket);

file_t* lib_search_transfer(transfer_t* transfer);

void download_start(socket_t* socket, int force);
void upload_start(socket_t* socket);
void download_file(file_t* file, int withdir);
void cmd_download_ack(char* data);
void cmd_upload_request(char* data);
void cmd_alternate_ack(char* data);

socket_t* transfer_is_in_download(char* user, char* winname);
socket_t* transfer_is_in_upload(char* user, char* winname);
int transfer_update(socket_t* socket, int full);

void transfer_insert(socket_t *socket);

int connect_to_user(socket_t* socket);
void cmd_get_error(char* data);
void cmd_remote_queued(char* data);
int global_timer(gpointer data);
void cmd_linkspeed_response(char* data);

FILE* open_download_file(transfer_t* transfer);
FILE* open_upload_file(transfer_t* transfer);

void transfer_end(transfer_t* transfer, int mode);

// outgoing
gint await_conn_ack(gpointer data, gint source, 
		    GdkInputCondition condition);
gint send_transfer_info(gpointer data, gint source, 
			GdkInputCondition condition);
gint get_transfer_info(gpointer data, gint source, 
		       GdkInputCondition condition);

// incoming
gint get_upload_info(gpointer data, gint source, 
		     GdkInputCondition condition);
gint get_download_info(gpointer data, gint source, 
		       GdkInputCondition condition);

//
gint upload_push_output(gpointer data, gint source, 
			GdkInputCondition condition);
gint download_get_input(gpointer data, gint source, 
			GdkInputCondition condition);

int transfer_timeout_cb(gpointer data);
int transfer_remote_timeout(gpointer data);

user_info_t* detect_user_info(char* user, int in_download);
void change_user_info(char* user, int max);

void downloads_disable();
void downloads_enable();
void uploads_disable();
void uploads_enable();
void transfer_clist_remove(socket_t* socket);
int transfer_to_destroy(socket_t* socket, int mode);
int transfer_to_retry(int mode);
int transfer_to_delete(transfer_t* transfer, int mode);

GtkWidget* create_ul_remove_popup (int val);
void on_toggle_ul_remove(GtkMenuItem     *menuitem,
			 gpointer         user_data);
GtkWidget* create_retry_popup (int val);
void on_toggle_autoretry(GtkMenuItem     *menuitem,
			 gpointer         user_data);
GtkWidget* create_dl_remove_popup (int val);
void on_toggle_dl_remove(GtkMenuItem     *menuitem,
			 gpointer         user_data);
GtkWidget* create_autodelete_popup (int val);
void on_toggle_autodelete(GtkMenuItem     *menuitem,
			  gpointer         user_data);
int transfer_grab_resume(transfer_t* transfer, resume_t* resume);
void transfer_ungrab_resume(transfer_t* transfer, int mode);
resume_t* transfer_create_resume(transfer_t* transfer);
