GtkWidget* create_search_list_popup(file_t* file);

gint search_compare (GtkCList      *clist,
		     gconstpointer  ptr1,
		     gconstpointer  ptr2);

char* Destination(int id);
int destination2int(char* dest);
void cmd_search_response(char* data);
void cmd_end_of_search();
file_t* file_create_from_search_response(char* data);
void send_search_request();
void file_insert_search(file_t *file, int destination);

void napster_search(search_pattern_t* pattern, int local);

// creates a new search pattern
search_pattern_t* 
search_pattern_new(char* name);

// checks, whether the file matches the pattern
int 
search_pattern_fits_file(search_pattern_t* search, file_t* file,
			 int with_type);

// search the pattern <iname> in global pattern list
search_pattern_t* 
search_pattern_find(char* iname);

// load all saved pattern into global list
void 
search_pattern_load();

// save global pattern list to disk
void 
search_pattern_save();

// create and copy to new pattern
search_pattern_t* 
search_pattern_copy(search_pattern_t* search);

// delete pattern from global list
void 
search_pattern_delete();

// rename current pattern
void 
search_pattern_rename_current(char* new_name);

// save current pattern
void 
search_pattern_save_current();

// display pattern in search fields
void 
search_pattern_show(search_pattern_t* search);

// allocating new search
search_t* 
search_new();

// finding free search id
int 
search_find_free_id();

// find search by id
search_t* 
search_find(int id);

void search_clear(search_t* search);

// destroying search
void search_destroy(search_t* search);

// removing search from global list
void 
search_remove(search_t* search);

void
search_update_stats(search_t* search);

void
search_update_counter();

GtkWidget*
search_fields_detach();

void search_search(search_pattern_t* pattern);
